@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BackupPolicy].
 */
@PulumiTagMarker
public class BackupPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupPolicyArgs = BackupPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupPolicyArgsBuilder.() -> Unit) {
        val builder = BackupPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BackupPolicy {
        val builtJavaResource = com.pulumi.alicloud.clickhouse.BackupPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BackupPolicy(builtJavaResource)
    }
}

/**
 * Provides a Click House Backup Policy resource.
 * For information about Click House Backup Policy and how to use it, see [What is Backup Policy](https://www.alibabacloud.com/help/zh/clickhouse/latest/api-clickhouse-2019-11-11-createbackuppolicy).
 * > **NOTE:** Available since v1.147.0.
 * > **NOTE:** Only the cloud database ClickHouse cluster version `20.3` supports data backup.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.clickhouse.getRegions({
 *     current: true,
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.regions?.[0]?&#46;zoneIds?&#46;[0]?.zoneId),
 * });
 * const defaultDbCluster = new alicloud.clickhouse.DbCluster("default", {
 *     dbClusterVersion: "22.8.5.29",
 *     status: "Running",
 *     category: "Basic",
 *     dbClusterClass: "S8",
 *     dbClusterNetworkType: "vpc",
 *     dbNodeGroupCount: 1,
 *     paymentType: "PayAsYouGo",
 *     dbNodeStorage: "500",
 *     storageType: "cloud_essd",
 *     vswitchId: defaultSwitch.id,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultBackupPolicy = new alicloud.clickhouse.BackupPolicy("default", {
 *     dbClusterId: defaultDbCluster.id,
 *     preferredBackupPeriods: [
 *         "Monday",
 *         "Friday",
 *     ],
 *     preferredBackupTime: "00:00Z-01:00Z",
 *     backupRetentionPeriod: 7,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.clickhouse.get_regions(current=True)
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.regions[0]&#46;zone_ids[0].zone_id)
 * default_db_cluster = alicloud.clickhouse.DbCluster("default",
 *     db_cluster_version="22.8.5.29",
 *     status="Running",
 *     category="Basic",
 *     db_cluster_class="S8",
 *     db_cluster_network_type="vpc",
 *     db_node_group_count=1,
 *     payment_type="PayAsYouGo",
 *     db_node_storage="500",
 *     storage_type="cloud_essd",
 *     vswitch_id=default_switch.id,
 *     vpc_id=default_network.id)
 * default_backup_policy = alicloud.clickhouse.BackupPolicy("default",
 *     db_cluster_id=default_db_cluster.id,
 *     preferred_backup_periods=[
 *         "Monday",
 *         "Friday",
 *     ],
 *     preferred_backup_time="00:00Z-01:00Z",
 *     backup_retention_period=7)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ClickHouse.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?&#46;ZoneIds[0]?.ZoneId)),
 *     });
 *     var defaultDbCluster = new AliCloud.ClickHouse.DbCluster("default", new()
 *     {
 *         DbClusterVersion = "22.8.5.29",
 *         Status = "Running",
 *         Category = "Basic",
 *         DbClusterClass = "S8",
 *         DbClusterNetworkType = "vpc",
 *         DbNodeGroupCount = 1,
 *         PaymentType = "PayAsYouGo",
 *         DbNodeStorage = "500",
 *         StorageType = "cloud_essd",
 *         VswitchId = defaultSwitch.Id,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultBackupPolicy = new AliCloud.ClickHouse.BackupPolicy("default", new()
 *     {
 *         DbClusterId = defaultDbCluster.Id,
 *         PreferredBackupPeriods = new[]
 *         {
 *             "Monday",
 *             "Friday",
 *         },
 *         PreferredBackupTime = "00:00Z-01:00Z",
 *         BackupRetentionPeriod = 7,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/clickhouse"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := clickhouse.GetRegions(ctx, &clickhouse.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Regions[0]&#46;ZoneIds[0].ZoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultDbCluster, err := clickhouse.NewDbCluster(ctx, "default", &clickhouse.DbClusterArgs{
 * 			DbClusterVersion:     pulumi.String("22.8.5.29"),
 * 			Status:               pulumi.String("Running"),
 * 			Category:             pulumi.String("Basic"),
 * 			DbClusterClass:       pulumi.String("S8"),
 * 			DbClusterNetworkType: pulumi.String("vpc"),
 * 			DbNodeGroupCount:     pulumi.Int(1),
 * 			PaymentType:          pulumi.String("PayAsYouGo"),
 * 			DbNodeStorage:        pulumi.String("500"),
 * 			StorageType:          pulumi.String("cloud_essd"),
 * 			VswitchId:            defaultSwitch.ID(),
 * 			VpcId:                defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = clickhouse.NewBackupPolicy(ctx, "default", &clickhouse.BackupPolicyArgs{
 * 			DbClusterId: defaultDbCluster.ID(),
 * 			PreferredBackupPeriods: pulumi.StringArray{
 * 				pulumi.String("Monday"),
 * 				pulumi.String("Friday"),
 * 			},
 * 			PreferredBackupTime:   pulumi.String("00:00Z-01:00Z"),
 * 			BackupRetentionPeriod: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.clickhouse.ClickhouseFunctions;
 * import com.pulumi.alicloud.clickhouse.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.clickhouse.DbCluster;
 * import com.pulumi.alicloud.clickhouse.DbClusterArgs;
 * import com.pulumi.alicloud.clickhouse.BackupPolicy;
 * import com.pulumi.alicloud.clickhouse.BackupPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ClickhouseFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.regions()[0]&#46;zoneIds()[0].zoneId())
 *             .build());
 *         var defaultDbCluster = new DbCluster("defaultDbCluster", DbClusterArgs.builder()
 *             .dbClusterVersion("22.8.5.29")
 *             .status("Running")
 *             .category("Basic")
 *             .dbClusterClass("S8")
 *             .dbClusterNetworkType("vpc")
 *             .dbNodeGroupCount("1")
 *             .paymentType("PayAsYouGo")
 *             .dbNodeStorage("500")
 *             .storageType("cloud_essd")
 *             .vswitchId(defaultSwitch.id())
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultBackupPolicy = new BackupPolicy("defaultBackupPolicy", BackupPolicyArgs.builder()
 *             .dbClusterId(defaultDbCluster.id())
 *             .preferredBackupPeriods(
 *                 "Monday",
 *                 "Friday")
 *             .preferredBackupTime("00:00Z-01:00Z")
 *             .backupRetentionPeriod(7)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.regions[0]&#46;zoneIds[0].zoneId}
 *   defaultDbCluster:
 *     type: alicloud:clickhouse:DbCluster
 *     name: default
 *     properties:
 *       dbClusterVersion: 22.8.5.29
 *       status: Running
 *       category: Basic
 *       dbClusterClass: S8
 *       dbClusterNetworkType: vpc
 *       dbNodeGroupCount: '1'
 *       paymentType: PayAsYouGo
 *       dbNodeStorage: '500'
 *       storageType: cloud_essd
 *       vswitchId: ${defaultSwitch.id}
 *       vpcId: ${defaultNetwork.id}
 *   defaultBackupPolicy:
 *     type: alicloud:clickhouse:BackupPolicy
 *     name: default
 *     properties:
 *       dbClusterId: ${defaultDbCluster.id}
 *       preferredBackupPeriods:
 *         - Monday
 *         - Friday
 *       preferredBackupTime: 00:00Z-01:00Z
 *       backupRetentionPeriod: 7
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:clickhouse:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Click House Backup Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:clickhouse/backupPolicy:BackupPolicy example <db_cluster_id>
 * ```
 */
public class BackupPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.clickhouse.BackupPolicy,
) : KotlinCustomResource(javaResource, BackupPolicyMapper) {
    /**
     * Data backup days. Valid values: `7` to `730`.
     */
    public val backupRetentionPeriod: Output<Int>?
        get() = javaResource.backupRetentionPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of the DBCluster.
     */
    public val dbClusterId: Output<String>
        get() = javaResource.dbClusterId().applyValue({ args0 -> args0 })

    /**
     * DBCluster Backup period. A list of DBCluster Backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
     */
    public val preferredBackupPeriods: Output<List<String>>
        get() = javaResource.preferredBackupPeriods().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * DBCluster backup time, in the format of `HH:mmZ-HH:mmZ`. Time setting interval is one hour. China time is 8 hours behind it.
     */
    public val preferredBackupTime: Output<String>
        get() = javaResource.preferredBackupTime().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object BackupPolicyMapper : ResourceMapper<BackupPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.clickhouse.BackupPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BackupPolicy = BackupPolicy(
        javaResource as
            com.pulumi.alicloud.clickhouse.BackupPolicy,
    )
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackupPolicy].
 */
public suspend fun backupPolicy(
    name: String,
    block: suspend BackupPolicyResourceBuilder.() -> Unit,
): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backupPolicy(name: String): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
