@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin

import com.pulumi.alicloud.clickhouse.kotlin.outputs.DbClusterDbClusterAccessWhiteList
import com.pulumi.alicloud.clickhouse.kotlin.outputs.DbClusterMultiZoneVswitchList
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.clickhouse.kotlin.outputs.DbClusterDbClusterAccessWhiteList.Companion.toKotlin as dbClusterDbClusterAccessWhiteListToKotlin
import com.pulumi.alicloud.clickhouse.kotlin.outputs.DbClusterMultiZoneVswitchList.Companion.toKotlin as dbClusterMultiZoneVswitchListToKotlin

/**
 * Builder for [DbCluster].
 */
@PulumiTagMarker
public class DbClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DbClusterArgs = DbClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DbClusterArgsBuilder.() -> Unit) {
        val builder = DbClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DbCluster {
        val builtJavaResource = com.pulumi.alicloud.clickhouse.DbCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DbCluster(builtJavaResource)
    }
}

/**
 * Provides a Click House DBCluster resource.
 * For information about Click House DBCluster and how to use it, see [What is DBCluster](https://www.alibabacloud.com/help/zh/clickhouse/latest/api-clickhouse-2019-11-11-createdbinstance).
 * > **NOTE:** Available since v1.134.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-hangzhou";
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.clickhouse.getRegions({
 *     regionId: region,
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.regions?.[0]?&#46;zoneIds?&#46;[0]?.zoneId),
 * });
 * const defaultDbCluster = new alicloud.clickhouse.DbCluster("default", {
 *     dbClusterVersion: "23.8",
 *     category: "Basic",
 *     dbClusterClass: "S8",
 *     dbClusterNetworkType: "vpc",
 *     dbNodeGroupCount: 1,
 *     paymentType: "PayAsYouGo",
 *     dbNodeStorage: "100",
 *     storageType: "cloud_essd",
 *     vswitchId: defaultSwitch.id,
 *     vpcId: defaultNetwork.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.clickhouse.get_regions(region_id=region)
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.regions[0]&#46;zone_ids[0].zone_id)
 * default_db_cluster = alicloud.clickhouse.DbCluster("default",
 *     db_cluster_version="23.8",
 *     category="Basic",
 *     db_cluster_class="S8",
 *     db_cluster_network_type="vpc",
 *     db_node_group_count=1,
 *     payment_type="PayAsYouGo",
 *     db_node_storage="100",
 *     storage_type="cloud_essd",
 *     vswitch_id=default_switch.id,
 *     vpc_id=default_network.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ClickHouse.GetRegions.Invoke(new()
 *     {
 *         RegionId = region,
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?&#46;ZoneIds[0]?.ZoneId)),
 *     });
 *     var defaultDbCluster = new AliCloud.ClickHouse.DbCluster("default", new()
 *     {
 *         DbClusterVersion = "23.8",
 *         Category = "Basic",
 *         DbClusterClass = "S8",
 *         DbClusterNetworkType = "vpc",
 *         DbNodeGroupCount = 1,
 *         PaymentType = "PayAsYouGo",
 *         DbNodeStorage = "100",
 *         StorageType = "cloud_essd",
 *         VswitchId = defaultSwitch.Id,
 *         VpcId = defaultNetwork.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/clickhouse"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := clickhouse.GetRegions(ctx, &clickhouse.GetRegionsArgs{
 * 			RegionId: pulumi.StringRef(region),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Regions[0]&#46;ZoneIds[0].ZoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = clickhouse.NewDbCluster(ctx, "default", &clickhouse.DbClusterArgs{
 * 			DbClusterVersion:     pulumi.String("23.8"),
 * 			Category:             pulumi.String("Basic"),
 * 			DbClusterClass:       pulumi.String("S8"),
 * 			DbClusterNetworkType: pulumi.String("vpc"),
 * 			DbNodeGroupCount:     pulumi.Int(1),
 * 			PaymentType:          pulumi.String("PayAsYouGo"),
 * 			DbNodeStorage:        pulumi.String("100"),
 * 			StorageType:          pulumi.String("cloud_essd"),
 * 			VswitchId:            defaultSwitch.ID(),
 * 			VpcId:                defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.clickhouse.ClickhouseFunctions;
 * import com.pulumi.alicloud.clickhouse.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.clickhouse.DbCluster;
 * import com.pulumi.alicloud.clickhouse.DbClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ClickhouseFunctions.getRegions(GetRegionsArgs.builder()
 *             .regionId(region)
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.regions()[0]&#46;zoneIds()[0].zoneId())
 *             .build());
 *         var defaultDbCluster = new DbCluster("defaultDbCluster", DbClusterArgs.builder()
 *             .dbClusterVersion("23.8")
 *             .category("Basic")
 *             .dbClusterClass("S8")
 *             .dbClusterNetworkType("vpc")
 *             .dbNodeGroupCount("1")
 *             .paymentType("PayAsYouGo")
 *             .dbNodeStorage("100")
 *             .storageType("cloud_essd")
 *             .vswitchId(defaultSwitch.id())
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-hangzhou
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.regions[0]&#46;zoneIds[0].zoneId}
 *   defaultDbCluster:
 *     type: alicloud:clickhouse:DbCluster
 *     name: default
 *     properties:
 *       dbClusterVersion: '23.8'
 *       category: Basic
 *       dbClusterClass: S8
 *       dbClusterNetworkType: vpc
 *       dbNodeGroupCount: '1'
 *       paymentType: PayAsYouGo
 *       dbNodeStorage: '100'
 *       storageType: cloud_essd
 *       vswitchId: ${defaultSwitch.id}
 *       vpcId: ${defaultNetwork.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:clickhouse:getRegions
 *       Arguments:
 *         regionId: ${region}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Click House DBCluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:clickhouse/dbCluster:DbCluster example <id>
 * ```
 */
public class DbCluster internal constructor(
    override val javaResource: com.pulumi.alicloud.clickhouse.DbCluster,
) : KotlinCustomResource(javaResource, DbClusterMapper) {
    /**
     * The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.196.0) - The connection string of the cluster.
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * The db cluster access white list. See `db_cluster_access_white_list` below.
     */
    public val dbClusterAccessWhiteLists: Output<List<DbClusterDbClusterAccessWhiteList>>?
        get() = javaResource.dbClusterAccessWhiteLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        dbClusterDbClusterAccessWhiteListToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The DBCluster class. According to the category, db_cluster_class has two value ranges:
     * * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
     * * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
     */
    public val dbClusterClass: Output<String>
        get() = javaResource.dbClusterClass().applyValue({ args0 -> args0 })

    /**
     * The DBCluster description.
     */
    public val dbClusterDescription: Output<String>
        get() = javaResource.dbClusterDescription().applyValue({ args0 -> args0 })

    /**
     * The DBCluster network type. Valid values: `vpc`.
     */
    public val dbClusterNetworkType: Output<String>
        get() = javaResource.dbClusterNetworkType().applyValue({ args0 -> args0 })

    /**
     * The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`, `23.8`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
     */
    public val dbClusterVersion: Output<String>
        get() = javaResource.dbClusterVersion().applyValue({ args0 -> args0 })

    /**
     * The db node group count. The number should between 1 and 48.
     */
    public val dbNodeGroupCount: Output<Int>
        get() = javaResource.dbNodeGroupCount().applyValue({ args0 -> args0 })

    /**
     * The db node storage.
     */
    public val dbNodeStorage: Output<String>
        get() = javaResource.dbNodeStorage().applyValue({ args0 -> args0 })

    /**
     * Key management service KMS key ID. It is valid and required when encryption_type is `CloudDisk`.
     */
    public val encryptionKey: Output<String>?
        get() = javaResource.encryptionKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
     */
    public val encryptionType: Output<String>?
        get() = javaResource.encryptionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
     */
    public val maintainTime: Output<String>
        get() = javaResource.maintainTime().applyValue({ args0 -> args0 })

    /**
     * The zone IDs and
     * corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
     */
    public val multiZoneVswitchLists: Output<List<DbClusterMultiZoneVswitchList>>?
        get() = javaResource.multiZoneVswitchLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        dbClusterMultiZoneVswitchListToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * Pre-paid cluster of the pay-as-you-go cycle. It is valid and required when payment_type is `Subscription`. Valid values: `Month`, `Year`.
     */
    public val period: Output<String>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * (Available since v1.196.0) The connection port of the cluster.
     */
    public val port: Output<String>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * The renewal status of the resource. Valid values: `AutoRenewal`,`Normal`. It is valid and required when payment_type is `Subscription`. When `renewal_status` is set to `AutoRenewal`, the resource is renewed automatically.
     */
    public val renewalStatus: Output<String>
        get() = javaResource.renewalStatus().applyValue({ args0 -> args0 })

    /**
     * The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
     */
    public val storageType: Output<String>
        get() = javaResource.storageType().applyValue({ args0 -> args0 })

    /**
     * The used time of DBCluster. It is valid and required when payment_type is `Subscription`. item choices: [1-9] when period is `Month`, [1-3] when period is `Year`.
     */
    public val usedTime: Output<String>?
        get() = javaResource.usedTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The id of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The vswitch id of DBCluster.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The zone ID of the instance.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object DbClusterMapper : ResourceMapper<DbCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.clickhouse.DbCluster::class == javaResource::class

    override fun map(javaResource: Resource): DbCluster = DbCluster(
        javaResource as
            com.pulumi.alicloud.clickhouse.DbCluster,
    )
}

/**
 * @see [DbCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DbCluster].
 */
public suspend fun dbCluster(name: String, block: suspend DbClusterResourceBuilder.() -> Unit): DbCluster {
    val builder = DbClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DbCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dbCluster(name: String): DbCluster {
    val builder = DbClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
