@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin

import com.pulumi.alicloud.clickhouse.DbClusterArgs.builder
import com.pulumi.alicloud.clickhouse.kotlin.inputs.DbClusterDbClusterAccessWhiteListArgs
import com.pulumi.alicloud.clickhouse.kotlin.inputs.DbClusterDbClusterAccessWhiteListArgsBuilder
import com.pulumi.alicloud.clickhouse.kotlin.inputs.DbClusterMultiZoneVswitchListArgs
import com.pulumi.alicloud.clickhouse.kotlin.inputs.DbClusterMultiZoneVswitchListArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Click House DBCluster resource.
 * For information about Click House DBCluster and how to use it, see [What is DBCluster](https://www.alibabacloud.com/help/zh/clickhouse/latest/api-clickhouse-2019-11-11-createdbinstance).
 * > **NOTE:** Available since v1.134.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-hangzhou";
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.clickhouse.getRegions({
 *     regionId: region,
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.regions?.[0]?&#46;zoneIds?&#46;[0]?.zoneId),
 * });
 * const defaultDbCluster = new alicloud.clickhouse.DbCluster("default", {
 *     dbClusterVersion: "23.8",
 *     category: "Basic",
 *     dbClusterClass: "S8",
 *     dbClusterNetworkType: "vpc",
 *     dbNodeGroupCount: 1,
 *     paymentType: "PayAsYouGo",
 *     dbNodeStorage: "100",
 *     storageType: "cloud_essd",
 *     vswitchId: defaultSwitch.id,
 *     vpcId: defaultNetwork.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.clickhouse.get_regions(region_id=region)
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.regions[0]&#46;zone_ids[0].zone_id)
 * default_db_cluster = alicloud.clickhouse.DbCluster("default",
 *     db_cluster_version="23.8",
 *     category="Basic",
 *     db_cluster_class="S8",
 *     db_cluster_network_type="vpc",
 *     db_node_group_count=1,
 *     payment_type="PayAsYouGo",
 *     db_node_storage="100",
 *     storage_type="cloud_essd",
 *     vswitch_id=default_switch.id,
 *     vpc_id=default_network.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ClickHouse.GetRegions.Invoke(new()
 *     {
 *         RegionId = region,
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?&#46;ZoneIds[0]?.ZoneId)),
 *     });
 *     var defaultDbCluster = new AliCloud.ClickHouse.DbCluster("default", new()
 *     {
 *         DbClusterVersion = "23.8",
 *         Category = "Basic",
 *         DbClusterClass = "S8",
 *         DbClusterNetworkType = "vpc",
 *         DbNodeGroupCount = 1,
 *         PaymentType = "PayAsYouGo",
 *         DbNodeStorage = "100",
 *         StorageType = "cloud_essd",
 *         VswitchId = defaultSwitch.Id,
 *         VpcId = defaultNetwork.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/clickhouse"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := clickhouse.GetRegions(ctx, &clickhouse.GetRegionsArgs{
 * 			RegionId: pulumi.StringRef(region),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Regions[0]&#46;ZoneIds[0].ZoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = clickhouse.NewDbCluster(ctx, "default", &clickhouse.DbClusterArgs{
 * 			DbClusterVersion:     pulumi.String("23.8"),
 * 			Category:             pulumi.String("Basic"),
 * 			DbClusterClass:       pulumi.String("S8"),
 * 			DbClusterNetworkType: pulumi.String("vpc"),
 * 			DbNodeGroupCount:     pulumi.Int(1),
 * 			PaymentType:          pulumi.String("PayAsYouGo"),
 * 			DbNodeStorage:        pulumi.String("100"),
 * 			StorageType:          pulumi.String("cloud_essd"),
 * 			VswitchId:            defaultSwitch.ID(),
 * 			VpcId:                defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.clickhouse.ClickhouseFunctions;
 * import com.pulumi.alicloud.clickhouse.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.clickhouse.DbCluster;
 * import com.pulumi.alicloud.clickhouse.DbClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ClickhouseFunctions.getRegions(GetRegionsArgs.builder()
 *             .regionId(region)
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.regions()[0]&#46;zoneIds()[0].zoneId())
 *             .build());
 *         var defaultDbCluster = new DbCluster("defaultDbCluster", DbClusterArgs.builder()
 *             .dbClusterVersion("23.8")
 *             .category("Basic")
 *             .dbClusterClass("S8")
 *             .dbClusterNetworkType("vpc")
 *             .dbNodeGroupCount("1")
 *             .paymentType("PayAsYouGo")
 *             .dbNodeStorage("100")
 *             .storageType("cloud_essd")
 *             .vswitchId(defaultSwitch.id())
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-hangzhou
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.regions[0]&#46;zoneIds[0].zoneId}
 *   defaultDbCluster:
 *     type: alicloud:clickhouse:DbCluster
 *     name: default
 *     properties:
 *       dbClusterVersion: '23.8'
 *       category: Basic
 *       dbClusterClass: S8
 *       dbClusterNetworkType: vpc
 *       dbNodeGroupCount: '1'
 *       paymentType: PayAsYouGo
 *       dbNodeStorage: '100'
 *       storageType: cloud_essd
 *       vswitchId: ${defaultSwitch.id}
 *       vpcId: ${defaultNetwork.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:clickhouse:getRegions
 *       Arguments:
 *         regionId: ${region}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Click House DBCluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:clickhouse/dbCluster:DbCluster example <id>
 * ```
 * @property category The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
 * @property dbClusterAccessWhiteLists The db cluster access white list. See `db_cluster_access_white_list` below.
 * @property dbClusterClass The DBCluster class. According to the category, db_cluster_class has two value ranges:
 * * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
 * * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
 * @property dbClusterDescription The DBCluster description.
 * @property dbClusterNetworkType The DBCluster network type. Valid values: `vpc`.
 * @property dbClusterVersion The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`, `23.8`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
 * @property dbNodeGroupCount The db node group count. The number should between 1 and 48.
 * @property dbNodeStorage The db node storage.
 * @property encryptionKey Key management service KMS key ID. It is valid and required when encryption_type is `CloudDisk`.
 * @property encryptionType Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
 * @property maintainTime The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
 * @property multiZoneVswitchLists The zone IDs and
 * corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
 * @property paymentType The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
 * @property period Pre-paid cluster of the pay-as-you-go cycle. It is valid and required when payment_type is `Subscription`. Valid values: `Month`, `Year`.
 * @property renewalStatus The renewal status of the resource. Valid values: `AutoRenewal`,`Normal`. It is valid and required when payment_type is `Subscription`. When `renewal_status` is set to `AutoRenewal`, the resource is renewed automatically.
 * @property status The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
 * @property storageType Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
 * @property usedTime The used time of DBCluster. It is valid and required when payment_type is `Subscription`. item choices: [1-9] when period is `Month`, [1-3] when period is `Year`.
 * @property vpcId The id of the VPC.
 * @property vswitchId The vswitch id of DBCluster.
 * @property zoneId The zone ID of the instance.
 */
public data class DbClusterArgs(
    public val category: Output<String>? = null,
    public val dbClusterAccessWhiteLists: Output<List<DbClusterDbClusterAccessWhiteListArgs>>? = null,
    public val dbClusterClass: Output<String>? = null,
    public val dbClusterDescription: Output<String>? = null,
    public val dbClusterNetworkType: Output<String>? = null,
    public val dbClusterVersion: Output<String>? = null,
    public val dbNodeGroupCount: Output<Int>? = null,
    public val dbNodeStorage: Output<String>? = null,
    public val encryptionKey: Output<String>? = null,
    public val encryptionType: Output<String>? = null,
    public val maintainTime: Output<String>? = null,
    public val multiZoneVswitchLists: Output<List<DbClusterMultiZoneVswitchListArgs>>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<String>? = null,
    public val renewalStatus: Output<String>? = null,
    public val status: Output<String>? = null,
    public val storageType: Output<String>? = null,
    public val usedTime: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.clickhouse.DbClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.clickhouse.DbClusterArgs =
        com.pulumi.alicloud.clickhouse.DbClusterArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .dbClusterAccessWhiteLists(
                dbClusterAccessWhiteLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dbClusterClass(dbClusterClass?.applyValue({ args0 -> args0 }))
            .dbClusterDescription(dbClusterDescription?.applyValue({ args0 -> args0 }))
            .dbClusterNetworkType(dbClusterNetworkType?.applyValue({ args0 -> args0 }))
            .dbClusterVersion(dbClusterVersion?.applyValue({ args0 -> args0 }))
            .dbNodeGroupCount(dbNodeGroupCount?.applyValue({ args0 -> args0 }))
            .dbNodeStorage(dbNodeStorage?.applyValue({ args0 -> args0 }))
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0 }))
            .encryptionType(encryptionType?.applyValue({ args0 -> args0 }))
            .maintainTime(maintainTime?.applyValue({ args0 -> args0 }))
            .multiZoneVswitchLists(
                multiZoneVswitchLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .usedTime(usedTime?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbClusterArgs].
 */
@PulumiTagMarker
public class DbClusterArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var dbClusterAccessWhiteLists: Output<List<DbClusterDbClusterAccessWhiteListArgs>>? = null

    private var dbClusterClass: Output<String>? = null

    private var dbClusterDescription: Output<String>? = null

    private var dbClusterNetworkType: Output<String>? = null

    private var dbClusterVersion: Output<String>? = null

    private var dbNodeGroupCount: Output<Int>? = null

    private var dbNodeStorage: Output<String>? = null

    private var encryptionKey: Output<String>? = null

    private var encryptionType: Output<String>? = null

    private var maintainTime: Output<String>? = null

    private var multiZoneVswitchLists: Output<List<DbClusterMultiZoneVswitchListArgs>>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<String>? = null

    private var renewalStatus: Output<String>? = null

    private var status: Output<String>? = null

    private var storageType: Output<String>? = null

    private var usedTime: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
     */
    @JvmName("rxohkrrnlelqldls")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The db cluster access white list. See `db_cluster_access_white_list` below.
     */
    @JvmName("uphvbotrbpmrcnpl")
    public suspend fun dbClusterAccessWhiteLists(`value`: Output<List<DbClusterDbClusterAccessWhiteListArgs>>) {
        this.dbClusterAccessWhiteLists = value
    }

    @JvmName("lxlvrwlwhwmuhotf")
    public suspend fun dbClusterAccessWhiteLists(vararg values: Output<DbClusterDbClusterAccessWhiteListArgs>) {
        this.dbClusterAccessWhiteLists = Output.all(values.asList())
    }

    /**
     * @param values The db cluster access white list. See `db_cluster_access_white_list` below.
     */
    @JvmName("ocgroivheovomyxv")
    public suspend fun dbClusterAccessWhiteLists(values: List<Output<DbClusterDbClusterAccessWhiteListArgs>>) {
        this.dbClusterAccessWhiteLists = Output.all(values)
    }

    /**
     * @param value The DBCluster class. According to the category, db_cluster_class has two value ranges:
     * * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
     * * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
     */
    @JvmName("liukvjucradfbxek")
    public suspend fun dbClusterClass(`value`: Output<String>) {
        this.dbClusterClass = value
    }

    /**
     * @param value The DBCluster description.
     */
    @JvmName("nuskukqihvxfarlh")
    public suspend fun dbClusterDescription(`value`: Output<String>) {
        this.dbClusterDescription = value
    }

    /**
     * @param value The DBCluster network type. Valid values: `vpc`.
     */
    @JvmName("dlrknfdsgevlxvxr")
    public suspend fun dbClusterNetworkType(`value`: Output<String>) {
        this.dbClusterNetworkType = value
    }

    /**
     * @param value The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`, `23.8`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
     */
    @JvmName("wybdarlxipjfckog")
    public suspend fun dbClusterVersion(`value`: Output<String>) {
        this.dbClusterVersion = value
    }

    /**
     * @param value The db node group count. The number should between 1 and 48.
     */
    @JvmName("jmftexnllcbvpggm")
    public suspend fun dbNodeGroupCount(`value`: Output<Int>) {
        this.dbNodeGroupCount = value
    }

    /**
     * @param value The db node storage.
     */
    @JvmName("uoyjdrxiwrhgnvmw")
    public suspend fun dbNodeStorage(`value`: Output<String>) {
        this.dbNodeStorage = value
    }

    /**
     * @param value Key management service KMS key ID. It is valid and required when encryption_type is `CloudDisk`.
     */
    @JvmName("pipgtevwcibllbrf")
    public suspend fun encryptionKey(`value`: Output<String>) {
        this.encryptionKey = value
    }

    /**
     * @param value Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
     */
    @JvmName("dlreolxwvkarpfxc")
    public suspend fun encryptionType(`value`: Output<String>) {
        this.encryptionType = value
    }

    /**
     * @param value The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
     */
    @JvmName("whxsynjfkprrklvk")
    public suspend fun maintainTime(`value`: Output<String>) {
        this.maintainTime = value
    }

    /**
     * @param value The zone IDs and
     * corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
     */
    @JvmName("ekxhasrmpevpcaaf")
    public suspend fun multiZoneVswitchLists(`value`: Output<List<DbClusterMultiZoneVswitchListArgs>>) {
        this.multiZoneVswitchLists = value
    }

    @JvmName("rqeasgdmpanluaij")
    public suspend fun multiZoneVswitchLists(vararg values: Output<DbClusterMultiZoneVswitchListArgs>) {
        this.multiZoneVswitchLists = Output.all(values.asList())
    }

    /**
     * @param values The zone IDs and
     * corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
     */
    @JvmName("bnivltxgsgfckouw")
    public suspend fun multiZoneVswitchLists(values: List<Output<DbClusterMultiZoneVswitchListArgs>>) {
        this.multiZoneVswitchLists = Output.all(values)
    }

    /**
     * @param value The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
     */
    @JvmName("lhnhkafmoqlopxot")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Pre-paid cluster of the pay-as-you-go cycle. It is valid and required when payment_type is `Subscription`. Valid values: `Month`, `Year`.
     */
    @JvmName("bwklwfxitqmxpwbw")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value The renewal status of the resource. Valid values: `AutoRenewal`,`Normal`. It is valid and required when payment_type is `Subscription`. When `renewal_status` is set to `AutoRenewal`, the resource is renewed automatically.
     */
    @JvmName("astohyvbyiporsyq")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
     */
    @JvmName("urjpsnoorlwvujly")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
     */
    @JvmName("tfhawrugwxubcepd")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value The used time of DBCluster. It is valid and required when payment_type is `Subscription`. item choices: [1-9] when period is `Month`, [1-3] when period is `Year`.
     */
    @JvmName("btiwuhxebhonaess")
    public suspend fun usedTime(`value`: Output<String>) {
        this.usedTime = value
    }

    /**
     * @param value The id of the VPC.
     */
    @JvmName("jcuiwwlcbbpqxdjs")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The vswitch id of DBCluster.
     */
    @JvmName("muooypwxjkfkfror")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone ID of the instance.
     */
    @JvmName("jtvnenjjisefkdaj")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
     */
    @JvmName("ijwwysaubmyddxop")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The db cluster access white list. See `db_cluster_access_white_list` below.
     */
    @JvmName("gfhfipubaijjmxlk")
    public suspend fun dbClusterAccessWhiteLists(`value`: List<DbClusterDbClusterAccessWhiteListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterAccessWhiteLists = mapped
    }

    /**
     * @param argument The db cluster access white list. See `db_cluster_access_white_list` below.
     */
    @JvmName("mnfnsgleivpunfni")
    public suspend fun dbClusterAccessWhiteLists(argument: List<suspend DbClusterDbClusterAccessWhiteListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DbClusterDbClusterAccessWhiteListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dbClusterAccessWhiteLists = mapped
    }

    /**
     * @param argument The db cluster access white list. See `db_cluster_access_white_list` below.
     */
    @JvmName("geonqyogayhbghya")
    public suspend fun dbClusterAccessWhiteLists(vararg argument: suspend DbClusterDbClusterAccessWhiteListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DbClusterDbClusterAccessWhiteListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dbClusterAccessWhiteLists = mapped
    }

    /**
     * @param argument The db cluster access white list. See `db_cluster_access_white_list` below.
     */
    @JvmName("knncptrcfdseapuu")
    public suspend fun dbClusterAccessWhiteLists(argument: suspend DbClusterDbClusterAccessWhiteListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DbClusterDbClusterAccessWhiteListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dbClusterAccessWhiteLists = mapped
    }

    /**
     * @param values The db cluster access white list. See `db_cluster_access_white_list` below.
     */
    @JvmName("kblqnhvkwimtgomk")
    public suspend fun dbClusterAccessWhiteLists(vararg values: DbClusterDbClusterAccessWhiteListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbClusterAccessWhiteLists = mapped
    }

    /**
     * @param value The DBCluster class. According to the category, db_cluster_class has two value ranges:
     * * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
     * * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
     */
    @JvmName("bcsbgbveilhtjwxq")
    public suspend fun dbClusterClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterClass = mapped
    }

    /**
     * @param value The DBCluster description.
     */
    @JvmName("qkomemnhbiaixsxi")
    public suspend fun dbClusterDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterDescription = mapped
    }

    /**
     * @param value The DBCluster network type. Valid values: `vpc`.
     */
    @JvmName("ypysgwlirnqdoodb")
    public suspend fun dbClusterNetworkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterNetworkType = mapped
    }

    /**
     * @param value The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`, `23.8`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
     */
    @JvmName("trhuhyaoivbbpkmp")
    public suspend fun dbClusterVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterVersion = mapped
    }

    /**
     * @param value The db node group count. The number should between 1 and 48.
     */
    @JvmName("baitiygtqdqipsnh")
    public suspend fun dbNodeGroupCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNodeGroupCount = mapped
    }

    /**
     * @param value The db node storage.
     */
    @JvmName("rqwxjidecwcpubqs")
    public suspend fun dbNodeStorage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNodeStorage = mapped
    }

    /**
     * @param value Key management service KMS key ID. It is valid and required when encryption_type is `CloudDisk`.
     */
    @JvmName("aomendnpcufkubit")
    public suspend fun encryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param value Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
     */
    @JvmName("axeuvlfgulcjhnak")
    public suspend fun encryptionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    /**
     * @param value The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
     */
    @JvmName("nbpnptlyssjfurpf")
    public suspend fun maintainTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainTime = mapped
    }

    /**
     * @param value The zone IDs and
     * corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
     */
    @JvmName("kfgvywntrnaesjsp")
    public suspend fun multiZoneVswitchLists(`value`: List<DbClusterMultiZoneVswitchListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiZoneVswitchLists = mapped
    }

    /**
     * @param argument The zone IDs and
     * corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
     */
    @JvmName("davriqwfojtehdtq")
    public suspend fun multiZoneVswitchLists(argument: List<suspend DbClusterMultiZoneVswitchListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DbClusterMultiZoneVswitchListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.multiZoneVswitchLists = mapped
    }

    /**
     * @param argument The zone IDs and
     * corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
     */
    @JvmName("djewqktjffyvuhqt")
    public suspend fun multiZoneVswitchLists(vararg argument: suspend DbClusterMultiZoneVswitchListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DbClusterMultiZoneVswitchListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.multiZoneVswitchLists = mapped
    }

    /**
     * @param argument The zone IDs and
     * corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
     */
    @JvmName("bdofdfumdhhtsrhl")
    public suspend fun multiZoneVswitchLists(argument: suspend DbClusterMultiZoneVswitchListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DbClusterMultiZoneVswitchListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.multiZoneVswitchLists = mapped
    }

    /**
     * @param values The zone IDs and
     * corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
     */
    @JvmName("fkmbrvdqgjsfwfdr")
    public suspend fun multiZoneVswitchLists(vararg values: DbClusterMultiZoneVswitchListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiZoneVswitchLists = mapped
    }

    /**
     * @param value The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
     */
    @JvmName("nsmuguasrxhaxbyq")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Pre-paid cluster of the pay-as-you-go cycle. It is valid and required when payment_type is `Subscription`. Valid values: `Month`, `Year`.
     */
    @JvmName("gncvxtiggmdoqswv")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The renewal status of the resource. Valid values: `AutoRenewal`,`Normal`. It is valid and required when payment_type is `Subscription`. When `renewal_status` is set to `AutoRenewal`, the resource is renewed automatically.
     */
    @JvmName("fhjojknsljeofsej")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
     */
    @JvmName("xtjxhwpcldnlnjwp")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
     */
    @JvmName("oxsecxgcoxpwbvkm")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value The used time of DBCluster. It is valid and required when payment_type is `Subscription`. item choices: [1-9] when period is `Month`, [1-3] when period is `Year`.
     */
    @JvmName("sqprsdebxlmsvxny")
    public suspend fun usedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usedTime = mapped
    }

    /**
     * @param value The id of the VPC.
     */
    @JvmName("vbclxhqbdlrndpxj")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The vswitch id of DBCluster.
     */
    @JvmName("oylpbwlrnrxvjkmp")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone ID of the instance.
     */
    @JvmName("lbdxhqaqmhnuijyv")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): DbClusterArgs = DbClusterArgs(
        category = category,
        dbClusterAccessWhiteLists = dbClusterAccessWhiteLists,
        dbClusterClass = dbClusterClass,
        dbClusterDescription = dbClusterDescription,
        dbClusterNetworkType = dbClusterNetworkType,
        dbClusterVersion = dbClusterVersion,
        dbNodeGroupCount = dbNodeGroupCount,
        dbNodeStorage = dbNodeStorage,
        encryptionKey = encryptionKey,
        encryptionType = encryptionType,
        maintainTime = maintainTime,
        multiZoneVswitchLists = multiZoneVswitchLists,
        paymentType = paymentType,
        period = period,
        renewalStatus = renewalStatus,
        status = status,
        storageType = storageType,
        usedTime = usedTime,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
