@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin.inputs

import com.pulumi.alicloud.clickhouse.inputs.DbClusterDbClusterAccessWhiteListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dbClusterIpArrayAttribute Field `db_cluster_ip_array_attribute` has been removed from provider.
 * @property dbClusterIpArrayName Whitelist group name.
 * @property securityIpList The IP address list under the whitelist group.
 */
public data class DbClusterDbClusterAccessWhiteListArgs(
    public val dbClusterIpArrayAttribute: Output<String>? = null,
    public val dbClusterIpArrayName: Output<String>? = null,
    public val securityIpList: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.clickhouse.inputs.DbClusterDbClusterAccessWhiteListArgs> {
    override fun toJava(): com.pulumi.alicloud.clickhouse.inputs.DbClusterDbClusterAccessWhiteListArgs = com.pulumi.alicloud.clickhouse.inputs.DbClusterDbClusterAccessWhiteListArgs.builder()
        .dbClusterIpArrayAttribute(dbClusterIpArrayAttribute?.applyValue({ args0 -> args0 }))
        .dbClusterIpArrayName(dbClusterIpArrayName?.applyValue({ args0 -> args0 }))
        .securityIpList(securityIpList?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbClusterDbClusterAccessWhiteListArgs].
 */
@PulumiTagMarker
public class DbClusterDbClusterAccessWhiteListArgsBuilder internal constructor() {
    private var dbClusterIpArrayAttribute: Output<String>? = null

    private var dbClusterIpArrayName: Output<String>? = null

    private var securityIpList: Output<String>? = null

    /**
     * @param value Field `db_cluster_ip_array_attribute` has been removed from provider.
     */
    @JvmName("asyjyojdpxvmkfrt")
    public suspend fun dbClusterIpArrayAttribute(`value`: Output<String>) {
        this.dbClusterIpArrayAttribute = value
    }

    /**
     * @param value Whitelist group name.
     */
    @JvmName("vfdqwoaydinsimvq")
    public suspend fun dbClusterIpArrayName(`value`: Output<String>) {
        this.dbClusterIpArrayName = value
    }

    /**
     * @param value The IP address list under the whitelist group.
     */
    @JvmName("eicjxtaetyodlvcp")
    public suspend fun securityIpList(`value`: Output<String>) {
        this.securityIpList = value
    }

    /**
     * @param value Field `db_cluster_ip_array_attribute` has been removed from provider.
     */
    @JvmName("ocwcgyaufannqlwv")
    public suspend fun dbClusterIpArrayAttribute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterIpArrayAttribute = mapped
    }

    /**
     * @param value Whitelist group name.
     */
    @JvmName("fwryjwmvcfxwoltp")
    public suspend fun dbClusterIpArrayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterIpArrayName = mapped
    }

    /**
     * @param value The IP address list under the whitelist group.
     */
    @JvmName("wbhqyrkcmvrycdqh")
    public suspend fun securityIpList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpList = mapped
    }

    internal fun build(): DbClusterDbClusterAccessWhiteListArgs =
        DbClusterDbClusterAccessWhiteListArgs(
            dbClusterIpArrayAttribute = dbClusterIpArrayAttribute,
            dbClusterIpArrayName = dbClusterIpArrayName,
            securityIpList = securityIpList,
        )
}
