@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin.inputs

import com.pulumi.alicloud.clickhouse.inputs.DbClusterMultiZoneVswitchListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property vswitchId The ID of the vswitch.
 * @property zoneId The zone ID of the vswitch.
 */
public data class DbClusterMultiZoneVswitchListArgs(
    public val vswitchId: Output<String>,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.clickhouse.inputs.DbClusterMultiZoneVswitchListArgs> {
    override fun toJava(): com.pulumi.alicloud.clickhouse.inputs.DbClusterMultiZoneVswitchListArgs =
        com.pulumi.alicloud.clickhouse.inputs.DbClusterMultiZoneVswitchListArgs.builder()
            .vswitchId(vswitchId.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbClusterMultiZoneVswitchListArgs].
 */
@PulumiTagMarker
public class DbClusterMultiZoneVswitchListArgsBuilder internal constructor() {
    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The ID of the vswitch.
     */
    @JvmName("daxjvrkuytfdnfje")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone ID of the vswitch.
     */
    @JvmName("xggynelfcbcxouqa")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The ID of the vswitch.
     */
    @JvmName("ycljmsigqlnfpaye")
    public suspend fun vswitchId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone ID of the vswitch.
     */
    @JvmName("lybasggynsdyystb")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): DbClusterMultiZoneVswitchListArgs = DbClusterMultiZoneVswitchListArgs(
        vswitchId = vswitchId ?: throw PulumiNullFieldException("vswitchId"),
        zoneId = zoneId,
    )
}
