@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin.inputs

import com.pulumi.alicloud.clickhouse.inputs.GetAccountsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccounts.
 * @property dbClusterId The DBCluster id.
 * @property ids A list of Account IDs. Its element value is same as Account Name.
 * @property nameRegex A regex string to filter results by Account name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid Status: `Creating`,`Available`,`Deleting`.
 */
public data class GetAccountsPlainArgs(
    public val dbClusterId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.clickhouse.inputs.GetAccountsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.clickhouse.inputs.GetAccountsPlainArgs =
        com.pulumi.alicloud.clickhouse.inputs.GetAccountsPlainArgs.builder()
            .dbClusterId(dbClusterId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccountsPlainArgs].
 */
@PulumiTagMarker
public class GetAccountsPlainArgsBuilder internal constructor() {
    private var dbClusterId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The DBCluster id.
     */
    @JvmName("ihyolqhqurcodnjt")
    public suspend fun dbClusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbClusterId = mapped
    }

    /**
     * @param value A list of Account IDs. Its element value is same as Account Name.
     */
    @JvmName("cmobhawxphlpauld")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Account IDs. Its element value is same as Account Name.
     */
    @JvmName("egfqdayepuoptplq")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Account name.
     */
    @JvmName("hoyyqqtlobjfgjnv")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("mmdwxddnajhwmdyv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid Status: `Creating`,`Available`,`Deleting`.
     */
    @JvmName("pedlldhebjhqkerh")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetAccountsPlainArgs = GetAccountsPlainArgs(
        dbClusterId = dbClusterId ?: throw PulumiNullFieldException("dbClusterId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
