@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin.inputs

import com.pulumi.alicloud.clickhouse.inputs.GetBackupPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBackupPolicies.
 * @property dbClusterId The db cluster id.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetBackupPoliciesPlainArgs(
    public val dbClusterId: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.clickhouse.inputs.GetBackupPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.clickhouse.inputs.GetBackupPoliciesPlainArgs =
        com.pulumi.alicloud.clickhouse.inputs.GetBackupPoliciesPlainArgs.builder()
            .dbClusterId(dbClusterId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBackupPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetBackupPoliciesPlainArgsBuilder internal constructor() {
    private var dbClusterId: String? = null

    private var outputFile: String? = null

    /**
     * @param value The db cluster id.
     */
    @JvmName("sajbacxkxbmkbilg")
    public suspend fun dbClusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbClusterId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bdaythrecpiubuyd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetBackupPoliciesPlainArgs = GetBackupPoliciesPlainArgs(
        dbClusterId = dbClusterId ?: throw PulumiNullFieldException("dbClusterId"),
        outputFile = outputFile,
    )
}
