@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin.inputs

import com.pulumi.alicloud.clickhouse.inputs.GetRegionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRegions.
 * @property current Set to true to match only the region configured in the provider. Default value: `true`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property regionId You can use specified region_id to find the region and available zones information that supports ClickHouse.
 */
public data class GetRegionsPlainArgs(
    public val current: Boolean? = null,
    public val outputFile: String? = null,
    public val regionId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.clickhouse.inputs.GetRegionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.clickhouse.inputs.GetRegionsPlainArgs =
        com.pulumi.alicloud.clickhouse.inputs.GetRegionsPlainArgs.builder()
            .current(current?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .regionId(regionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegionsPlainArgs].
 */
@PulumiTagMarker
public class GetRegionsPlainArgsBuilder internal constructor() {
    private var current: Boolean? = null

    private var outputFile: String? = null

    private var regionId: String? = null

    /**
     * @param value Set to true to match only the region configured in the provider. Default value: `true`.
     */
    @JvmName("kkrnuavuaxshcuct")
    public suspend fun current(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.current = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("lfcbdsopaqytylos")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value You can use specified region_id to find the region and available zones information that supports ClickHouse.
     */
    @JvmName("jopflmamvjwyjwki")
    public suspend fun regionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.regionId = mapped
    }

    internal fun build(): GetRegionsPlainArgs = GetRegionsPlainArgs(
        current = current,
        outputFile = outputFile,
        regionId = regionId,
    )
}
