@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property vswitchId The ID of the vswitch.
 * @property zoneId The zone ID of the vswitch.
 */
public data class DbClusterMultiZoneVswitchList(
    public val vswitchId: String,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.clickhouse.outputs.DbClusterMultiZoneVswitchList): DbClusterMultiZoneVswitchList = DbClusterMultiZoneVswitchList(
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
