@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountDescription In Chinese, English letter. May contain Chinese and English characters, lowercase letters, numbers, and underscores (_), the dash (-). Cannot start with http:// and https:// at the beginning. Length is from 2 to 256 characters.
 * @property accountName Account name: lowercase letters, numbers, underscores, lowercase letter; length no more than 16 characters.
 * @property accountType The Valid Account type: `Normal`, `Super`.
 * @property dbClusterId The DBCluster id.
 * @property id The ID of the Account. Its value is same as Queue Name.
 * @property status The status of the resource. Valid Status: `Creating`,`Available`,`Deleting`.
 */
public data class GetAccountsAccount(
    public val accountDescription: String,
    public val accountName: String,
    public val accountType: String,
    public val dbClusterId: String,
    public val id: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.clickhouse.outputs.GetAccountsAccount): GetAccountsAccount = GetAccountsAccount(
            accountDescription = javaType.accountDescription(),
            accountName = javaType.accountName(),
            accountType = javaType.accountType(),
            dbClusterId = javaType.dbClusterId(),
            id = javaType.id(),
            status = javaType.status(),
        )
    }
}
