@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backupRetentionPeriod Data backup days. Valid values: `7` to `730`.
 * @property dbClusterId The db cluster id.
 * @property id The ID of the Backup Policy.
 * @property preferredBackupPeriods DBCluster Backup period.
 * @property preferredBackupTime Backup Time, UTC time.
 * @property status The status of the resource.
 */
public data class GetBackupPoliciesPolicy(
    public val backupRetentionPeriod: Int,
    public val dbClusterId: String,
    public val id: String,
    public val preferredBackupPeriods: List<String>,
    public val preferredBackupTime: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.clickhouse.outputs.GetBackupPoliciesPolicy): GetBackupPoliciesPolicy = GetBackupPoliciesPolicy(
            backupRetentionPeriod = javaType.backupRetentionPeriod(),
            dbClusterId = javaType.dbClusterId(),
            id = javaType.id(),
            preferredBackupPeriods = javaType.preferredBackupPeriods().map({ args0 -> args0 }),
            preferredBackupTime = javaType.preferredBackupTime(),
            status = javaType.status(),
        )
    }
}
