@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBackupPolicies.
 * @property dbClusterId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property policies
 */
public data class GetBackupPoliciesResult(
    public val dbClusterId: String,
    public val id: String,
    public val outputFile: String? = null,
    public val policies: List<GetBackupPoliciesPolicy>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.clickhouse.outputs.GetBackupPoliciesResult): GetBackupPoliciesResult = GetBackupPoliciesResult(
            dbClusterId = javaType.dbClusterId(),
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.clickhouse.kotlin.outputs.GetBackupPoliciesPolicy.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
