@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aliUid Alibaba Cloud account Id.
 * @property bid The ID of the business process flow.
 * @property category Instance family values include: Basic: Basic edition; HighAvailability: high availability edition.
 * @property commodityCode The Commodity Code of the DBCluster.
 * @property connectionString Connection string.
 * @property controlVersion The control version of the DBCluster.
 * @property createTime The creation time of the resource.
 * @property dbClusterAccessWhiteLists The db cluster access white list.
 * @property dbClusterDescription The DBCluster description.
 * @property dbClusterId
 * @property dbClusterNetworkType The DBCluster network type.
 * @property dbClusterType The DBCluster type.
 * @property dbNodeClass The node class of the DBCluster.
 * @property dbNodeCount The node count of the DBCluster.
 * @property dbNodeStorage The node storage of the DBCluster.
 * @property encryptionKey Key management service KMS key ID.
 * @property encryptionType Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
 * @property engine The Engine of the DBCluster.
 * @property engineVersion The engine version of the DBCluster.
 * @property expireTime The expiration time of the DBCluster.
 * @property id The ID of the DBCluster.
 * @property isExpired If the instance has expired.
 * @property lockMode The lock mode of the DBCluster.
 * @property lockReason Lock reason of the DBCluster.
 * @property maintainTime Examples of the maintenance window, in the format of hh:mmZ-hh:mm Z.
 * @property paymentType The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
 * @property port Connection port.
 * @property publicConnectionString A public IP address for the connection.
 * @property publicPort Public network port.
 * @property scaleOutStatuses Scale state.
 * @property status The status of the DBCluster. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
 * @property storageType Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
 * @property supportBackup Support fallback scheme.
 * @property supportHttpsPort The system supports http port number.
 * @property supportMysqlPort Supports Mysql, and those of the ports.
 * @property vpcCloudInstanceId Virtual Private Cloud (VPC cloud instance ID.
 * @property vpcId The VPC ID of the DBCluster.
 * @property vswitchId The vswitch id of the DBCluster.
 * @property zoneId The zone ID of the DBCluster.
 */
public data class GetDbClustersCluster(
    public val aliUid: String,
    public val bid: String,
    public val category: String,
    public val commodityCode: String,
    public val connectionString: String,
    public val controlVersion: String,
    public val createTime: String,
    public val dbClusterAccessWhiteLists: List<GetDbClustersClusterDbClusterAccessWhiteList>,
    public val dbClusterDescription: String,
    public val dbClusterId: String,
    public val dbClusterNetworkType: String,
    public val dbClusterType: String,
    public val dbNodeClass: String,
    public val dbNodeCount: String,
    public val dbNodeStorage: String,
    public val encryptionKey: String,
    public val encryptionType: String,
    public val engine: String,
    public val engineVersion: String,
    public val expireTime: String,
    public val id: String,
    public val isExpired: String,
    public val lockMode: String,
    public val lockReason: String,
    public val maintainTime: String,
    public val paymentType: String,
    public val port: Int,
    public val publicConnectionString: String,
    public val publicPort: String,
    public val scaleOutStatuses: List<GetDbClustersClusterScaleOutStatus>,
    public val status: String,
    public val storageType: String,
    public val supportBackup: Int,
    public val supportHttpsPort: Boolean,
    public val supportMysqlPort: Boolean,
    public val vpcCloudInstanceId: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.clickhouse.outputs.GetDbClustersCluster): GetDbClustersCluster = GetDbClustersCluster(
            aliUid = javaType.aliUid(),
            bid = javaType.bid(),
            category = javaType.category(),
            commodityCode = javaType.commodityCode(),
            connectionString = javaType.connectionString(),
            controlVersion = javaType.controlVersion(),
            createTime = javaType.createTime(),
            dbClusterAccessWhiteLists = javaType.dbClusterAccessWhiteLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.clickhouse.kotlin.outputs.GetDbClustersClusterDbClusterAccessWhiteList.Companion.toKotlin(args0)
                })
            }),
            dbClusterDescription = javaType.dbClusterDescription(),
            dbClusterId = javaType.dbClusterId(),
            dbClusterNetworkType = javaType.dbClusterNetworkType(),
            dbClusterType = javaType.dbClusterType(),
            dbNodeClass = javaType.dbNodeClass(),
            dbNodeCount = javaType.dbNodeCount(),
            dbNodeStorage = javaType.dbNodeStorage(),
            encryptionKey = javaType.encryptionKey(),
            encryptionType = javaType.encryptionType(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            expireTime = javaType.expireTime(),
            id = javaType.id(),
            isExpired = javaType.isExpired(),
            lockMode = javaType.lockMode(),
            lockReason = javaType.lockReason(),
            maintainTime = javaType.maintainTime(),
            paymentType = javaType.paymentType(),
            port = javaType.port(),
            publicConnectionString = javaType.publicConnectionString(),
            publicPort = javaType.publicPort(),
            scaleOutStatuses = javaType.scaleOutStatuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.clickhouse.kotlin.outputs.GetDbClustersClusterScaleOutStatus.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            storageType = javaType.storageType(),
            supportBackup = javaType.supportBackup(),
            supportHttpsPort = javaType.supportHttpsPort(),
            supportMysqlPort = javaType.supportMysqlPort(),
            vpcCloudInstanceId = javaType.vpcCloudInstanceId(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
