@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDbClusters.
 * @property clusters
 * @property dbClusterDescription
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property status
 */
public data class GetDbClustersResult(
    public val clusters: List<GetDbClustersCluster>,
    public val dbClusterDescription: String? = null,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.clickhouse.outputs.GetDbClustersResult): GetDbClustersResult = GetDbClustersResult(
            clusters = javaType.clusters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.clickhouse.kotlin.outputs.GetDbClustersCluster.Companion.toKotlin(args0)
                })
            }),
            dbClusterDescription = javaType.dbClusterDescription().map({ args0 -> args0 }).orElse(null),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
