@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudauth.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FaceConfig].
 */
@PulumiTagMarker
public class FaceConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FaceConfigArgs = FaceConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FaceConfigArgsBuilder.() -> Unit) {
        val builder = FaceConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FaceConfig {
        val builtJavaResource = com.pulumi.alicloud.cloudauth.FaceConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FaceConfig(builtJavaResource)
    }
}

/**
 * Provides a Cloudauth Face Config resource.
 * For information about Cloudauth Face Config and how to use it, see [What is Face Config](https://help.aliyun.com/zh/id-verification/cloudauth/product-overview/end-of-integration-announcement-on-id-verification).
 * > **NOTE:** Available since v1.137.0.
 * > **NOTE:** In order to provide you with more perfect product capabilities, the real person certification service has stopped access, it is recommended that you use the upgraded version of the [real person certification financial real person certification service](https://help.aliyun.com/zh/id-verification/product-overview/what-is-id-verification-for-financial-services). Users that have access to real person authentication are not affected.
 * ## Import
 * Cloudauth Face Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudauth/faceConfig:FaceConfig example <lang>
 * ```
 */
public class FaceConfig internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudauth.FaceConfig,
) : KotlinCustomResource(javaResource, FaceConfigMapper) {
    /**
     * Scene name.
     */
    public val bizName: Output<String>
        get() = javaResource.bizName().applyValue({ args0 -> args0 })

    /**
     * Scene type. **NOTE:** The biz_type cannot exceed 32 characters and can only use English letters, numbers and dashes (-).
     */
    public val bizType: Output<String>
        get() = javaResource.bizType().applyValue({ args0 -> args0 })

    /**
     * Last Modified Date.
     */
    public val gmtModified: Output<String>
        get() = javaResource.gmtModified().applyValue({ args0 -> args0 })
}

public object FaceConfigMapper : ResourceMapper<FaceConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudauth.FaceConfig::class == javaResource::class

    override fun map(javaResource: Resource): FaceConfig = FaceConfig(
        javaResource as
            com.pulumi.alicloud.cloudauth.FaceConfig,
    )
}

/**
 * @see [FaceConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FaceConfig].
 */
public suspend fun faceConfig(name: String, block: suspend FaceConfigResourceBuilder.() -> Unit): FaceConfig {
    val builder = FaceConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FaceConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun faceConfig(name: String): FaceConfig {
    val builder = FaceConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
