@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudauth.kotlin

import com.pulumi.alicloud.cloudauth.FaceConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloudauth Face Config resource.
 * For information about Cloudauth Face Config and how to use it, see [What is Face Config](https://help.aliyun.com/zh/id-verification/cloudauth/product-overview/end-of-integration-announcement-on-id-verification).
 * > **NOTE:** Available since v1.137.0.
 * > **NOTE:** In order to provide you with more perfect product capabilities, the real person certification service has stopped access, it is recommended that you use the upgraded version of the [real person certification financial real person certification service](https://help.aliyun.com/zh/id-verification/product-overview/what-is-id-verification-for-financial-services). Users that have access to real person authentication are not affected.
 * ## Import
 * Cloudauth Face Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudauth/faceConfig:FaceConfig example <lang>
 * ```
 * @property bizName Scene name.
 * @property bizType Scene type. **NOTE:** The biz_type cannot exceed 32 characters and can only use English letters, numbers and dashes (-).
 */
public data class FaceConfigArgs(
    public val bizName: Output<String>? = null,
    public val bizType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudauth.FaceConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudauth.FaceConfigArgs =
        com.pulumi.alicloud.cloudauth.FaceConfigArgs.builder()
            .bizName(bizName?.applyValue({ args0 -> args0 }))
            .bizType(bizType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FaceConfigArgs].
 */
@PulumiTagMarker
public class FaceConfigArgsBuilder internal constructor() {
    private var bizName: Output<String>? = null

    private var bizType: Output<String>? = null

    /**
     * @param value Scene name.
     */
    @JvmName("fjjgcbfmfbrgukoe")
    public suspend fun bizName(`value`: Output<String>) {
        this.bizName = value
    }

    /**
     * @param value Scene type. **NOTE:** The biz_type cannot exceed 32 characters and can only use English letters, numbers and dashes (-).
     */
    @JvmName("wemdeqisckyrdqlm")
    public suspend fun bizType(`value`: Output<String>) {
        this.bizType = value
    }

    /**
     * @param value Scene name.
     */
    @JvmName("lhooalkgvdlddofh")
    public suspend fun bizName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bizName = mapped
    }

    /**
     * @param value Scene type. **NOTE:** The biz_type cannot exceed 32 characters and can only use English letters, numbers and dashes (-).
     */
    @JvmName("khwcmcwcfepjjrud")
    public suspend fun bizType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bizType = mapped
    }

    internal fun build(): FaceConfigArgs = FaceConfigArgs(
        bizName = bizName,
        bizType = bizType,
    )
}
