@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudauth.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bizName Scene name.
 * @property bizType Scene type. **NOTE:** The biz_type cannot exceed 32 characters and can only use English letters, numbers and dashes (-).
 * @property gmtUpdated The Update Time.
 */
public data class GetFaceConfigsConfig(
    public val bizName: String,
    public val bizType: String,
    public val gmtUpdated: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudauth.outputs.GetFaceConfigsConfig): GetFaceConfigsConfig = GetFaceConfigsConfig(
            bizName = javaType.bizName(),
            bizType = javaType.bizType(),
            gmtUpdated = javaType.gmtUpdated(),
        )
    }
}
