@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Network].
 */
@PulumiTagMarker
public class NetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkArgs = NetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkArgsBuilder.() -> Unit) {
        val builder = NetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Network {
        val builtJavaResource = com.pulumi.alicloud.cloudconnect.Network(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Network(builtJavaResource)
    }
}

/**
 * Provides a cloud connect network resource. Cloud Connect Network (CCN) is another important component of Smart Access Gateway. It is a device access matrix composed of Alibaba Cloud distributed access gateways. You can add multiple Smart Access Gateway (SAG) devices to a CCN instance and then attach the CCN instance to a Cloud Enterprise Network (CEN) instance to connect the local branches to the Alibaba Cloud.
 * For information about cloud connect network and how to use it, see [What is Cloud Connect Network](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createcloudconnectnetwork).
 * > **NOTE:** Available since v1.59.0.
 * > **NOTE:** Only the following regions support create Cloud Connect Network. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.cloudconnect.Network("default", {
 *     name: name,
 *     description: name,
 *     cidrBlock: "192.168.0.0/24",
 *     isDefault: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.cloudconnect.Network("default",
 *     name=name,
 *     description=name,
 *     cidr_block="192.168.0.0/24",
 *     is_default=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.CloudConnect.Network("default", new()
 *     {
 *         Name = name,
 *         Description = name,
 *         CidrBlock = "192.168.0.0/24",
 *         IsDefault = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cloudconnect.NewNetwork(ctx, "default", &cloudconnect.NetworkArgs{
 * 			Name:        pulumi.String(name),
 * 			Description: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.0.0/24"),
 * 			IsDefault:   pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudconnect.Network;
 * import com.pulumi.alicloud.cloudconnect.NetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Network("default", NetworkArgs.builder()
 *             .name(name)
 *             .description(name)
 *             .cidrBlock("192.168.0.0/24")
 *             .isDefault(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:cloudconnect:Network
 *     properties:
 *       name: ${name}
 *       description: ${name}
 *       cidrBlock: 192.168.0.0/24
 *       isDefault: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The cloud connect network instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudconnect/network:Network example ccn-abc123456
 * ```
 */
public class Network internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudconnect.Network,
) : KotlinCustomResource(javaResource, NetworkMapper) {
    /**
     * The CidrBlock of the CCN instance. Defaults to null.
     */
    public val cidrBlock: Output<String>?
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The description of the CCN instance. The description can contain 2 to 256 characters. The description must start with English letters, but cannot start with http:// or https://.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Created by default. If the client does not have ccn in the binding, it will create a ccn for the user to replace.
     */
    public val isDefault: Output<Boolean>
        get() = javaResource.isDefault().applyValue({ args0 -> args0 })

    /**
     * The name of the CCN instance. The name can contain 2 to 128 characters including a-z, A-Z, 0-9, periods, underlines, and hyphens. The name must start with an English letter, but cannot start with http:// or https://.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object NetworkMapper : ResourceMapper<Network> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudconnect.Network::class == javaResource::class

    override fun map(javaResource: Resource): Network = Network(
        javaResource as
            com.pulumi.alicloud.cloudconnect.Network,
    )
}

/**
 * @see [Network].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Network].
 */
public suspend fun network(name: String, block: suspend NetworkResourceBuilder.() -> Unit): Network {
    val builder = NetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Network].
 * @param name The _unique_ name of the resulting resource.
 */
public fun network(name: String): Network {
    val builder = NetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
