@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NetworkAttachment].
 */
@PulumiTagMarker
public class NetworkAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkAttachmentArgs = NetworkAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkAttachmentArgsBuilder.() -> Unit) {
        val builder = NetworkAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.cloudconnect.NetworkAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkAttachment(builtJavaResource)
    }
}

/**
 * Provides a Cloud Connect Network Attachment resource. This topic describes how to associate a Smart Access Gateway (SAG) instance with a network instance. You must associate an SAG instance with a network instance if you want to connect the SAG to Alibaba Cloud. You can connect an SAG to Alibaba Cloud through a leased line, the Internet, or the active and standby links.
 * For information about Cloud Connect Network Attachment and how to use it, see [What is Cloud Connect Network Attachment](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/bindsmartaccessgateway).
 * > **NOTE:** Available since v1.64.0.
 * > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const sagId = config.get("sagId") || "sag-9bifkf***";
 * const _default = new alicloud.cloudconnect.Network("default", {
 *     name: name,
 *     description: name,
 *     cidrBlock: "192.168.0.0/24",
 *     isDefault: true,
 * });
 * const defaultNetworkAttachment = new alicloud.cloudconnect.NetworkAttachment("default", {
 *     ccnId: _default.id,
 *     sagId: sagId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * sag_id = config.get("sagId")
 * if sag_id is None:
 *     sag_id = "sag-9bifkf***"
 * default = alicloud.cloudconnect.Network("default",
 *     name=name,
 *     description=name,
 *     cidr_block="192.168.0.0/24",
 *     is_default=True)
 * default_network_attachment = alicloud.cloudconnect.NetworkAttachment("default",
 *     ccn_id=default.id,
 *     sag_id=sag_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var sagId = config.Get("sagId") ?? "sag-9bifkf***";
 *     var @default = new AliCloud.CloudConnect.Network("default", new()
 *     {
 *         Name = name,
 *         Description = name,
 *         CidrBlock = "192.168.0.0/24",
 *         IsDefault = true,
 *     });
 *     var defaultNetworkAttachment = new AliCloud.CloudConnect.NetworkAttachment("default", new()
 *     {
 *         CcnId = @default.Id,
 *         SagId = sagId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		sagId := "sag-9bifkf***"
 * 		if param := cfg.Get("sagId"); param != "" {
 * 			sagId = param
 * 		}
 * 		_, err := cloudconnect.NewNetwork(ctx, "default", &cloudconnect.NetworkArgs{
 * 			Name:        pulumi.String(name),
 * 			Description: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.0.0/24"),
 * 			IsDefault:   pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudconnect.NewNetworkAttachment(ctx, "default", &cloudconnect.NetworkAttachmentArgs{
 * 			CcnId: _default.ID(),
 * 			SagId: pulumi.String(sagId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudconnect.Network;
 * import com.pulumi.alicloud.cloudconnect.NetworkArgs;
 * import com.pulumi.alicloud.cloudconnect.NetworkAttachment;
 * import com.pulumi.alicloud.cloudconnect.NetworkAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var sagId = config.get("sagId").orElse("sag-9bifkf***");
 *         var default_ = new Network("default", NetworkArgs.builder()
 *             .name(name)
 *             .description(name)
 *             .cidrBlock("192.168.0.0/24")
 *             .isDefault(true)
 *             .build());
 *         var defaultNetworkAttachment = new NetworkAttachment("defaultNetworkAttachment", NetworkAttachmentArgs.builder()
 *             .ccnId(default_.id())
 *             .sagId(sagId)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 *   sagId:
 *     type: string
 *     default: sag-9bifkf***
 * resources:
 *   default:
 *     type: alicloud:cloudconnect:Network
 *     properties:
 *       name: ${name}
 *       description: ${name}
 *       cidrBlock: 192.168.0.0/24
 *       isDefault: true
 *   defaultNetworkAttachment:
 *     type: alicloud:cloudconnect:NetworkAttachment
 *     name: default
 *     properties:
 *       ccnId: ${default.id}
 *       sagId: ${sagId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Cloud Connect Network Attachment can be imported using the instance_id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudconnect/networkAttachment:NetworkAttachment example ccn-abc123456:sag-abc123456
 * ```
 */
public class NetworkAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudconnect.NetworkAttachment,
) : KotlinCustomResource(javaResource, NetworkAttachmentMapper) {
    /**
     * The ID of the CCN instance.
     */
    public val ccnId: Output<String>
        get() = javaResource.ccnId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Smart Access Gateway instance.
     */
    public val sagId: Output<String>
        get() = javaResource.sagId().applyValue({ args0 -> args0 })
}

public object NetworkAttachmentMapper : ResourceMapper<NetworkAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudconnect.NetworkAttachment::class == javaResource::class

    override fun map(javaResource: Resource): NetworkAttachment = NetworkAttachment(
        javaResource as
            com.pulumi.alicloud.cloudconnect.NetworkAttachment,
    )
}

/**
 * @see [NetworkAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkAttachment].
 */
public suspend fun networkAttachment(
    name: String,
    block: suspend NetworkAttachmentResourceBuilder.() -> Unit,
): NetworkAttachment {
    val builder = NetworkAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkAttachment(name: String): NetworkAttachment {
    val builder = NetworkAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
