@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudconnect.kotlin

import com.pulumi.alicloud.cloudconnect.NetworkAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Connect Network Attachment resource. This topic describes how to associate a Smart Access Gateway (SAG) instance with a network instance. You must associate an SAG instance with a network instance if you want to connect the SAG to Alibaba Cloud. You can connect an SAG to Alibaba Cloud through a leased line, the Internet, or the active and standby links.
 * For information about Cloud Connect Network Attachment and how to use it, see [What is Cloud Connect Network Attachment](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/bindsmartaccessgateway).
 * > **NOTE:** Available since v1.64.0.
 * > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const sagId = config.get("sagId") || "sag-9bifkf***";
 * const _default = new alicloud.cloudconnect.Network("default", {
 *     name: name,
 *     description: name,
 *     cidrBlock: "192.168.0.0/24",
 *     isDefault: true,
 * });
 * const defaultNetworkAttachment = new alicloud.cloudconnect.NetworkAttachment("default", {
 *     ccnId: _default.id,
 *     sagId: sagId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * sag_id = config.get("sagId")
 * if sag_id is None:
 *     sag_id = "sag-9bifkf***"
 * default = alicloud.cloudconnect.Network("default",
 *     name=name,
 *     description=name,
 *     cidr_block="192.168.0.0/24",
 *     is_default=True)
 * default_network_attachment = alicloud.cloudconnect.NetworkAttachment("default",
 *     ccn_id=default.id,
 *     sag_id=sag_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var sagId = config.Get("sagId") ?? "sag-9bifkf***";
 *     var @default = new AliCloud.CloudConnect.Network("default", new()
 *     {
 *         Name = name,
 *         Description = name,
 *         CidrBlock = "192.168.0.0/24",
 *         IsDefault = true,
 *     });
 *     var defaultNetworkAttachment = new AliCloud.CloudConnect.NetworkAttachment("default", new()
 *     {
 *         CcnId = @default.Id,
 *         SagId = sagId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		sagId := "sag-9bifkf***"
 * 		if param := cfg.Get("sagId"); param != "" {
 * 			sagId = param
 * 		}
 * 		_, err := cloudconnect.NewNetwork(ctx, "default", &cloudconnect.NetworkArgs{
 * 			Name:        pulumi.String(name),
 * 			Description: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.0.0/24"),
 * 			IsDefault:   pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudconnect.NewNetworkAttachment(ctx, "default", &cloudconnect.NetworkAttachmentArgs{
 * 			CcnId: _default.ID(),
 * 			SagId: pulumi.String(sagId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudconnect.Network;
 * import com.pulumi.alicloud.cloudconnect.NetworkArgs;
 * import com.pulumi.alicloud.cloudconnect.NetworkAttachment;
 * import com.pulumi.alicloud.cloudconnect.NetworkAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var sagId = config.get("sagId").orElse("sag-9bifkf***");
 *         var default_ = new Network("default", NetworkArgs.builder()
 *             .name(name)
 *             .description(name)
 *             .cidrBlock("192.168.0.0/24")
 *             .isDefault(true)
 *             .build());
 *         var defaultNetworkAttachment = new NetworkAttachment("defaultNetworkAttachment", NetworkAttachmentArgs.builder()
 *             .ccnId(default_.id())
 *             .sagId(sagId)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 *   sagId:
 *     type: string
 *     default: sag-9bifkf***
 * resources:
 *   default:
 *     type: alicloud:cloudconnect:Network
 *     properties:
 *       name: ${name}
 *       description: ${name}
 *       cidrBlock: 192.168.0.0/24
 *       isDefault: true
 *   defaultNetworkAttachment:
 *     type: alicloud:cloudconnect:NetworkAttachment
 *     name: default
 *     properties:
 *       ccnId: ${default.id}
 *       sagId: ${sagId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Cloud Connect Network Attachment can be imported using the instance_id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudconnect/networkAttachment:NetworkAttachment example ccn-abc123456:sag-abc123456
 * ```
 * @property ccnId The ID of the CCN instance.
 * @property sagId The ID of the Smart Access Gateway instance.
 */
public data class NetworkAttachmentArgs(
    public val ccnId: Output<String>? = null,
    public val sagId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudconnect.NetworkAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudconnect.NetworkAttachmentArgs =
        com.pulumi.alicloud.cloudconnect.NetworkAttachmentArgs.builder()
            .ccnId(ccnId?.applyValue({ args0 -> args0 }))
            .sagId(sagId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAttachmentArgs].
 */
@PulumiTagMarker
public class NetworkAttachmentArgsBuilder internal constructor() {
    private var ccnId: Output<String>? = null

    private var sagId: Output<String>? = null

    /**
     * @param value The ID of the CCN instance.
     */
    @JvmName("ytxlnakdibgmkbdp")
    public suspend fun ccnId(`value`: Output<String>) {
        this.ccnId = value
    }

    /**
     * @param value The ID of the Smart Access Gateway instance.
     */
    @JvmName("knhpwvajicvojckl")
    public suspend fun sagId(`value`: Output<String>) {
        this.sagId = value
    }

    /**
     * @param value The ID of the CCN instance.
     */
    @JvmName("isqrwyxdkfygagtp")
    public suspend fun ccnId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ccnId = mapped
    }

    /**
     * @param value The ID of the Smart Access Gateway instance.
     */
    @JvmName("edekjhodbxfnuqxx")
    public suspend fun sagId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagId = mapped
    }

    internal fun build(): NetworkAttachmentArgs = NetworkAttachmentArgs(
        ccnId = ccnId,
        sagId = sagId,
    )
}
