@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudconnect.kotlin

import com.pulumi.alicloud.cloudconnect.NetworkGrantArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Connect Network Grant resource. If the CEN instance to be attached belongs to another account, authorization by the CEN instance is required.
 * For information about Cloud Connect Network Grant and how to use it, see [What is Cloud Connect Network Grant](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/grantinstancetocbn).
 * > **NOTE:** Available since v1.63.0.
 * > **NOTE:** Only the following regions support create Cloud Connect Network Grant. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const anotherUid = config.getNumber("anotherUid") || 123456789;
 * // Method 2: Use the target cen account's access_key, secret_key
 * // provider "alicloud" {
 * //   region     = "cn-hangzhou"
 * //   access_key = "access_key"
 * //   secret_key = "secret_key"
 * //   alias      = "cen_account"
 * // }
 * const _default = new alicloud.cloudconnect.Network("default", {
 *     name: name,
 *     description: name,
 *     cidrBlock: "192.168.0.0/24",
 *     isDefault: true,
 * });
 * const cen = new alicloud.cen.Instance("cen", {cenInstanceName: name});
 * const defaultNetworkGrant = new alicloud.cloudconnect.NetworkGrant("default", {
 *     ccnId: _default.id,
 *     cenId: cen.id,
 *     cenUid: anotherUid,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * another_uid = config.get_float("anotherUid")
 * if another_uid is None:
 *     another_uid = 123456789
 * # Method 2: Use the target cen account's access_key, secret_key
 * # provider "alicloud" {
 * #   region     = "cn-hangzhou"
 * #   access_key = "access_key"
 * #   secret_key = "secret_key"
 * #   alias      = "cen_account"
 * # }
 * default = alicloud.cloudconnect.Network("default",
 *     name=name,
 *     description=name,
 *     cidr_block="192.168.0.0/24",
 *     is_default=True)
 * cen = alicloud.cen.Instance("cen", cen_instance_name=name)
 * default_network_grant = alicloud.cloudconnect.NetworkGrant("default",
 *     ccn_id=default.id,
 *     cen_id=cen.id,
 *     cen_uid=another_uid)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var anotherUid = config.GetDouble("anotherUid") ?? 123456789;
 *     // Method 2: Use the target cen account's access_key, secret_key
 *     // provider "alicloud" {
 *     //   region     = "cn-hangzhou"
 *     //   access_key = "access_key"
 *     //   secret_key = "secret_key"
 *     //   alias      = "cen_account"
 *     // }
 *     var @default = new AliCloud.CloudConnect.Network("default", new()
 *     {
 *         Name = name,
 *         Description = name,
 *         CidrBlock = "192.168.0.0/24",
 *         IsDefault = true,
 *     });
 *     var cen = new AliCloud.Cen.Instance("cen", new()
 *     {
 *         CenInstanceName = name,
 *     });
 *     var defaultNetworkGrant = new AliCloud.CloudConnect.NetworkGrant("default", new()
 *     {
 *         CcnId = @default.Id,
 *         CenId = cen.Id,
 *         CenUid = anotherUid,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		anotherUid := float64(123456789)
 * 		if param := cfg.GetFloat64("anotherUid"); param != 0 {
 * 			anotherUid = param
 * 		}
 * 		// Method 2: Use the target cen account's access_key, secret_key
 * 		//
 * 		//	provider "alicloud" {
 * 		//	  region     = "cn-hangzhou"
 * 		//	  access_key = "access_key"
 * 		//	  secret_key = "secret_key"
 * 		//	  alias      = "cen_account"
 * 		//	}
 * 		_, err := cloudconnect.NewNetwork(ctx, "default", &cloudconnect.NetworkArgs{
 * 			Name:        pulumi.String(name),
 * 			Description: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.0.0/24"),
 * 			IsDefault:   pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cen, err := cen.NewInstance(ctx, "cen", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudconnect.NewNetworkGrant(ctx, "default", &cloudconnect.NetworkGrantArgs{
 * 			CcnId:  _default.ID(),
 * 			CenId:  cen.ID(),
 * 			CenUid: pulumi.Float64(anotherUid),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudconnect.Network;
 * import com.pulumi.alicloud.cloudconnect.NetworkArgs;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cloudconnect.NetworkGrant;
 * import com.pulumi.alicloud.cloudconnect.NetworkGrantArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var anotherUid = config.get("anotherUid").orElse(123456789);
 *         // Method 2: Use the target cen account's access_key, secret_key
 *         // provider "alicloud" {
 *         //   region     = "cn-hangzhou"
 *         //   access_key = "access_key"
 *         //   secret_key = "secret_key"
 *         //   alias      = "cen_account"
 *         // }
 *         var default_ = new Network("default", NetworkArgs.builder()
 *             .name(name)
 *             .description(name)
 *             .cidrBlock("192.168.0.0/24")
 *             .isDefault(true)
 *             .build());
 *         var cen = new Instance("cen", InstanceArgs.builder()
 *             .cenInstanceName(name)
 *             .build());
 *         var defaultNetworkGrant = new NetworkGrant("defaultNetworkGrant", NetworkGrantArgs.builder()
 *             .ccnId(default_.id())
 *             .cenId(cen.id())
 *             .cenUid(anotherUid)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 *   anotherUid:
 *     type: number
 *     default: 1.23456789e+08
 * resources:
 *   # Method 2: Use the target cen account's access_key, secret_key
 *   # provider "alicloud" {
 *   #   region     = "cn-hangzhou"
 *   #   access_key = "access_key"
 *   #   secret_key = "secret_key"
 *   #   alias      = "cen_account"
 *   # }
 *   default:
 *     type: alicloud:cloudconnect:Network
 *     properties:
 *       name: ${name}
 *       description: ${name}
 *       cidrBlock: 192.168.0.0/24
 *       isDefault: true
 *   cen:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: ${name}
 *   defaultNetworkGrant:
 *     type: alicloud:cloudconnect:NetworkGrant
 *     name: default
 *     properties:
 *       ccnId: ${default.id}
 *       cenId: ${cen.id}
 *       cenUid: ${anotherUid}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Cloud Connect Network Grant can be imported using the instance_id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudconnect/networkGrant:NetworkGrant example ccn-abc123456:cen-abc123456
 * ```
 * @property ccnId The ID of the CCN instance.
 * @property cenId The ID of the CEN instance.
 * @property cenUid The ID of the account to which the CEN instance belongs.
 */
public data class NetworkGrantArgs(
    public val ccnId: Output<String>? = null,
    public val cenId: Output<String>? = null,
    public val cenUid: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudconnect.NetworkGrantArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudconnect.NetworkGrantArgs =
        com.pulumi.alicloud.cloudconnect.NetworkGrantArgs.builder()
            .ccnId(ccnId?.applyValue({ args0 -> args0 }))
            .cenId(cenId?.applyValue({ args0 -> args0 }))
            .cenUid(cenUid?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkGrantArgs].
 */
@PulumiTagMarker
public class NetworkGrantArgsBuilder internal constructor() {
    private var ccnId: Output<String>? = null

    private var cenId: Output<String>? = null

    private var cenUid: Output<String>? = null

    /**
     * @param value The ID of the CCN instance.
     */
    @JvmName("beutwumajeoylkwp")
    public suspend fun ccnId(`value`: Output<String>) {
        this.ccnId = value
    }

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("fqaxgymovafyrtow")
    public suspend fun cenId(`value`: Output<String>) {
        this.cenId = value
    }

    /**
     * @param value The ID of the account to which the CEN instance belongs.
     */
    @JvmName("wvpexenjntteaali")
    public suspend fun cenUid(`value`: Output<String>) {
        this.cenUid = value
    }

    /**
     * @param value The ID of the CCN instance.
     */
    @JvmName("goljtkopmbufqecx")
    public suspend fun ccnId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ccnId = mapped
    }

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("lnqqxdnyomymptsq")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenId = mapped
    }

    /**
     * @param value The ID of the account to which the CEN instance belongs.
     */
    @JvmName("yswabgdhndbrkgcv")
    public suspend fun cenUid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenUid = mapped
    }

    internal fun build(): NetworkGrantArgs = NetworkGrantArgs(
        ccnId = ccnId,
        cenId = cenId,
        cenUid = cenUid,
    )
}
