@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudconnect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getNetworks.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of CCN instances IDs.
 * @property nameRegex
 * @property names A list of CCN instances names.
 * @property networks A list of CCN instances. Each element contains the following attributes:
 * @property outputFile
 */
public data class GetNetworksResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val networks: List<GetNetworksNetwork>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudconnect.outputs.GetNetworksResult): GetNetworksResult = GetNetworksResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            networks = javaType.networks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudconnect.kotlin.outputs.GetNetworksNetwork.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
