@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.AddressBookEcsTag
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.AddressBookEcsTag.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AddressBook].
 */
@PulumiTagMarker
public class AddressBookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AddressBookArgs = AddressBookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AddressBookArgsBuilder.() -> Unit) {
        val builder = AddressBookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AddressBook {
        val builtJavaResource = com.pulumi.alicloud.cloudfirewall.AddressBook(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AddressBook(builtJavaResource)
    }
}

/**
 * Provides a Cloud Firewall Address Book resource.
 * For information about Cloud Firewall Address Book and how to use it, see [What is Address Book](https://www.alibabacloud.com/help/en/cloud-firewall/developer-reference/api-cloudfw-2017-12-07-addaddressbook).
 * > **NOTE:** Available since v1.178.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cloudfirewall.AddressBook("example", {
 *     description: "example_value",
 *     groupName: "example_value",
 *     groupType: "tag",
 *     tagRelation: "and",
 *     autoAddTagEcs: 0,
 *     ecsTags: [{
 *         tagKey: "created",
 *         tagValue: "tfTestAcc0",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cloudfirewall.AddressBook("example",
 *     description="example_value",
 *     group_name="example_value",
 *     group_type="tag",
 *     tag_relation="and",
 *     auto_add_tag_ecs=0,
 *     ecs_tags=[{
 *         "tag_key": "created",
 *         "tag_value": "tfTestAcc0",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.CloudFirewall.AddressBook("example", new()
 *     {
 *         Description = "example_value",
 *         GroupName = "example_value",
 *         GroupType = "tag",
 *         TagRelation = "and",
 *         AutoAddTagEcs = 0,
 *         EcsTags = new[]
 *         {
 *             new AliCloud.CloudFirewall.Inputs.AddressBookEcsTagArgs
 *             {
 *                 TagKey = "created",
 *                 TagValue = "tfTestAcc0",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfirewall.NewAddressBook(ctx, "example", &cloudfirewall.AddressBookArgs{
 * 			Description:   pulumi.String("example_value"),
 * 			GroupName:     pulumi.String("example_value"),
 * 			GroupType:     pulumi.String("tag"),
 * 			TagRelation:   pulumi.String("and"),
 * 			AutoAddTagEcs: pulumi.Int(0),
 * 			EcsTags: cloudfirewall.AddressBookEcsTagArray{
 * 				&cloudfirewall.AddressBookEcsTagArgs{
 * 					TagKey:   pulumi.String("created"),
 * 					TagValue: pulumi.String("tfTestAcc0"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudfirewall.AddressBook;
 * import com.pulumi.alicloud.cloudfirewall.AddressBookArgs;
 * import com.pulumi.alicloud.cloudfirewall.inputs.AddressBookEcsTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AddressBook("example", AddressBookArgs.builder()
 *             .description("example_value")
 *             .groupName("example_value")
 *             .groupType("tag")
 *             .tagRelation("and")
 *             .autoAddTagEcs(0)
 *             .ecsTags(AddressBookEcsTagArgs.builder()
 *                 .tagKey("created")
 *                 .tagValue("tfTestAcc0")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cloudfirewall:AddressBook
 *     properties:
 *       description: example_value
 *       groupName: example_value
 *       groupType: tag
 *       tagRelation: and
 *       autoAddTagEcs: 0
 *       ecsTags:
 *         - tagKey: created
 *           tagValue: tfTestAcc0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Firewall Address Book can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/addressBook:AddressBook example <id>
 * ```
 */
public class AddressBook internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudfirewall.AddressBook,
) : KotlinCustomResource(javaResource, AddressBookMapper) {
    /**
     * The list of addresses.
     */
    public val addressLists: Output<List<String>>?
        get() = javaResource.addressLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Whether you want to automatically add new matching tags of the ECS IP address to the Address Book. Valid values: `0`, `1`.
     */
    public val autoAddTagEcs: Output<Int>?
        get() = javaResource.autoAddTagEcs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the Address Book.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * A list of ECS tags. See `ecs_tags` below.
     */
    public val ecsTags: Output<List<AddressBookEcsTag>>?
        get() = javaResource.ecsTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the Address Book.
     */
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })

    /**
     * The type of the Address Book. Valid values: `ip`, `ipv6`, `domain`, `port`, `tag`.
     * **NOTE:** From version 1.213.1, `group_type` can be set to `ipv6`, `domain`, `port`.
     */
    public val groupType: Output<String>
        get() = javaResource.groupType().applyValue({ args0 -> args0 })

    /**
     * The language of the content within the request and response. Valid values: `zh`, `en`.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The logical relation among the ECS tags that to be matched. Default value: `and`. Valid values:
     */
    public val tagRelation: Output<String>
        get() = javaResource.tagRelation().applyValue({ args0 -> args0 })
}

public object AddressBookMapper : ResourceMapper<AddressBook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudfirewall.AddressBook::class == javaResource::class

    override fun map(javaResource: Resource): AddressBook = AddressBook(
        javaResource as
            com.pulumi.alicloud.cloudfirewall.AddressBook,
    )
}

/**
 * @see [AddressBook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AddressBook].
 */
public suspend fun addressBook(name: String, block: suspend AddressBookResourceBuilder.() -> Unit): AddressBook {
    val builder = AddressBookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AddressBook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun addressBook(name: String): AddressBook {
    val builder = AddressBookResourceBuilder()
    builder.name(name)
    return builder.build()
}
