@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.alicloud.cloudfirewall.AddressBookArgs.builder
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.AddressBookEcsTagArgs
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.AddressBookEcsTagArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Firewall Address Book resource.
 * For information about Cloud Firewall Address Book and how to use it, see [What is Address Book](https://www.alibabacloud.com/help/en/cloud-firewall/developer-reference/api-cloudfw-2017-12-07-addaddressbook).
 * > **NOTE:** Available since v1.178.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cloudfirewall.AddressBook("example", {
 *     description: "example_value",
 *     groupName: "example_value",
 *     groupType: "tag",
 *     tagRelation: "and",
 *     autoAddTagEcs: 0,
 *     ecsTags: [{
 *         tagKey: "created",
 *         tagValue: "tfTestAcc0",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cloudfirewall.AddressBook("example",
 *     description="example_value",
 *     group_name="example_value",
 *     group_type="tag",
 *     tag_relation="and",
 *     auto_add_tag_ecs=0,
 *     ecs_tags=[{
 *         "tag_key": "created",
 *         "tag_value": "tfTestAcc0",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.CloudFirewall.AddressBook("example", new()
 *     {
 *         Description = "example_value",
 *         GroupName = "example_value",
 *         GroupType = "tag",
 *         TagRelation = "and",
 *         AutoAddTagEcs = 0,
 *         EcsTags = new[]
 *         {
 *             new AliCloud.CloudFirewall.Inputs.AddressBookEcsTagArgs
 *             {
 *                 TagKey = "created",
 *                 TagValue = "tfTestAcc0",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfirewall.NewAddressBook(ctx, "example", &cloudfirewall.AddressBookArgs{
 * 			Description:   pulumi.String("example_value"),
 * 			GroupName:     pulumi.String("example_value"),
 * 			GroupType:     pulumi.String("tag"),
 * 			TagRelation:   pulumi.String("and"),
 * 			AutoAddTagEcs: pulumi.Int(0),
 * 			EcsTags: cloudfirewall.AddressBookEcsTagArray{
 * 				&cloudfirewall.AddressBookEcsTagArgs{
 * 					TagKey:   pulumi.String("created"),
 * 					TagValue: pulumi.String("tfTestAcc0"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudfirewall.AddressBook;
 * import com.pulumi.alicloud.cloudfirewall.AddressBookArgs;
 * import com.pulumi.alicloud.cloudfirewall.inputs.AddressBookEcsTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AddressBook("example", AddressBookArgs.builder()
 *             .description("example_value")
 *             .groupName("example_value")
 *             .groupType("tag")
 *             .tagRelation("and")
 *             .autoAddTagEcs(0)
 *             .ecsTags(AddressBookEcsTagArgs.builder()
 *                 .tagKey("created")
 *                 .tagValue("tfTestAcc0")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cloudfirewall:AddressBook
 *     properties:
 *       description: example_value
 *       groupName: example_value
 *       groupType: tag
 *       tagRelation: and
 *       autoAddTagEcs: 0
 *       ecsTags:
 *         - tagKey: created
 *           tagValue: tfTestAcc0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Firewall Address Book can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/addressBook:AddressBook example <id>
 * ```
 * @property addressLists The list of addresses.
 * @property autoAddTagEcs Whether you want to automatically add new matching tags of the ECS IP address to the Address Book. Valid values: `0`, `1`.
 * @property description The description of the Address Book.
 * @property ecsTags A list of ECS tags. See `ecs_tags` below.
 * @property groupName The name of the Address Book.
 * @property groupType The type of the Address Book. Valid values: `ip`, `ipv6`, `domain`, `port`, `tag`.
 * **NOTE:** From version 1.213.1, `group_type` can be set to `ipv6`, `domain`, `port`.
 * @property lang The language of the content within the request and response. Valid values: `zh`, `en`.
 * @property tagRelation The logical relation among the ECS tags that to be matched. Default value: `and`. Valid values:
 */
public data class AddressBookArgs(
    public val addressLists: Output<List<String>>? = null,
    public val autoAddTagEcs: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val ecsTags: Output<List<AddressBookEcsTagArgs>>? = null,
    public val groupName: Output<String>? = null,
    public val groupType: Output<String>? = null,
    public val lang: Output<String>? = null,
    public val tagRelation: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.AddressBookArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.AddressBookArgs =
        com.pulumi.alicloud.cloudfirewall.AddressBookArgs.builder()
            .addressLists(addressLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .autoAddTagEcs(autoAddTagEcs?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .ecsTags(
                ecsTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .groupType(groupType?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 }))
            .tagRelation(tagRelation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddressBookArgs].
 */
@PulumiTagMarker
public class AddressBookArgsBuilder internal constructor() {
    private var addressLists: Output<List<String>>? = null

    private var autoAddTagEcs: Output<Int>? = null

    private var description: Output<String>? = null

    private var ecsTags: Output<List<AddressBookEcsTagArgs>>? = null

    private var groupName: Output<String>? = null

    private var groupType: Output<String>? = null

    private var lang: Output<String>? = null

    private var tagRelation: Output<String>? = null

    /**
     * @param value The list of addresses.
     */
    @JvmName("upudwrithfbfvkmj")
    public suspend fun addressLists(`value`: Output<List<String>>) {
        this.addressLists = value
    }

    @JvmName("aubtgxclaugqxbqw")
    public suspend fun addressLists(vararg values: Output<String>) {
        this.addressLists = Output.all(values.asList())
    }

    /**
     * @param values The list of addresses.
     */
    @JvmName("gepwvdtedilmpmkl")
    public suspend fun addressLists(values: List<Output<String>>) {
        this.addressLists = Output.all(values)
    }

    /**
     * @param value Whether you want to automatically add new matching tags of the ECS IP address to the Address Book. Valid values: `0`, `1`.
     */
    @JvmName("mgxpslhkvamoltfo")
    public suspend fun autoAddTagEcs(`value`: Output<Int>) {
        this.autoAddTagEcs = value
    }

    /**
     * @param value The description of the Address Book.
     */
    @JvmName("ougqssroshdcgcvc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A list of ECS tags. See `ecs_tags` below.
     */
    @JvmName("fmheirnysidqteor")
    public suspend fun ecsTags(`value`: Output<List<AddressBookEcsTagArgs>>) {
        this.ecsTags = value
    }

    @JvmName("vwdciijfpdmwsokr")
    public suspend fun ecsTags(vararg values: Output<AddressBookEcsTagArgs>) {
        this.ecsTags = Output.all(values.asList())
    }

    /**
     * @param values A list of ECS tags. See `ecs_tags` below.
     */
    @JvmName("joyjxkambbniucvx")
    public suspend fun ecsTags(values: List<Output<AddressBookEcsTagArgs>>) {
        this.ecsTags = Output.all(values)
    }

    /**
     * @param value The name of the Address Book.
     */
    @JvmName("tiykovjufjttfhjc")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The type of the Address Book. Valid values: `ip`, `ipv6`, `domain`, `port`, `tag`.
     * **NOTE:** From version 1.213.1, `group_type` can be set to `ipv6`, `domain`, `port`.
     */
    @JvmName("gvjopoovkghyxmxm")
    public suspend fun groupType(`value`: Output<String>) {
        this.groupType = value
    }

    /**
     * @param value The language of the content within the request and response. Valid values: `zh`, `en`.
     */
    @JvmName("bgrltdysjowcysvp")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The logical relation among the ECS tags that to be matched. Default value: `and`. Valid values:
     */
    @JvmName("tjbkxfigejllpjdv")
    public suspend fun tagRelation(`value`: Output<String>) {
        this.tagRelation = value
    }

    /**
     * @param value The list of addresses.
     */
    @JvmName("dfiwjtdpmiawcfcd")
    public suspend fun addressLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressLists = mapped
    }

    /**
     * @param values The list of addresses.
     */
    @JvmName("drjqfifytfhogleq")
    public suspend fun addressLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressLists = mapped
    }

    /**
     * @param value Whether you want to automatically add new matching tags of the ECS IP address to the Address Book. Valid values: `0`, `1`.
     */
    @JvmName("oaiavpvbrwwnuivg")
    public suspend fun autoAddTagEcs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAddTagEcs = mapped
    }

    /**
     * @param value The description of the Address Book.
     */
    @JvmName("llhbhbjsstqtqjql")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A list of ECS tags. See `ecs_tags` below.
     */
    @JvmName("lobwafcxgguplbnc")
    public suspend fun ecsTags(`value`: List<AddressBookEcsTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsTags = mapped
    }

    /**
     * @param argument A list of ECS tags. See `ecs_tags` below.
     */
    @JvmName("unrtxsorojxjdjdc")
    public suspend fun ecsTags(argument: List<suspend AddressBookEcsTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AddressBookEcsTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ecsTags = mapped
    }

    /**
     * @param argument A list of ECS tags. See `ecs_tags` below.
     */
    @JvmName("ausyrjdyqsfborgd")
    public suspend fun ecsTags(vararg argument: suspend AddressBookEcsTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AddressBookEcsTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ecsTags = mapped
    }

    /**
     * @param argument A list of ECS tags. See `ecs_tags` below.
     */
    @JvmName("ahqjipirmsxpmdvf")
    public suspend fun ecsTags(argument: suspend AddressBookEcsTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AddressBookEcsTagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ecsTags = mapped
    }

    /**
     * @param values A list of ECS tags. See `ecs_tags` below.
     */
    @JvmName("khejfhhijntvxljj")
    public suspend fun ecsTags(vararg values: AddressBookEcsTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ecsTags = mapped
    }

    /**
     * @param value The name of the Address Book.
     */
    @JvmName("fgmjxvurjixxuxeq")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value The type of the Address Book. Valid values: `ip`, `ipv6`, `domain`, `port`, `tag`.
     * **NOTE:** From version 1.213.1, `group_type` can be set to `ipv6`, `domain`, `port`.
     */
    @JvmName("umkvyigjltecimxo")
    public suspend fun groupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value The language of the content within the request and response. Valid values: `zh`, `en`.
     */
    @JvmName("hcisiukemvwasxqc")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The logical relation among the ECS tags that to be matched. Default value: `and`. Valid values:
     */
    @JvmName("lrpjpojqmtxhnvdw")
    public suspend fun tagRelation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagRelation = mapped
    }

    internal fun build(): AddressBookArgs = AddressBookArgs(
        addressLists = addressLists,
        autoAddTagEcs = autoAddTagEcs,
        description = description,
        ecsTags = ecsTags,
        groupName = groupName,
        groupType = groupType,
        lang = lang,
        tagRelation = tagRelation,
    )
}
