@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.alicloud.cloudfirewall.CloudfirewallFunctions.getAddressBooksPlain
import com.pulumi.alicloud.cloudfirewall.CloudfirewallFunctions.getControlPoliciesPlain
import com.pulumi.alicloud.cloudfirewall.CloudfirewallFunctions.getInstanceMembersPlain
import com.pulumi.alicloud.cloudfirewall.CloudfirewallFunctions.getInstancesPlain
import com.pulumi.alicloud.cloudfirewall.CloudfirewallFunctions.getVpcFirewallCensPlain
import com.pulumi.alicloud.cloudfirewall.CloudfirewallFunctions.getVpcFirewallControlPoliciesPlain
import com.pulumi.alicloud.cloudfirewall.CloudfirewallFunctions.getVpcFirewallsPlain
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.GetAddressBooksPlainArgs
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.GetAddressBooksPlainArgsBuilder
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.GetControlPoliciesPlainArgs
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.GetControlPoliciesPlainArgsBuilder
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.GetInstanceMembersPlainArgs
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.GetInstanceMembersPlainArgsBuilder
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.GetVpcFirewallCensPlainArgs
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.GetVpcFirewallCensPlainArgsBuilder
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.GetVpcFirewallControlPoliciesPlainArgs
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.GetVpcFirewallControlPoliciesPlainArgsBuilder
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.GetVpcFirewallsPlainArgs
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.GetVpcFirewallsPlainArgsBuilder
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetAddressBooksResult
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetControlPoliciesResult
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetInstanceMembersResult
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallCensResult
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallControlPoliciesResult
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetAddressBooksResult.Companion.toKotlin as getAddressBooksResultToKotlin
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetControlPoliciesResult.Companion.toKotlin as getControlPoliciesResultToKotlin
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetInstanceMembersResult.Companion.toKotlin as getInstanceMembersResultToKotlin
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallCensResult.Companion.toKotlin as getVpcFirewallCensResultToKotlin
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallControlPoliciesResult.Companion.toKotlin as getVpcFirewallControlPoliciesResultToKotlin
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallsResult.Companion.toKotlin as getVpcFirewallsResultToKotlin

public object CloudfirewallFunctions {
    /**
     * This data source provides the Cloud Firewall Address Books of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.178.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "tf-example";
     * const _default = new alicloud.cloudfirewall.AddressBook("default", {
     *     groupName: name,
     *     groupType: "ip",
     *     description: "tf-description",
     *     autoAddTagEcs: 0,
     *     addressLists: [
     *         "10.21.0.0/16",
     *         "10.168.0.0/16",
     *     ],
     * });
     * const ids = alicloud.cloudfirewall.getAddressBooksOutput({
     *     ids: [_default&#46;id],
     * });
     * export const cloudFirewallAddressBookId1 = ids.apply(ids => ids.books?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "tf-example"
     * default = alicloud.cloudfirewall.AddressBook("default",
     *     group_name=name,
     *     group_type="ip",
     *     description="tf-description",
     *     auto_add_tag_ecs=0,
     *     address_lists=[
     *         "10.21.0.0/16",
     *         "10.168.0.0/16",
     *     ])
     * ids = alicloud.cloudfirewall.get_address_books_output(ids=[default&#46;id])
     * pulumi.export("cloudFirewallAddressBookId1", ids.books[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "tf-example";
     *     var @default = new AliCloud.CloudFirewall.AddressBook("default", new()
     *     {
     *         GroupName = name,
     *         GroupType = "ip",
     *         Description = "tf-description",
     *         AutoAddTagEcs = 0,
     *         AddressLists = new[]
     *         {
     *             "10.21.0.0/16",
     *             "10.168.0.0/16",
     *         },
     *     });
     *     var ids = AliCloud.CloudFirewall.GetAddressBooks.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             @default.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudFirewallAddressBookId1"] = ids&#46;Apply(getAddressBooksResult => getAddressBooksResult&#46;Books[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "tf-example"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_, err := cloudfirewall.NewAddressBook(ctx, "default", &cloudfirewall.AddressBookArgs{
     * 			GroupName:     pulumi.String(name),
     * 			GroupType:     pulumi.String("ip"),
     * 			Description:   pulumi.String("tf-description"),
     * 			AutoAddTagEcs: pulumi.Int(0),
     * 			AddressLists: pulumi.StringArray{
     * 				pulumi.String("10.21.0.0/16"),
     * 				pulumi.String("10.168.0.0/16"),
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids := cloudfirewall.GetAddressBooksOutput(ctx, cloudfirewall.GetAddressBooksOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				_default.ID(),
     * 			},
     * 		}, nil)
     * 		ctx.Export("cloudFirewallAddressBookId1", ids.ApplyT(func(ids cloudfirewall.GetAddressBooksResult) (*string, error) {
     * 			return &ids.Books[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudfirewall.AddressBook;
     * import com.pulumi.alicloud.cloudfirewall.AddressBookArgs;
     * import com.pulumi.alicloud.cloudfirewall.CloudfirewallFunctions;
     * import com.pulumi.alicloud.cloudfirewall.inputs.GetAddressBooksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("tf-example");
     *         var default_ = new AddressBook("default", AddressBookArgs.builder()
     *             .groupName(name)
     *             .groupType("ip")
     *             .description("tf-description")
     *             .autoAddTagEcs(0)
     *             .addressLists(
     *                 "10.21.0.0/16",
     *                 "10.168.0.0/16")
     *             .build());
     *         final var ids = CloudfirewallFunctions.getAddressBooks(GetAddressBooksArgs.builder()
     *             .ids(default_.id())
     *             .build());
     *         ctx.export("cloudFirewallAddressBookId1", ids.applyValue(getAddressBooksResult -> getAddressBooksResult).applyValue(ids -> ids.applyValue(getAddressBooksResult -> getAddressBooksResult.books()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: tf-example
     * resources:
     *   default:
     *     type: alicloud:cloudfirewall:AddressBook
     *     properties:
     *       groupName: ${name}
     *       groupType: ip
     *       description: tf-description
     *       autoAddTagEcs: 0
     *       addressLists:
     *         - 10.21.0.0/16
     *         - 10.168.0.0/16
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudfirewall:getAddressBooks
     *       Arguments:
     *         ids:
     *           - ${default.id}
     * outputs:
     *   cloudFirewallAddressBookId1: ${ids.books[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAddressBooks.
     * @return A collection of values returned by getAddressBooks.
     */
    public suspend fun getAddressBooks(argument: GetAddressBooksPlainArgs): GetAddressBooksResult =
        getAddressBooksResultToKotlin(getAddressBooksPlain(argument.toJava()).await())

    /**
     * @see [getAddressBooks].
     * @param groupType The type of the Address Book. Valid values: `ip`, `ipv6`, `domain`, `port`, `tag`.
     * **NOTE:** From version 1.213.1, `group_type` can be set to `ipv6`, `domain`, `port`.
     * @param ids A list of Address Book IDs.
     * @param nameRegex A regex string to filter results Address Book name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getAddressBooks.
     */
    public suspend fun getAddressBooks(
        groupType: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetAddressBooksResult {
        val argument = GetAddressBooksPlainArgs(
            groupType = groupType,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getAddressBooksResultToKotlin(getAddressBooksPlain(argument.toJava()).await())
    }

    /**
     * @see [getAddressBooks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudfirewall&#46;kotlin&#46;inputs&#46;GetAddressBooksPlainArgs].
     * @return A collection of values returned by getAddressBooks.
     */
    public suspend fun getAddressBooks(argument: suspend GetAddressBooksPlainArgsBuilder.() -> Unit): GetAddressBooksResult {
        val builder = GetAddressBooksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAddressBooksResultToKotlin(getAddressBooksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cloud Firewall Control Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.129.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cloudfirewall.getControlPolicies({
     *     direction: "in",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cloudfirewall.get_control_policies(direction="in")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.CloudFirewall.GetControlPolicies.Invoke(new()
     *     {
     *         Direction = "in",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudfirewall.GetControlPolicies(ctx, &cloudfirewall.GetControlPoliciesArgs{
     * 			Direction: "in",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudfirewall.CloudfirewallFunctions;
     * import com.pulumi.alicloud.cloudfirewall.inputs.GetControlPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfirewallFunctions.getControlPolicies(GetControlPoliciesArgs.builder()
     *             .direction("in")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cloudfirewall:getControlPolicies
     *       Arguments:
     *         direction: in
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getControlPolicies.
     * @return A collection of values returned by getControlPolicies.
     */
    public suspend fun getControlPolicies(argument: GetControlPoliciesPlainArgs): GetControlPoliciesResult =
        getControlPoliciesResultToKotlin(getControlPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getControlPolicies].
     * @param aclAction The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
     * @param aclUuid The unique ID of the access control policy.
     * @param description The description of the access control policy.
     * @param destination The destination address defined in the access control policy.
     * @param direction The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
     * @param ipVersion The IP version of the address in the access control policy.
     * @param lang The language of the content within the response. Valid values: `en`, `zh`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param proto The type of the protocol in the access control policy. Valid values: If `direction` is  `in`, the valid value is `ANY`. If `direction` is `out`, the valid values are `ANY`, `TCP`, `UDP`, `ICMP`.
     * @param source The source address in the access control policy.
     * @return A collection of values returned by getControlPolicies.
     */
    public suspend fun getControlPolicies(
        aclAction: String? = null,
        aclUuid: String? = null,
        description: String? = null,
        destination: String? = null,
        direction: String,
        ipVersion: String? = null,
        lang: String? = null,
        outputFile: String? = null,
        proto: String? = null,
        source: String? = null,
    ): GetControlPoliciesResult {
        val argument = GetControlPoliciesPlainArgs(
            aclAction = aclAction,
            aclUuid = aclUuid,
            description = description,
            destination = destination,
            direction = direction,
            ipVersion = ipVersion,
            lang = lang,
            outputFile = outputFile,
            proto = proto,
            source = source,
        )
        return getControlPoliciesResultToKotlin(getControlPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getControlPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudfirewall&#46;kotlin&#46;inputs&#46;GetControlPoliciesPlainArgs].
     * @return A collection of values returned by getControlPolicies.
     */
    public suspend fun getControlPolicies(argument: suspend GetControlPoliciesPlainArgsBuilder.() -> Unit): GetControlPoliciesResult {
        val builder = GetControlPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getControlPoliciesResultToKotlin(getControlPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Cloud Firewall Instance Member available to the user.[What is Instance Member](https://help.aliyun.com/document_detail/261237.html)
     * > **NOTE:** Available in 1.194.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cloudfirewall.getInstanceMembers({
     *     ids: [defaultAlicloudCloudFirewallInstanceMember&#46;id],
     * });
     * export const alicloudCloudFirewallInstanceMemberExampleId = _default.then(_default => _default.members?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cloudfirewall.get_instance_members(ids=[default_alicloud_cloud_firewall_instance_member["id"]])
     * pulumi.export("alicloudCloudFirewallInstanceMemberExampleId", default.members[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.CloudFirewall.GetInstanceMembers.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudCloudFirewallInstanceMember.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudCloudFirewallInstanceMemberExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getInstanceMembersResult => getInstanceMembersResult&#46;Members[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := cloudfirewall.GetInstanceMembers(ctx, &cloudfirewall.GetInstanceMembersArgs{
     * Ids: interface{}{
     * defaultAlicloudCloudFirewallInstanceMember.Id,
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudCloudFirewallInstanceMemberExampleId", _default.Members[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudfirewall.CloudfirewallFunctions;
     * import com.pulumi.alicloud.cloudfirewall.inputs.GetInstanceMembersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CloudfirewallFunctions.getInstanceMembers(GetInstanceMembersArgs.builder()
     *             .ids(defaultAlicloudCloudFirewallInstanceMember.id())
     *             .build());
     *         ctx.export("alicloudCloudFirewallInstanceMemberExampleId", default_.members()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cloudfirewall:getInstanceMembers
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudCloudFirewallInstanceMember.id}
     * outputs:
     *   alicloudCloudFirewallInstanceMemberExampleId: ${default.members[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceMembers.
     * @return A collection of values returned by getInstanceMembers.
     */
    public suspend fun getInstanceMembers(argument: GetInstanceMembersPlainArgs): GetInstanceMembersResult =
        getInstanceMembersResultToKotlin(getInstanceMembersPlain(argument.toJava()).await())

    /**
     * @see [getInstanceMembers].
     * @param currentPage
     * @param ids A list of Instance Member IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getInstanceMembers.
     */
    public suspend fun getInstanceMembers(
        currentPage: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetInstanceMembersResult {
        val argument = GetInstanceMembersPlainArgs(
            currentPage = currentPage,
            ids = ids,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getInstanceMembersResultToKotlin(getInstanceMembersPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceMembers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudfirewall&#46;kotlin&#46;inputs&#46;GetInstanceMembersPlainArgs].
     * @return A collection of values returned by getInstanceMembers.
     */
    public suspend fun getInstanceMembers(argument: suspend GetInstanceMembersPlainArgsBuilder.() -> Unit): GetInstanceMembersResult {
        val builder = GetInstanceMembersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceMembersResultToKotlin(getInstanceMembersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cloud Firewall Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.139.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cloudfirewall.getInstances({});
     * export const cloudFirewallInstanceId1 = ids.then(ids => ids.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cloudfirewall.get_instances()
     * pulumi.export("cloudFirewallInstanceId1", ids.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CloudFirewall.GetInstances.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudFirewallInstanceId1"] = ids&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cloudfirewall.GetInstances(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudFirewallInstanceId1", ids.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudfirewall.CloudfirewallFunctions;
     * import com.pulumi.alicloud.cloudfirewall.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CloudfirewallFunctions.getInstances();
     *         ctx.export("cloudFirewallInstanceId1", ids.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudfirewall:getInstances
     *       Arguments: {}
     * outputs:
     *   cloudFirewallInstanceId1: ${ids.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(outputFile: String? = null): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            outputFile = outputFile,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudfirewall&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Cloud Firewall Vpc Firewall Cen available to the user.[What is Vpc Firewall Cen](https://www.alibabacloud.com/help/en/cloud-firewall/latest/describevpcfirewallcenlist)
     * > **NOTE:** Available in 1.194.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cloudfirewall.getVpcFirewallCens({
     *     ids: [defaultAlicloudCloudFirewallVpcFirewallCen&#46;id],
     *     cenId: "cen-cjok7uyb5w2b27573v",
     *     memberUid: "1415189284827022",
     *     status: "closed",
     *     vpcFirewallName: "tf-test",
     * });
     * export const alicloudCloudFirewallVpcFirewallCenExampleId = _default.then(_default => _default.cens?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cloudfirewall.get_vpc_firewall_cens(ids=[default_alicloud_cloud_firewall_vpc_firewall_cen["id"]],
     *     cen_id="cen-cjok7uyb5w2b27573v",
     *     member_uid="1415189284827022",
     *     status="closed",
     *     vpc_firewall_name="tf-test")
     * pulumi.export("alicloudCloudFirewallVpcFirewallCenExampleId", default.cens[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.CloudFirewall.GetVpcFirewallCens.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudCloudFirewallVpcFirewallCen.Id,
     *         },
     *         CenId = "cen-cjok7uyb5w2b27573v",
     *         MemberUid = "1415189284827022",
     *         Status = "closed",
     *         VpcFirewallName = "tf-test",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudCloudFirewallVpcFirewallCenExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getVpcFirewallCensResult => getVpcFirewallCensResult&#46;Cens[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := cloudfirewall.GetVpcFirewallCens(ctx, &cloudfirewall.GetVpcFirewallCensArgs{
     * Ids: interface{}{
     * defaultAlicloudCloudFirewallVpcFirewallCen.Id,
     * },
     * CenId: pulumi.StringRef("cen-cjok7uyb5w2b27573v"),
     * MemberUid: pulumi.StringRef("1415189284827022"),
     * Status: pulumi.StringRef("closed"),
     * VpcFirewallName: pulumi.StringRef("tf-test"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudCloudFirewallVpcFirewallCenExampleId", _default.Cens[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudfirewall.CloudfirewallFunctions;
     * import com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallCensArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CloudfirewallFunctions.getVpcFirewallCens(GetVpcFirewallCensArgs.builder()
     *             .ids(defaultAlicloudCloudFirewallVpcFirewallCen.id())
     *             .cenId("cen-cjok7uyb5w2b27573v")
     *             .memberUid("1415189284827022")
     *             .status("closed")
     *             .vpcFirewallName("tf-test")
     *             .build());
     *         ctx.export("alicloudCloudFirewallVpcFirewallCenExampleId", default_.cens()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cloudfirewall:getVpcFirewallCens
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudCloudFirewallVpcFirewallCen.id}
     *         cenId: cen-cjok7uyb5w2b27573v
     *         memberUid: '1415189284827022'
     *         status: closed
     *         vpcFirewallName: tf-test
     * outputs:
     *   alicloudCloudFirewallVpcFirewallCenExampleId: ${default.cens[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcFirewallCens.
     * @return A collection of values returned by getVpcFirewallCens.
     */
    public suspend fun getVpcFirewallCens(argument: GetVpcFirewallCensPlainArgs): GetVpcFirewallCensResult =
        getVpcFirewallCensResultToKotlin(getVpcFirewallCensPlain(argument.toJava()).await())

    /**
     * @see [getVpcFirewallCens].
     * @param cenId The ID of the CEN instance.
     * @param ids A list of Vpc Firewall Cen IDs.
     * @param lang The language type of the requested and received messages. Value:-**zh** (default): Chinese.-**en**: English.
     * @param memberUid The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
     * @param networkInstanceId The ID of the VPC instance that created the VPC firewall.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status Firewall switch status
     * @param vpcFirewallId VPC firewall ID
     * @param vpcFirewallName The name of the VPC firewall instance.
     * @return A collection of values returned by getVpcFirewallCens.
     */
    public suspend fun getVpcFirewallCens(
        cenId: String? = null,
        ids: List<String>? = null,
        lang: String? = null,
        memberUid: String? = null,
        networkInstanceId: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
        vpcFirewallId: String? = null,
        vpcFirewallName: String? = null,
    ): GetVpcFirewallCensResult {
        val argument = GetVpcFirewallCensPlainArgs(
            cenId = cenId,
            ids = ids,
            lang = lang,
            memberUid = memberUid,
            networkInstanceId = networkInstanceId,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
            vpcFirewallId = vpcFirewallId,
            vpcFirewallName = vpcFirewallName,
        )
        return getVpcFirewallCensResultToKotlin(getVpcFirewallCensPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcFirewallCens].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudfirewall&#46;kotlin&#46;inputs&#46;GetVpcFirewallCensPlainArgs].
     * @return A collection of values returned by getVpcFirewallCens.
     */
    public suspend fun getVpcFirewallCens(argument: suspend GetVpcFirewallCensPlainArgsBuilder.() -> Unit): GetVpcFirewallCensResult {
        val builder = GetVpcFirewallCensPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcFirewallCensResultToKotlin(getVpcFirewallCensPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cloud Firewall Vpc Firewall Control Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.194.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cloudfirewall.getVpcFirewallControlPolicies({
     *     vpcFirewallId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const alicloudCloudFirewallVpcFirewallControlPoliciesId1 = ids.then(ids => ids.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cloudfirewall.get_vpc_firewall_control_policies(vpc_firewall_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("alicloudCloudFirewallVpcFirewallControlPoliciesId1", ids.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CloudFirewall.GetVpcFirewallControlPolicies.Invoke(new()
     *     {
     *         VpcFirewallId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudCloudFirewallVpcFirewallControlPoliciesId1"] = ids&#46;Apply(getVpcFirewallControlPoliciesResult => getVpcFirewallControlPoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cloudfirewall.GetVpcFirewallControlPolicies(ctx, &cloudfirewall.GetVpcFirewallControlPoliciesArgs{
     * 			VpcFirewallId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudCloudFirewallVpcFirewallControlPoliciesId1", ids.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudfirewall.CloudfirewallFunctions;
     * import com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallControlPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CloudfirewallFunctions.getVpcFirewallControlPolicies(GetVpcFirewallControlPoliciesArgs.builder()
     *             .vpcFirewallId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("alicloudCloudFirewallVpcFirewallControlPoliciesId1", ids.applyValue(getVpcFirewallControlPoliciesResult -> getVpcFirewallControlPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudfirewall:getVpcFirewallControlPolicies
     *       Arguments:
     *         vpcFirewallId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   alicloudCloudFirewallVpcFirewallControlPoliciesId1: ${ids.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcFirewallControlPolicies.
     * @return A collection of values returned by getVpcFirewallControlPolicies.
     */
    public suspend fun getVpcFirewallControlPolicies(argument: GetVpcFirewallControlPoliciesPlainArgs): GetVpcFirewallControlPoliciesResult =
        getVpcFirewallControlPoliciesResultToKotlin(getVpcFirewallControlPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getVpcFirewallControlPolicies].
     * @param aclAction The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
     * @param aclUuid Access control over VPC firewalls strategy unique identifier.
     * @param description Access control over VPC firewalls description of the strategy information.
     * @param destination Access control over VPC firewalls strategy the destination address in.
     * @param ids A list of Vpc Firewall Control Policy IDs.
     * @param lang The language of the content within the request and response. Valid values: `zh`, `en`.
     * @param memberUid The UID of the member account of the current Alibaba cloud account.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param proto Access control over VPC firewalls strategy access traffic of the protocol type.
     * @param release The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
     * - **true**: Enable access control policies
     * - **false**: does not enable access control policies.
     * @param source Access control over VPC firewalls strategy in the source address.
     * @param vpcFirewallId The ID of the VPC firewall instance. Value:
     * - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
     * - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
     * @return A collection of values returned by getVpcFirewallControlPolicies.
     */
    public suspend fun getVpcFirewallControlPolicies(
        aclAction: String? = null,
        aclUuid: String? = null,
        description: String? = null,
        destination: String? = null,
        ids: List<String>? = null,
        lang: String? = null,
        memberUid: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        proto: String? = null,
        release: Boolean? = null,
        source: String? = null,
        vpcFirewallId: String,
    ): GetVpcFirewallControlPoliciesResult {
        val argument = GetVpcFirewallControlPoliciesPlainArgs(
            aclAction = aclAction,
            aclUuid = aclUuid,
            description = description,
            destination = destination,
            ids = ids,
            lang = lang,
            memberUid = memberUid,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            proto = proto,
            release = release,
            source = source,
            vpcFirewallId = vpcFirewallId,
        )
        return getVpcFirewallControlPoliciesResultToKotlin(getVpcFirewallControlPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcFirewallControlPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudfirewall&#46;kotlin&#46;inputs&#46;GetVpcFirewallControlPoliciesPlainArgs].
     * @return A collection of values returned by getVpcFirewallControlPolicies.
     */
    public suspend fun getVpcFirewallControlPolicies(argument: suspend GetVpcFirewallControlPoliciesPlainArgsBuilder.() -> Unit): GetVpcFirewallControlPoliciesResult {
        val builder = GetVpcFirewallControlPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcFirewallControlPoliciesResultToKotlin(getVpcFirewallControlPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Cloud Firewall Vpc Firewall available to the user.[What is Vpc Firewall](https://help.aliyun.com/document_detail/342932.html)
     * > **NOTE:** Available in 1.194.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cloudfirewall.getVpcFirewalls({
     *     ids: ["id-example"],
     *     memberUid: "1415189284827022",
     *     status: "closed",
     *     vpcFirewallName: "tf-test",
     * });
     * export const alicloudCfwVpcFirewallExampleId = _default.then(_default => _default.firewalls?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cloudfirewall.get_vpc_firewalls(ids=["id-example"],
     *     member_uid="1415189284827022",
     *     status="closed",
     *     vpc_firewall_name="tf-test")
     * pulumi.export("alicloudCfwVpcFirewallExampleId", default.firewalls[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.CloudFirewall.GetVpcFirewalls.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "id-example",
     *         },
     *         MemberUid = "1415189284827022",
     *         Status = "closed",
     *         VpcFirewallName = "tf-test",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudCfwVpcFirewallExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getVpcFirewallsResult => getVpcFirewallsResult&#46;Firewalls[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := cloudfirewall.GetVpcFirewalls(ctx, &cloudfirewall.GetVpcFirewallsArgs{
     * 			Ids: []string{
     * 				"id-example",
     * 			},
     * 			MemberUid:       pulumi.StringRef("1415189284827022"),
     * 			Status:          pulumi.StringRef("closed"),
     * 			VpcFirewallName: pulumi.StringRef("tf-test"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudCfwVpcFirewallExampleId", _default.Firewalls[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudfirewall.CloudfirewallFunctions;
     * import com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CloudfirewallFunctions.getVpcFirewalls(GetVpcFirewallsArgs.builder()
     *             .ids("id-example")
     *             .memberUid("1415189284827022")
     *             .status("closed")
     *             .vpcFirewallName("tf-test")
     *             .build());
     *         ctx.export("alicloudCfwVpcFirewallExampleId", default_.firewalls()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cloudfirewall:getVpcFirewalls
     *       Arguments:
     *         ids:
     *           - id-example
     *         memberUid: '1415189284827022'
     *         status: closed
     *         vpcFirewallName: tf-test
     * outputs:
     *   alicloudCfwVpcFirewallExampleId: ${default.firewalls[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcFirewalls.
     * @return A collection of values returned by getVpcFirewalls.
     */
    public suspend fun getVpcFirewalls(argument: GetVpcFirewallsPlainArgs): GetVpcFirewallsResult =
        getVpcFirewallsResultToKotlin(getVpcFirewallsPlain(argument.toJava()).await())

    /**
     * @see [getVpcFirewalls].
     * @param ids A list of Vpc Firewall IDs.
     * @param lang The language type of the requested and received messages. Value:-**zh** (default): Chinese.-**en**: English.
     * @param memberUid The UID of the Alibaba Cloud member account.
     * @param nameRegex A regex string to filter results by Group Metric Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param regionNo The region ID of the peer VPC.
     * @param status The status of the resource
     * @param vpcFirewallId The ID of the VPC firewall instance.
     * @param vpcFirewallName The name of the VPC firewall instance.
     * @param vpcId The ID of the peer VPC instance.
     * @return A collection of values returned by getVpcFirewalls.
     */
    public suspend fun getVpcFirewalls(
        ids: List<String>? = null,
        lang: String? = null,
        memberUid: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        regionNo: String? = null,
        status: String? = null,
        vpcFirewallId: String? = null,
        vpcFirewallName: String? = null,
        vpcId: String? = null,
    ): GetVpcFirewallsResult {
        val argument = GetVpcFirewallsPlainArgs(
            ids = ids,
            lang = lang,
            memberUid = memberUid,
            nameRegex = nameRegex,
            outputFile = outputFile,
            regionNo = regionNo,
            status = status,
            vpcFirewallId = vpcFirewallId,
            vpcFirewallName = vpcFirewallName,
            vpcId = vpcId,
        )
        return getVpcFirewallsResultToKotlin(getVpcFirewallsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcFirewalls].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudfirewall&#46;kotlin&#46;inputs&#46;GetVpcFirewallsPlainArgs].
     * @return A collection of values returned by getVpcFirewalls.
     */
    public suspend fun getVpcFirewalls(argument: suspend GetVpcFirewallsPlainArgsBuilder.() -> Unit): GetVpcFirewallsResult {
        val builder = GetVpcFirewallsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcFirewallsResultToKotlin(getVpcFirewallsPlain(builtArgument.toJava()).await())
    }
}
