@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ControlPolicy].
 */
@PulumiTagMarker
public class ControlPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ControlPolicyArgs = ControlPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ControlPolicyArgsBuilder.() -> Unit) {
        val builder = ControlPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ControlPolicy {
        val builtJavaResource = com.pulumi.alicloud.cloudfirewall.ControlPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ControlPolicy(builtJavaResource)
    }
}

/**
 * Provides a Cloud Firewall Control Policy resource.
 * For information about Cloud Firewall Control Policy and how to use it, see [What is Control Policy](https://www.alibabacloud.com/help/doc-detail/138867.htm).
 * > **NOTE:** Available since v1.129.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.cloudfirewall.ControlPolicy("default", {
 *     direction: "in",
 *     applicationName: "ANY",
 *     description: name,
 *     aclAction: "accept",
 *     source: "127.0.0.1/32",
 *     sourceType: "net",
 *     destination: "127.0.0.2/32",
 *     destinationType: "net",
 *     proto: "ANY",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.cloudfirewall.ControlPolicy("default",
 *     direction="in",
 *     application_name="ANY",
 *     description=name,
 *     acl_action="accept",
 *     source="127.0.0.1/32",
 *     source_type="net",
 *     destination="127.0.0.2/32",
 *     destination_type="net",
 *     proto="ANY")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.CloudFirewall.ControlPolicy("default", new()
 *     {
 *         Direction = "in",
 *         ApplicationName = "ANY",
 *         Description = name,
 *         AclAction = "accept",
 *         Source = "127.0.0.1/32",
 *         SourceType = "net",
 *         Destination = "127.0.0.2/32",
 *         DestinationType = "net",
 *         Proto = "ANY",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cloudfirewall.NewControlPolicy(ctx, "default", &cloudfirewall.ControlPolicyArgs{
 * 			Direction:       pulumi.String("in"),
 * 			ApplicationName: pulumi.String("ANY"),
 * 			Description:     pulumi.String(name),
 * 			AclAction:       pulumi.String("accept"),
 * 			Source:          pulumi.String("127.0.0.1/32"),
 * 			SourceType:      pulumi.String("net"),
 * 			Destination:     pulumi.String("127.0.0.2/32"),
 * 			DestinationType: pulumi.String("net"),
 * 			Proto:           pulumi.String("ANY"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudfirewall.ControlPolicy;
 * import com.pulumi.alicloud.cloudfirewall.ControlPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ControlPolicy("default", ControlPolicyArgs.builder()
 *             .direction("in")
 *             .applicationName("ANY")
 *             .description(name)
 *             .aclAction("accept")
 *             .source("127.0.0.1/32")
 *             .sourceType("net")
 *             .destination("127.0.0.2/32")
 *             .destinationType("net")
 *             .proto("ANY")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:cloudfirewall:ControlPolicy
 *     properties:
 *       direction: in
 *       applicationName: ANY
 *       description: ${name}
 *       aclAction: accept
 *       source: 127.0.0.1/32
 *       sourceType: net
 *       destination: 127.0.0.2/32
 *       destinationType: net
 *       proto: ANY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Firewall Control Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/controlPolicy:ControlPolicy example <acl_uuid>:<direction>
 * ```
 */
public class ControlPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudfirewall.ControlPolicy,
) : KotlinCustomResource(javaResource, ControlPolicyMapper) {
    /**
     * The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
     */
    public val aclAction: Output<String>
        get() = javaResource.aclAction().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.148.0) The unique ID of the access control policy.
     */
    public val aclUuid: Output<String>
        get() = javaResource.aclUuid().applyValue({ args0 -> args0 })

    /**
     * The application type supported by the access control policy. Valid values: `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
     * > **NOTE:** If `proto` is set to `TCP`, you can set `application_name` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name` to `ANY`.
     */
    public val applicationName: Output<String>
        get() = javaResource.applicationName().applyValue({ args0 -> args0 })

    /**
     * The description of the access control policy.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify `dest_port`.
     */
    public val destPort: Output<String>
        get() = javaResource.destPort().applyValue({ args0 -> args0 })

    /**
     * The name of the destination port address book in the access control policy. **Note:** If `dest_port_type` is set to `group`, you must specify `dest_port_group`.
     */
    public val destPortGroup: Output<String>?
        get() = javaResource.destPortGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the destination port in the access control policy. Valid values: `port`, `group`.
     */
    public val destPortType: Output<String>
        get() = javaResource.destPortType().applyValue({ args0 -> args0 })

    /**
     * The destination address in the access control policy.
     */
    public val destination: Output<String>
        get() = javaResource.destination().applyValue({ args0 -> args0 })

    /**
     * The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`, `location`.
     */
    public val destinationType: Output<String>
        get() = javaResource.destinationType().applyValue({ args0 -> args0 })

    /**
     * The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
     */
    public val direction: Output<String>
        get() = javaResource.direction().applyValue({ args0 -> args0 })

    /**
     * The IP version supported by the access control policy. Default value: `4`. Valid values:
     */
    public val ipVersion: Output<String>
        get() = javaResource.ipVersion().applyValue({ args0 -> args0 })

    /**
     * The language of the content within the request and response. Valid values: `zh`, `en`.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The protocol type supported by the access control policy. Valid values: `ANY`, ` TCP`, `UDP`, `ICMP`.
     */
    public val proto: Output<String>
        get() = javaResource.proto().applyValue({ args0 -> args0 })

    /**
     * The status of the access control policy. Valid values: `true`, `false`.
     */
    public val release: Output<String>
        get() = javaResource.release().applyValue({ args0 -> args0 })

    /**
     * The source address in the access control policy.
     */
    public val source: Output<String>
        get() = javaResource.source().applyValue({ args0 -> args0 })

    /**
     * The source IP address of the request.
     */
    public val sourceIp: Output<String>?
        get() = javaResource.sourceIp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the source address in the access control policy. Valid values: `net`, `group`, `location`.
     */
    public val sourceType: Output<String>
        get() = javaResource.sourceType().applyValue({ args0 -> args0 })
}

public object ControlPolicyMapper : ResourceMapper<ControlPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudfirewall.ControlPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ControlPolicy = ControlPolicy(
        javaResource as
            com.pulumi.alicloud.cloudfirewall.ControlPolicy,
    )
}

/**
 * @see [ControlPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ControlPolicy].
 */
public suspend fun controlPolicy(
    name: String,
    block: suspend ControlPolicyResourceBuilder.() -> Unit,
): ControlPolicy {
    val builder = ControlPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ControlPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun controlPolicy(name: String): ControlPolicy {
    val builder = ControlPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
