@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.alicloud.cloudfirewall.ControlPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Firewall Control Policy resource.
 * For information about Cloud Firewall Control Policy and how to use it, see [What is Control Policy](https://www.alibabacloud.com/help/doc-detail/138867.htm).
 * > **NOTE:** Available since v1.129.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.cloudfirewall.ControlPolicy("default", {
 *     direction: "in",
 *     applicationName: "ANY",
 *     description: name,
 *     aclAction: "accept",
 *     source: "127.0.0.1/32",
 *     sourceType: "net",
 *     destination: "127.0.0.2/32",
 *     destinationType: "net",
 *     proto: "ANY",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.cloudfirewall.ControlPolicy("default",
 *     direction="in",
 *     application_name="ANY",
 *     description=name,
 *     acl_action="accept",
 *     source="127.0.0.1/32",
 *     source_type="net",
 *     destination="127.0.0.2/32",
 *     destination_type="net",
 *     proto="ANY")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.CloudFirewall.ControlPolicy("default", new()
 *     {
 *         Direction = "in",
 *         ApplicationName = "ANY",
 *         Description = name,
 *         AclAction = "accept",
 *         Source = "127.0.0.1/32",
 *         SourceType = "net",
 *         Destination = "127.0.0.2/32",
 *         DestinationType = "net",
 *         Proto = "ANY",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cloudfirewall.NewControlPolicy(ctx, "default", &cloudfirewall.ControlPolicyArgs{
 * 			Direction:       pulumi.String("in"),
 * 			ApplicationName: pulumi.String("ANY"),
 * 			Description:     pulumi.String(name),
 * 			AclAction:       pulumi.String("accept"),
 * 			Source:          pulumi.String("127.0.0.1/32"),
 * 			SourceType:      pulumi.String("net"),
 * 			Destination:     pulumi.String("127.0.0.2/32"),
 * 			DestinationType: pulumi.String("net"),
 * 			Proto:           pulumi.String("ANY"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudfirewall.ControlPolicy;
 * import com.pulumi.alicloud.cloudfirewall.ControlPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ControlPolicy("default", ControlPolicyArgs.builder()
 *             .direction("in")
 *             .applicationName("ANY")
 *             .description(name)
 *             .aclAction("accept")
 *             .source("127.0.0.1/32")
 *             .sourceType("net")
 *             .destination("127.0.0.2/32")
 *             .destinationType("net")
 *             .proto("ANY")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:cloudfirewall:ControlPolicy
 *     properties:
 *       direction: in
 *       applicationName: ANY
 *       description: ${name}
 *       aclAction: accept
 *       source: 127.0.0.1/32
 *       sourceType: net
 *       destination: 127.0.0.2/32
 *       destinationType: net
 *       proto: ANY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Firewall Control Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/controlPolicy:ControlPolicy example <acl_uuid>:<direction>
 * ```
 * @property aclAction The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
 * @property applicationName The application type supported by the access control policy. Valid values: `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
 * > **NOTE:** If `proto` is set to `TCP`, you can set `application_name` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name` to `ANY`.
 * @property description The description of the access control policy.
 * @property destPort The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify `dest_port`.
 * @property destPortGroup The name of the destination port address book in the access control policy. **Note:** If `dest_port_type` is set to `group`, you must specify `dest_port_group`.
 * @property destPortType The type of the destination port in the access control policy. Valid values: `port`, `group`.
 * @property destination The destination address in the access control policy.
 * @property destinationType The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`, `location`.
 * @property direction The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
 * @property ipVersion The IP version supported by the access control policy. Default value: `4`. Valid values:
 * @property lang The language of the content within the request and response. Valid values: `zh`, `en`.
 * @property proto The protocol type supported by the access control policy. Valid values: `ANY`, ` TCP`, `UDP`, `ICMP`.
 * @property release The status of the access control policy. Valid values: `true`, `false`.
 * @property source The source address in the access control policy.
 * @property sourceIp The source IP address of the request.
 * @property sourceType The type of the source address in the access control policy. Valid values: `net`, `group`, `location`.
 */
public data class ControlPolicyArgs(
    public val aclAction: Output<String>? = null,
    public val applicationName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val destPort: Output<String>? = null,
    public val destPortGroup: Output<String>? = null,
    public val destPortType: Output<String>? = null,
    public val destination: Output<String>? = null,
    public val destinationType: Output<String>? = null,
    public val direction: Output<String>? = null,
    public val ipVersion: Output<String>? = null,
    public val lang: Output<String>? = null,
    public val proto: Output<String>? = null,
    public val release: Output<String>? = null,
    public val source: Output<String>? = null,
    public val sourceIp: Output<String>? = null,
    public val sourceType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.ControlPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.ControlPolicyArgs =
        com.pulumi.alicloud.cloudfirewall.ControlPolicyArgs.builder()
            .aclAction(aclAction?.applyValue({ args0 -> args0 }))
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .destPort(destPort?.applyValue({ args0 -> args0 }))
            .destPortGroup(destPortGroup?.applyValue({ args0 -> args0 }))
            .destPortType(destPortType?.applyValue({ args0 -> args0 }))
            .destination(destination?.applyValue({ args0 -> args0 }))
            .destinationType(destinationType?.applyValue({ args0 -> args0 }))
            .direction(direction?.applyValue({ args0 -> args0 }))
            .ipVersion(ipVersion?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 }))
            .proto(proto?.applyValue({ args0 -> args0 }))
            .release(release?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .sourceIp(sourceIp?.applyValue({ args0 -> args0 }))
            .sourceType(sourceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ControlPolicyArgs].
 */
@PulumiTagMarker
public class ControlPolicyArgsBuilder internal constructor() {
    private var aclAction: Output<String>? = null

    private var applicationName: Output<String>? = null

    private var description: Output<String>? = null

    private var destPort: Output<String>? = null

    private var destPortGroup: Output<String>? = null

    private var destPortType: Output<String>? = null

    private var destination: Output<String>? = null

    private var destinationType: Output<String>? = null

    private var direction: Output<String>? = null

    private var ipVersion: Output<String>? = null

    private var lang: Output<String>? = null

    private var proto: Output<String>? = null

    private var release: Output<String>? = null

    private var source: Output<String>? = null

    private var sourceIp: Output<String>? = null

    private var sourceType: Output<String>? = null

    /**
     * @param value The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
     */
    @JvmName("noeynjcklqtfeoib")
    public suspend fun aclAction(`value`: Output<String>) {
        this.aclAction = value
    }

    /**
     * @param value The application type supported by the access control policy. Valid values: `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
     * > **NOTE:** If `proto` is set to `TCP`, you can set `application_name` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name` to `ANY`.
     */
    @JvmName("eixekohwwphlumal")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The description of the access control policy.
     */
    @JvmName("wgnmandyuyvvqphs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify `dest_port`.
     */
    @JvmName("gtvdecupboluexst")
    public suspend fun destPort(`value`: Output<String>) {
        this.destPort = value
    }

    /**
     * @param value The name of the destination port address book in the access control policy. **Note:** If `dest_port_type` is set to `group`, you must specify `dest_port_group`.
     */
    @JvmName("txwonoetdbhcymxy")
    public suspend fun destPortGroup(`value`: Output<String>) {
        this.destPortGroup = value
    }

    /**
     * @param value The type of the destination port in the access control policy. Valid values: `port`, `group`.
     */
    @JvmName("ehcxjbhqvcpghdcp")
    public suspend fun destPortType(`value`: Output<String>) {
        this.destPortType = value
    }

    /**
     * @param value The destination address in the access control policy.
     */
    @JvmName("bfneuxqornakhfql")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`, `location`.
     */
    @JvmName("pylybipuuhwmlhng")
    public suspend fun destinationType(`value`: Output<String>) {
        this.destinationType = value
    }

    /**
     * @param value The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
     */
    @JvmName("xuqxnkrtkvsuwvfc")
    public suspend fun direction(`value`: Output<String>) {
        this.direction = value
    }

    /**
     * @param value The IP version supported by the access control policy. Default value: `4`. Valid values:
     */
    @JvmName("ugfnnmwawewnukvq")
    public suspend fun ipVersion(`value`: Output<String>) {
        this.ipVersion = value
    }

    /**
     * @param value The language of the content within the request and response. Valid values: `zh`, `en`.
     */
    @JvmName("mhfasqrpagdjqqoo")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The protocol type supported by the access control policy. Valid values: `ANY`, ` TCP`, `UDP`, `ICMP`.
     */
    @JvmName("yuoomtccwwfdbdag")
    public suspend fun proto(`value`: Output<String>) {
        this.proto = value
    }

    /**
     * @param value The status of the access control policy. Valid values: `true`, `false`.
     */
    @JvmName("dskarwyiclwodkso")
    public suspend fun release(`value`: Output<String>) {
        this.release = value
    }

    /**
     * @param value The source address in the access control policy.
     */
    @JvmName("dgivjviqeiwxovwj")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The source IP address of the request.
     */
    @JvmName("lxepqlklfopmhjtr")
    public suspend fun sourceIp(`value`: Output<String>) {
        this.sourceIp = value
    }

    /**
     * @param value The type of the source address in the access control policy. Valid values: `net`, `group`, `location`.
     */
    @JvmName("hvmloogjoyercypu")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
     */
    @JvmName("xbxkqpgydjbepwae")
    public suspend fun aclAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclAction = mapped
    }

    /**
     * @param value The application type supported by the access control policy. Valid values: `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
     * > **NOTE:** If `proto` is set to `TCP`, you can set `application_name` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name` to `ANY`.
     */
    @JvmName("smlqsidjmnknkiia")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The description of the access control policy.
     */
    @JvmName("ijcorkocuwdpbduc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify `dest_port`.
     */
    @JvmName("qdwupxennwmrphtm")
    public suspend fun destPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destPort = mapped
    }

    /**
     * @param value The name of the destination port address book in the access control policy. **Note:** If `dest_port_type` is set to `group`, you must specify `dest_port_group`.
     */
    @JvmName("kamshftacsfspltr")
    public suspend fun destPortGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destPortGroup = mapped
    }

    /**
     * @param value The type of the destination port in the access control policy. Valid values: `port`, `group`.
     */
    @JvmName("lkxpxagxgylrocuh")
    public suspend fun destPortType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destPortType = mapped
    }

    /**
     * @param value The destination address in the access control policy.
     */
    @JvmName("plkibkauxhbotvhw")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`, `location`.
     */
    @JvmName("auqogsolipqlhili")
    public suspend fun destinationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    /**
     * @param value The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
     */
    @JvmName("dhlxswxvuhtuewds")
    public suspend fun direction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The IP version supported by the access control policy. Default value: `4`. Valid values:
     */
    @JvmName("cimyonjtvbeirngp")
    public suspend fun ipVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipVersion = mapped
    }

    /**
     * @param value The language of the content within the request and response. Valid values: `zh`, `en`.
     */
    @JvmName("hfmairywbfywehfy")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The protocol type supported by the access control policy. Valid values: `ANY`, ` TCP`, `UDP`, `ICMP`.
     */
    @JvmName("kmqkvydyouhnvjns")
    public suspend fun proto(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proto = mapped
    }

    /**
     * @param value The status of the access control policy. Valid values: `true`, `false`.
     */
    @JvmName("joqtuaeylldjglbh")
    public suspend fun release(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.release = mapped
    }

    /**
     * @param value The source address in the access control policy.
     */
    @JvmName("iqhbxxldhgybvnmh")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The source IP address of the request.
     */
    @JvmName("bhaehoarletvqoeh")
    public suspend fun sourceIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIp = mapped
    }

    /**
     * @param value The type of the source address in the access control policy. Valid values: `net`, `group`, `location`.
     */
    @JvmName("eitobfuduhfwumef")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    internal fun build(): ControlPolicyArgs = ControlPolicyArgs(
        aclAction = aclAction,
        applicationName = applicationName,
        description = description,
        destPort = destPort,
        destPortGroup = destPortGroup,
        destPortType = destPortType,
        destination = destination,
        destinationType = destinationType,
        direction = direction,
        ipVersion = ipVersion,
        lang = lang,
        proto = proto,
        release = release,
        source = source,
        sourceIp = sourceIp,
        sourceType = sourceType,
    )
}
