@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.FirewallVpcFirewallLocalVpc
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.FirewallVpcFirewallPeerVpc
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.FirewallVpcFirewallLocalVpc.Companion.toKotlin as firewallVpcFirewallLocalVpcToKotlin
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.FirewallVpcFirewallPeerVpc.Companion.toKotlin as firewallVpcFirewallPeerVpcToKotlin

/**
 * Builder for [FirewallVpcFirewall].
 */
@PulumiTagMarker
public class FirewallVpcFirewallResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallVpcFirewallArgs = FirewallVpcFirewallArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallVpcFirewallArgsBuilder.() -> Unit) {
        val builder = FirewallVpcFirewallArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FirewallVpcFirewall {
        val builtJavaResource =
            com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewall(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FirewallVpcFirewall(builtJavaResource)
    }
}

/**
 * Provides a Cloud Firewall Vpc Firewall resource.
 * For information about Cloud Firewall Vpc Firewall and how to use it, see [What is Vpc Firewall](https://www.alibabacloud.com/help/en/cloud-firewall/developer-reference/api-cloudfw-2017-12-07-createvpcfirewallconfigure).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const current = alicloud.getAccount({});
 * const _default = new alicloud.cloudfirewall.FirewallVpcFirewall("default", {
 *     vpcFirewallName: "tf-example",
 *     memberUid: current.then(current => current.id),
 *     localVpc: {
 *         vpcId: "vpc-bp1d065m6hzn1xbw8ibfd",
 *         regionNo: "cn-hangzhou",
 *         localVpcCidrTableLists: [{
 *             localRouteTableId: "vtb-bp1lj0ddg846856chpzrv",
 *             localRouteEntryLists: [{
 *                 localNextHopInstanceId: "ri-bp1uobww3aputjlwwkyrh",
 *                 localDestinationCidr: "10.1.0.0/16",
 *             }],
 *         }],
 *     },
 *     peerVpc: {
 *         vpcId: "vpc-bp1gcmm64o3caox84v0nz",
 *         regionNo: "cn-hangzhou",
 *         peerVpcCidrTableLists: [{
 *             peerRouteTableId: "vtb-bp1f516f2hh4sok1ig9b5",
 *             peerRouteEntryLists: [{
 *                 peerDestinationCidr: "10.0.0.0/16",
 *                 peerNextHopInstanceId: "ri-bp1thhtgf6ydr2or52l3n",
 *             }],
 *         }],
 *     },
 *     status: "open",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * current = alicloud.get_account()
 * default = alicloud.cloudfirewall.FirewallVpcFirewall("default",
 *     vpc_firewall_name="tf-example",
 *     member_uid=current.id,
 *     local_vpc={
 *         "vpc_id": "vpc-bp1d065m6hzn1xbw8ibfd",
 *         "region_no": "cn-hangzhou",
 *         "local_vpc_cidr_table_lists": [{
 *             "local_route_table_id": "vtb-bp1lj0ddg846856chpzrv",
 *             "local_route_entry_lists": [{
 *                 "local_next_hop_instance_id": "ri-bp1uobww3aputjlwwkyrh",
 *                 "local_destination_cidr": "10.1.0.0/16",
 *             }],
 *         }],
 *     },
 *     peer_vpc={
 *         "vpc_id": "vpc-bp1gcmm64o3caox84v0nz",
 *         "region_no": "cn-hangzhou",
 *         "peer_vpc_cidr_table_lists": [{
 *             "peer_route_table_id": "vtb-bp1f516f2hh4sok1ig9b5",
 *             "peer_route_entry_lists": [{
 *                 "peer_destination_cidr": "10.0.0.0/16",
 *                 "peer_next_hop_instance_id": "ri-bp1thhtgf6ydr2or52l3n",
 *             }],
 *         }],
 *     },
 *     status="open")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = AliCloud.GetAccount.Invoke();
 *     var @default = new AliCloud.CloudFirewall.FirewallVpcFirewall("default", new()
 *     {
 *         VpcFirewallName = "tf-example",
 *         MemberUid = current.Apply(getAccountResult => getAccountResult.Id),
 *         LocalVpc = new AliCloud.CloudFirewall.Inputs.FirewallVpcFirewallLocalVpcArgs
 *         {
 *             VpcId = "vpc-bp1d065m6hzn1xbw8ibfd",
 *             RegionNo = "cn-hangzhou",
 *             LocalVpcCidrTableLists = new[]
 *             {
 *                 new AliCloud.CloudFirewall.Inputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs
 *                 {
 *                     LocalRouteTableId = "vtb-bp1lj0ddg846856chpzrv",
 *                     LocalRouteEntryLists = new[]
 *                     {
 *                         new AliCloud.CloudFirewall.Inputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs
 *                         {
 *                             LocalNextHopInstanceId = "ri-bp1uobww3aputjlwwkyrh",
 *                             LocalDestinationCidr = "10.1.0.0/16",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         PeerVpc = new AliCloud.CloudFirewall.Inputs.FirewallVpcFirewallPeerVpcArgs
 *         {
 *             VpcId = "vpc-bp1gcmm64o3caox84v0nz",
 *             RegionNo = "cn-hangzhou",
 *             PeerVpcCidrTableLists = new[]
 *             {
 *                 new AliCloud.CloudFirewall.Inputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs
 *                 {
 *                     PeerRouteTableId = "vtb-bp1f516f2hh4sok1ig9b5",
 *                     PeerRouteEntryLists = new[]
 *                     {
 *                         new AliCloud.CloudFirewall.Inputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs
 *                         {
 *                             PeerDestinationCidr = "10.0.0.0/16",
 *                             PeerNextHopInstanceId = "ri-bp1thhtgf6ydr2or52l3n",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Status = "open",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudfirewall.NewFirewallVpcFirewall(ctx, "default", &cloudfirewall.FirewallVpcFirewallArgs{
 * 			VpcFirewallName: pulumi.String("tf-example"),
 * 			MemberUid:       pulumi.String(current.Id),
 * 			LocalVpc: &cloudfirewall.FirewallVpcFirewallLocalVpcArgs{
 * 				VpcId:    pulumi.String("vpc-bp1d065m6hzn1xbw8ibfd"),
 * 				RegionNo: pulumi.String("cn-hangzhou"),
 * 				LocalVpcCidrTableLists: cloudfirewall.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArray{
 * 					&cloudfirewall.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs{
 * 						LocalRouteTableId: pulumi.String("vtb-bp1lj0ddg846856chpzrv"),
 * 						LocalRouteEntryLists: cloudfirewall.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArray{
 * 							&cloudfirewall.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs{
 * 								LocalNextHopInstanceId: pulumi.String("ri-bp1uobww3aputjlwwkyrh"),
 * 								LocalDestinationCidr:   pulumi.String("10.1.0.0/16"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			PeerVpc: &cloudfirewall.FirewallVpcFirewallPeerVpcArgs{
 * 				VpcId:    pulumi.String("vpc-bp1gcmm64o3caox84v0nz"),
 * 				RegionNo: pulumi.String("cn-hangzhou"),
 * 				PeerVpcCidrTableLists: cloudfirewall.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArray{
 * 					&cloudfirewall.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs{
 * 						PeerRouteTableId: pulumi.String("vtb-bp1f516f2hh4sok1ig9b5"),
 * 						PeerRouteEntryLists: cloudfirewall.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArray{
 * 							&cloudfirewall.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs{
 * 								PeerDestinationCidr:   pulumi.String("10.0.0.0/16"),
 * 								PeerNextHopInstanceId: pulumi.String("ri-bp1thhtgf6ydr2or52l3n"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Status: pulumi.String("open"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewall;
 * import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallArgs;
 * import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallLocalVpcArgs;
 * import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallPeerVpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AlicloudFunctions.getAccount();
 *         var default_ = new FirewallVpcFirewall("default", FirewallVpcFirewallArgs.builder()
 *             .vpcFirewallName("tf-example")
 *             .memberUid(current.applyValue(getAccountResult -> getAccountResult.id()))
 *             .localVpc(FirewallVpcFirewallLocalVpcArgs.builder()
 *                 .vpcId("vpc-bp1d065m6hzn1xbw8ibfd")
 *                 .regionNo("cn-hangzhou")
 *                 .localVpcCidrTableLists(FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs.builder()
 *                     .localRouteTableId("vtb-bp1lj0ddg846856chpzrv")
 *                     .localRouteEntryLists(FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs.builder()
 *                         .localNextHopInstanceId("ri-bp1uobww3aputjlwwkyrh")
 *                         .localDestinationCidr("10.1.0.0/16")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .peerVpc(FirewallVpcFirewallPeerVpcArgs.builder()
 *                 .vpcId("vpc-bp1gcmm64o3caox84v0nz")
 *                 .regionNo("cn-hangzhou")
 *                 .peerVpcCidrTableLists(FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs.builder()
 *                     .peerRouteTableId("vtb-bp1f516f2hh4sok1ig9b5")
 *                     .peerRouteEntryLists(FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs.builder()
 *                         .peerDestinationCidr("10.0.0.0/16")
 *                         .peerNextHopInstanceId("ri-bp1thhtgf6ydr2or52l3n")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .status("open")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:cloudfirewall:FirewallVpcFirewall
 *     properties:
 *       vpcFirewallName: tf-example
 *       memberUid: ${current.id}
 *       localVpc:
 *         vpcId: vpc-bp1d065m6hzn1xbw8ibfd
 *         regionNo: cn-hangzhou
 *         localVpcCidrTableLists:
 *           - localRouteTableId: vtb-bp1lj0ddg846856chpzrv
 *             localRouteEntryLists:
 *               - localNextHopInstanceId: ri-bp1uobww3aputjlwwkyrh
 *                 localDestinationCidr: 10.1.0.0/16
 *       peerVpc:
 *         vpcId: vpc-bp1gcmm64o3caox84v0nz
 *         regionNo: cn-hangzhou
 *         peerVpcCidrTableLists:
 *           - peerRouteTableId: vtb-bp1f516f2hh4sok1ig9b5
 *             peerRouteEntryLists:
 *               - peerDestinationCidr: 10.0.0.0/16
 *                 peerNextHopInstanceId: ri-bp1thhtgf6ydr2or52l3n
 *       status: open
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Firewall Vpc Firewall can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/firewallVpcFirewall:FirewallVpcFirewall example <id>
 * ```
 */
public class FirewallVpcFirewall internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewall,
) : KotlinCustomResource(javaResource, FirewallVpcFirewallMapper) {
    /**
     * Bandwidth specifications for high-speed channels. Unit: Mbps.
     */
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The communication type of the VPC firewall.
     */
    public val connectType: Output<String>
        get() = javaResource.connectType().applyValue({ args0 -> args0 })

    /**
     * The language type of the requested and received messages. Valid values:
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The details of the local VPC. See `local_vpc` below.
     */
    public val localVpc: Output<FirewallVpcFirewallLocalVpc>
        get() = javaResource.localVpc().applyValue({ args0 ->
            args0.let({ args0 ->
                firewallVpcFirewallLocalVpcToKotlin(args0)
            })
        })

    /**
     * The UID of the Alibaba Cloud member account.
     */
    public val memberUid: Output<String>?
        get() = javaResource.memberUid().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The details of the peer VPC. See `peer_vpc` below.
     */
    public val peerVpc: Output<FirewallVpcFirewallPeerVpc>
        get() = javaResource.peerVpc().applyValue({ args0 ->
            args0.let({ args0 ->
                firewallVpcFirewallPeerVpcToKotlin(args0)
            })
        })

    /**
     * The region is open.
     */
    public val regionStatus: Output<String>
        get() = javaResource.regionStatus().applyValue({ args0 -> args0 })

    /**
     * The status of the resource. Valid values:
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC firewall instance.
     */
    public val vpcFirewallId: Output<String>
        get() = javaResource.vpcFirewallId().applyValue({ args0 -> args0 })

    /**
     * The name of the VPC firewall instance.
     */
    public val vpcFirewallName: Output<String>
        get() = javaResource.vpcFirewallName().applyValue({ args0 -> args0 })
}

public object FirewallVpcFirewallMapper : ResourceMapper<FirewallVpcFirewall> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewall::class == javaResource::class

    override fun map(javaResource: Resource): FirewallVpcFirewall = FirewallVpcFirewall(
        javaResource
            as com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewall,
    )
}

/**
 * @see [FirewallVpcFirewall].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirewallVpcFirewall].
 */
public suspend fun firewallVpcFirewall(
    name: String,
    block: suspend FirewallVpcFirewallResourceBuilder.() -> Unit,
): FirewallVpcFirewall {
    val builder = FirewallVpcFirewallResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirewallVpcFirewall].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewallVpcFirewall(name: String): FirewallVpcFirewall {
    val builder = FirewallVpcFirewallResourceBuilder()
    builder.name(name)
    return builder.build()
}
