@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallArgs.builder
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.FirewallVpcFirewallLocalVpcArgs
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.FirewallVpcFirewallLocalVpcArgsBuilder
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.FirewallVpcFirewallPeerVpcArgs
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.FirewallVpcFirewallPeerVpcArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Firewall Vpc Firewall resource.
 * For information about Cloud Firewall Vpc Firewall and how to use it, see [What is Vpc Firewall](https://www.alibabacloud.com/help/en/cloud-firewall/developer-reference/api-cloudfw-2017-12-07-createvpcfirewallconfigure).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const current = alicloud.getAccount({});
 * const _default = new alicloud.cloudfirewall.FirewallVpcFirewall("default", {
 *     vpcFirewallName: "tf-example",
 *     memberUid: current.then(current => current.id),
 *     localVpc: {
 *         vpcId: "vpc-bp1d065m6hzn1xbw8ibfd",
 *         regionNo: "cn-hangzhou",
 *         localVpcCidrTableLists: [{
 *             localRouteTableId: "vtb-bp1lj0ddg846856chpzrv",
 *             localRouteEntryLists: [{
 *                 localNextHopInstanceId: "ri-bp1uobww3aputjlwwkyrh",
 *                 localDestinationCidr: "10.1.0.0/16",
 *             }],
 *         }],
 *     },
 *     peerVpc: {
 *         vpcId: "vpc-bp1gcmm64o3caox84v0nz",
 *         regionNo: "cn-hangzhou",
 *         peerVpcCidrTableLists: [{
 *             peerRouteTableId: "vtb-bp1f516f2hh4sok1ig9b5",
 *             peerRouteEntryLists: [{
 *                 peerDestinationCidr: "10.0.0.0/16",
 *                 peerNextHopInstanceId: "ri-bp1thhtgf6ydr2or52l3n",
 *             }],
 *         }],
 *     },
 *     status: "open",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * current = alicloud.get_account()
 * default = alicloud.cloudfirewall.FirewallVpcFirewall("default",
 *     vpc_firewall_name="tf-example",
 *     member_uid=current.id,
 *     local_vpc={
 *         "vpc_id": "vpc-bp1d065m6hzn1xbw8ibfd",
 *         "region_no": "cn-hangzhou",
 *         "local_vpc_cidr_table_lists": [{
 *             "local_route_table_id": "vtb-bp1lj0ddg846856chpzrv",
 *             "local_route_entry_lists": [{
 *                 "local_next_hop_instance_id": "ri-bp1uobww3aputjlwwkyrh",
 *                 "local_destination_cidr": "10.1.0.0/16",
 *             }],
 *         }],
 *     },
 *     peer_vpc={
 *         "vpc_id": "vpc-bp1gcmm64o3caox84v0nz",
 *         "region_no": "cn-hangzhou",
 *         "peer_vpc_cidr_table_lists": [{
 *             "peer_route_table_id": "vtb-bp1f516f2hh4sok1ig9b5",
 *             "peer_route_entry_lists": [{
 *                 "peer_destination_cidr": "10.0.0.0/16",
 *                 "peer_next_hop_instance_id": "ri-bp1thhtgf6ydr2or52l3n",
 *             }],
 *         }],
 *     },
 *     status="open")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = AliCloud.GetAccount.Invoke();
 *     var @default = new AliCloud.CloudFirewall.FirewallVpcFirewall("default", new()
 *     {
 *         VpcFirewallName = "tf-example",
 *         MemberUid = current.Apply(getAccountResult => getAccountResult.Id),
 *         LocalVpc = new AliCloud.CloudFirewall.Inputs.FirewallVpcFirewallLocalVpcArgs
 *         {
 *             VpcId = "vpc-bp1d065m6hzn1xbw8ibfd",
 *             RegionNo = "cn-hangzhou",
 *             LocalVpcCidrTableLists = new[]
 *             {
 *                 new AliCloud.CloudFirewall.Inputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs
 *                 {
 *                     LocalRouteTableId = "vtb-bp1lj0ddg846856chpzrv",
 *                     LocalRouteEntryLists = new[]
 *                     {
 *                         new AliCloud.CloudFirewall.Inputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs
 *                         {
 *                             LocalNextHopInstanceId = "ri-bp1uobww3aputjlwwkyrh",
 *                             LocalDestinationCidr = "10.1.0.0/16",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         PeerVpc = new AliCloud.CloudFirewall.Inputs.FirewallVpcFirewallPeerVpcArgs
 *         {
 *             VpcId = "vpc-bp1gcmm64o3caox84v0nz",
 *             RegionNo = "cn-hangzhou",
 *             PeerVpcCidrTableLists = new[]
 *             {
 *                 new AliCloud.CloudFirewall.Inputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs
 *                 {
 *                     PeerRouteTableId = "vtb-bp1f516f2hh4sok1ig9b5",
 *                     PeerRouteEntryLists = new[]
 *                     {
 *                         new AliCloud.CloudFirewall.Inputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs
 *                         {
 *                             PeerDestinationCidr = "10.0.0.0/16",
 *                             PeerNextHopInstanceId = "ri-bp1thhtgf6ydr2or52l3n",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Status = "open",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudfirewall.NewFirewallVpcFirewall(ctx, "default", &cloudfirewall.FirewallVpcFirewallArgs{
 * 			VpcFirewallName: pulumi.String("tf-example"),
 * 			MemberUid:       pulumi.String(current.Id),
 * 			LocalVpc: &cloudfirewall.FirewallVpcFirewallLocalVpcArgs{
 * 				VpcId:    pulumi.String("vpc-bp1d065m6hzn1xbw8ibfd"),
 * 				RegionNo: pulumi.String("cn-hangzhou"),
 * 				LocalVpcCidrTableLists: cloudfirewall.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArray{
 * 					&cloudfirewall.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs{
 * 						LocalRouteTableId: pulumi.String("vtb-bp1lj0ddg846856chpzrv"),
 * 						LocalRouteEntryLists: cloudfirewall.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArray{
 * 							&cloudfirewall.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs{
 * 								LocalNextHopInstanceId: pulumi.String("ri-bp1uobww3aputjlwwkyrh"),
 * 								LocalDestinationCidr:   pulumi.String("10.1.0.0/16"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			PeerVpc: &cloudfirewall.FirewallVpcFirewallPeerVpcArgs{
 * 				VpcId:    pulumi.String("vpc-bp1gcmm64o3caox84v0nz"),
 * 				RegionNo: pulumi.String("cn-hangzhou"),
 * 				PeerVpcCidrTableLists: cloudfirewall.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArray{
 * 					&cloudfirewall.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs{
 * 						PeerRouteTableId: pulumi.String("vtb-bp1f516f2hh4sok1ig9b5"),
 * 						PeerRouteEntryLists: cloudfirewall.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArray{
 * 							&cloudfirewall.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs{
 * 								PeerDestinationCidr:   pulumi.String("10.0.0.0/16"),
 * 								PeerNextHopInstanceId: pulumi.String("ri-bp1thhtgf6ydr2or52l3n"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Status: pulumi.String("open"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewall;
 * import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallArgs;
 * import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallLocalVpcArgs;
 * import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallPeerVpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AlicloudFunctions.getAccount();
 *         var default_ = new FirewallVpcFirewall("default", FirewallVpcFirewallArgs.builder()
 *             .vpcFirewallName("tf-example")
 *             .memberUid(current.applyValue(getAccountResult -> getAccountResult.id()))
 *             .localVpc(FirewallVpcFirewallLocalVpcArgs.builder()
 *                 .vpcId("vpc-bp1d065m6hzn1xbw8ibfd")
 *                 .regionNo("cn-hangzhou")
 *                 .localVpcCidrTableLists(FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs.builder()
 *                     .localRouteTableId("vtb-bp1lj0ddg846856chpzrv")
 *                     .localRouteEntryLists(FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs.builder()
 *                         .localNextHopInstanceId("ri-bp1uobww3aputjlwwkyrh")
 *                         .localDestinationCidr("10.1.0.0/16")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .peerVpc(FirewallVpcFirewallPeerVpcArgs.builder()
 *                 .vpcId("vpc-bp1gcmm64o3caox84v0nz")
 *                 .regionNo("cn-hangzhou")
 *                 .peerVpcCidrTableLists(FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs.builder()
 *                     .peerRouteTableId("vtb-bp1f516f2hh4sok1ig9b5")
 *                     .peerRouteEntryLists(FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs.builder()
 *                         .peerDestinationCidr("10.0.0.0/16")
 *                         .peerNextHopInstanceId("ri-bp1thhtgf6ydr2or52l3n")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .status("open")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:cloudfirewall:FirewallVpcFirewall
 *     properties:
 *       vpcFirewallName: tf-example
 *       memberUid: ${current.id}
 *       localVpc:
 *         vpcId: vpc-bp1d065m6hzn1xbw8ibfd
 *         regionNo: cn-hangzhou
 *         localVpcCidrTableLists:
 *           - localRouteTableId: vtb-bp1lj0ddg846856chpzrv
 *             localRouteEntryLists:
 *               - localNextHopInstanceId: ri-bp1uobww3aputjlwwkyrh
 *                 localDestinationCidr: 10.1.0.0/16
 *       peerVpc:
 *         vpcId: vpc-bp1gcmm64o3caox84v0nz
 *         regionNo: cn-hangzhou
 *         peerVpcCidrTableLists:
 *           - peerRouteTableId: vtb-bp1f516f2hh4sok1ig9b5
 *             peerRouteEntryLists:
 *               - peerDestinationCidr: 10.0.0.0/16
 *                 peerNextHopInstanceId: ri-bp1thhtgf6ydr2or52l3n
 *       status: open
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Firewall Vpc Firewall can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/firewallVpcFirewall:FirewallVpcFirewall example <id>
 * ```
 * @property lang The language type of the requested and received messages. Valid values:
 * @property localVpc The details of the local VPC. See `local_vpc` below.
 * @property memberUid The UID of the Alibaba Cloud member account.
 * @property peerVpc The details of the peer VPC. See `peer_vpc` below.
 * @property status The status of the resource. Valid values:
 * @property vpcFirewallName The name of the VPC firewall instance.
 */
public data class FirewallVpcFirewallArgs(
    public val lang: Output<String>? = null,
    public val localVpc: Output<FirewallVpcFirewallLocalVpcArgs>? = null,
    public val memberUid: Output<String>? = null,
    public val peerVpc: Output<FirewallVpcFirewallPeerVpcArgs>? = null,
    public val status: Output<String>? = null,
    public val vpcFirewallName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallArgs =
        com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallArgs.builder()
            .lang(lang?.applyValue({ args0 -> args0 }))
            .localVpc(localVpc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .memberUid(memberUid?.applyValue({ args0 -> args0 }))
            .peerVpc(peerVpc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(status?.applyValue({ args0 -> args0 }))
            .vpcFirewallName(vpcFirewallName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallVpcFirewallArgs].
 */
@PulumiTagMarker
public class FirewallVpcFirewallArgsBuilder internal constructor() {
    private var lang: Output<String>? = null

    private var localVpc: Output<FirewallVpcFirewallLocalVpcArgs>? = null

    private var memberUid: Output<String>? = null

    private var peerVpc: Output<FirewallVpcFirewallPeerVpcArgs>? = null

    private var status: Output<String>? = null

    private var vpcFirewallName: Output<String>? = null

    /**
     * @param value The language type of the requested and received messages. Valid values:
     */
    @JvmName("cfmbgoporuykdffm")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The details of the local VPC. See `local_vpc` below.
     */
    @JvmName("puvymrrwswkygfmq")
    public suspend fun localVpc(`value`: Output<FirewallVpcFirewallLocalVpcArgs>) {
        this.localVpc = value
    }

    /**
     * @param value The UID of the Alibaba Cloud member account.
     */
    @JvmName("dmwyretjjspwltbt")
    public suspend fun memberUid(`value`: Output<String>) {
        this.memberUid = value
    }

    /**
     * @param value The details of the peer VPC. See `peer_vpc` below.
     */
    @JvmName("bxqrwrccryhewbcs")
    public suspend fun peerVpc(`value`: Output<FirewallVpcFirewallPeerVpcArgs>) {
        this.peerVpc = value
    }

    /**
     * @param value The status of the resource. Valid values:
     */
    @JvmName("ewvvaaqbpvgiugcq")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of the VPC firewall instance.
     */
    @JvmName("bbcevqkhlfnoijhe")
    public suspend fun vpcFirewallName(`value`: Output<String>) {
        this.vpcFirewallName = value
    }

    /**
     * @param value The language type of the requested and received messages. Valid values:
     */
    @JvmName("iwkpwpvaxjkxiuhs")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The details of the local VPC. See `local_vpc` below.
     */
    @JvmName("rjcuuqoblrbvecja")
    public suspend fun localVpc(`value`: FirewallVpcFirewallLocalVpcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localVpc = mapped
    }

    /**
     * @param argument The details of the local VPC. See `local_vpc` below.
     */
    @JvmName("cndkqeqotmmsysgy")
    public suspend fun localVpc(argument: suspend FirewallVpcFirewallLocalVpcArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallVpcFirewallLocalVpcArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.localVpc = mapped
    }

    /**
     * @param value The UID of the Alibaba Cloud member account.
     */
    @JvmName("khqlpsbykofbyutr")
    public suspend fun memberUid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberUid = mapped
    }

    /**
     * @param value The details of the peer VPC. See `peer_vpc` below.
     */
    @JvmName("iyqppufrmduyrxxa")
    public suspend fun peerVpc(`value`: FirewallVpcFirewallPeerVpcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerVpc = mapped
    }

    /**
     * @param argument The details of the peer VPC. See `peer_vpc` below.
     */
    @JvmName("wspctcgmjwijkwco")
    public suspend fun peerVpc(argument: suspend FirewallVpcFirewallPeerVpcArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallVpcFirewallPeerVpcArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.peerVpc = mapped
    }

    /**
     * @param value The status of the resource. Valid values:
     */
    @JvmName("deleabykfualareu")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The name of the VPC firewall instance.
     */
    @JvmName("vygfuxscudhuwbdl")
    public suspend fun vpcFirewallName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcFirewallName = mapped
    }

    internal fun build(): FirewallVpcFirewallArgs = FirewallVpcFirewallArgs(
        lang = lang,
        localVpc = localVpc,
        memberUid = memberUid,
        peerVpc = peerVpc,
        status = status,
        vpcFirewallName = vpcFirewallName,
    )
}
