@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.FirewallVpcFirewallCenLocalVpc
import com.pulumi.alicloud.cloudfirewall.kotlin.outputs.FirewallVpcFirewallCenLocalVpc.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FirewallVpcFirewallCen].
 */
@PulumiTagMarker
public class FirewallVpcFirewallCenResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallVpcFirewallCenArgs = FirewallVpcFirewallCenArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallVpcFirewallCenArgsBuilder.() -> Unit) {
        val builder = FirewallVpcFirewallCenArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FirewallVpcFirewallCen {
        val builtJavaResource =
            com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallCen(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FirewallVpcFirewallCen(builtJavaResource)
    }
}

/**
 * Provides a Cloud Firewall Vpc Firewall Cen resource.
 * For information about Cloud Firewall Vpc Firewall Cen and how to use it, see [What is Vpc Firewall Cen](https://www.alibabacloud.com/help/en/cloud-firewall/latest/createvpcfirewallcenconfigure).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // These resource primary keys should be replaced with your actual values.
 * const _default = new alicloud.cloudfirewall.FirewallVpcFirewallCen("default", {
 *     cenId: "cen-xxx",
 *     localVpc: {
 *         networkInstanceId: "vpc-xxx",
 *     },
 *     status: "open",
 *     memberUid: "14151*****827022",
 *     vpcRegion: "cn-hangzhou",
 *     vpcFirewallName: "tf-vpc-firewall-name",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # These resource primary keys should be replaced with your actual values.
 * default = alicloud.cloudfirewall.FirewallVpcFirewallCen("default",
 *     cen_id="cen-xxx",
 *     local_vpc={
 *         "network_instance_id": "vpc-xxx",
 *     },
 *     status="open",
 *     member_uid="14151*****827022",
 *     vpc_region="cn-hangzhou",
 *     vpc_firewall_name="tf-vpc-firewall-name")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // These resource primary keys should be replaced with your actual values.
 *     var @default = new AliCloud.CloudFirewall.FirewallVpcFirewallCen("default", new()
 *     {
 *         CenId = "cen-xxx",
 *         LocalVpc = new AliCloud.CloudFirewall.Inputs.FirewallVpcFirewallCenLocalVpcArgs
 *         {
 *             NetworkInstanceId = "vpc-xxx",
 *         },
 *         Status = "open",
 *         MemberUid = "14151*****827022",
 *         VpcRegion = "cn-hangzhou",
 *         VpcFirewallName = "tf-vpc-firewall-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// These resource primary keys should be replaced with your actual values.
 * 		_, err := cloudfirewall.NewFirewallVpcFirewallCen(ctx, "default", &cloudfirewall.FirewallVpcFirewallCenArgs{
 * 			CenId: pulumi.String("cen-xxx"),
 * 			LocalVpc: &cloudfirewall.FirewallVpcFirewallCenLocalVpcArgs{
 * 				NetworkInstanceId: pulumi.String("vpc-xxx"),
 * 			},
 * 			Status:          pulumi.String("open"),
 * 			MemberUid:       pulumi.String("14151*****827022"),
 * 			VpcRegion:       pulumi.String("cn-hangzhou"),
 * 			VpcFirewallName: pulumi.String("tf-vpc-firewall-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallCen;
 * import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallCenArgs;
 * import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // These resource primary keys should be replaced with your actual values.
 *         var default_ = new FirewallVpcFirewallCen("default", FirewallVpcFirewallCenArgs.builder()
 *             .cenId("cen-xxx")
 *             .localVpc(FirewallVpcFirewallCenLocalVpcArgs.builder()
 *                 .networkInstanceId("vpc-xxx")
 *                 .build())
 *             .status("open")
 *             .memberUid("14151*****827022")
 *             .vpcRegion("cn-hangzhou")
 *             .vpcFirewallName("tf-vpc-firewall-name")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # These resource primary keys should be replaced with your actual values.
 *   default:
 *     type: alicloud:cloudfirewall:FirewallVpcFirewallCen
 *     properties:
 *       cenId: cen-xxx
 *       localVpc:
 *         networkInstanceId: vpc-xxx
 *       status: open
 *       memberUid: 14151*****827022
 *       vpcRegion: cn-hangzhou
 *       vpcFirewallName: tf-vpc-firewall-name
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Firewall Vpc Firewall Cen can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/firewallVpcFirewallCen:FirewallVpcFirewallCen example <id>
 * ```
 */
public class FirewallVpcFirewallCen internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallCen,
) : KotlinCustomResource(javaResource, FirewallVpcFirewallCenMapper) {
    /**
     * The ID of the CEN instance.
     */
    public val cenId: Output<String>
        get() = javaResource.cenId().applyValue({ args0 -> args0 })

    /**
     * Intercommunication type, value: expressconnect: Express Channel cen: Cloud Enterprise Network
     */
    public val connectType: Output<String>
        get() = javaResource.connectType().applyValue({ args0 -> args0 })

    /**
     * The language type of the requested and received messages. Valid values:
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The details of the VPC. See `local_vpc` below.
     */
    public val localVpc: Output<FirewallVpcFirewallCenLocalVpc>
        get() = javaResource.localVpc().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
     */
    public val memberUid: Output<String>?
        get() = javaResource.memberUid().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Firewall switch status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * VPC firewall ID
     */
    public val vpcFirewallId: Output<String>
        get() = javaResource.vpcFirewallId().applyValue({ args0 -> args0 })

    /**
     * The name of the VPC firewall instance.
     */
    public val vpcFirewallName: Output<String>
        get() = javaResource.vpcFirewallName().applyValue({ args0 -> args0 })

    /**
     * The ID of the region to which the VPC is created.
     */
    public val vpcRegion: Output<String>
        get() = javaResource.vpcRegion().applyValue({ args0 -> args0 })
}

public object FirewallVpcFirewallCenMapper : ResourceMapper<FirewallVpcFirewallCen> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallCen::class == javaResource::class

    override fun map(javaResource: Resource): FirewallVpcFirewallCen =
        FirewallVpcFirewallCen(
            javaResource as
                com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallCen,
        )
}

/**
 * @see [FirewallVpcFirewallCen].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirewallVpcFirewallCen].
 */
public suspend fun firewallVpcFirewallCen(
    name: String,
    block: suspend FirewallVpcFirewallCenResourceBuilder.() -> Unit,
): FirewallVpcFirewallCen {
    val builder = FirewallVpcFirewallCenResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirewallVpcFirewallCen].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewallVpcFirewallCen(name: String): FirewallVpcFirewallCen {
    val builder = FirewallVpcFirewallCenResourceBuilder()
    builder.name(name)
    return builder.build()
}
