@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallCenArgs.builder
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.FirewallVpcFirewallCenLocalVpcArgs
import com.pulumi.alicloud.cloudfirewall.kotlin.inputs.FirewallVpcFirewallCenLocalVpcArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Firewall Vpc Firewall Cen resource.
 * For information about Cloud Firewall Vpc Firewall Cen and how to use it, see [What is Vpc Firewall Cen](https://www.alibabacloud.com/help/en/cloud-firewall/latest/createvpcfirewallcenconfigure).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // These resource primary keys should be replaced with your actual values.
 * const _default = new alicloud.cloudfirewall.FirewallVpcFirewallCen("default", {
 *     cenId: "cen-xxx",
 *     localVpc: {
 *         networkInstanceId: "vpc-xxx",
 *     },
 *     status: "open",
 *     memberUid: "14151*****827022",
 *     vpcRegion: "cn-hangzhou",
 *     vpcFirewallName: "tf-vpc-firewall-name",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # These resource primary keys should be replaced with your actual values.
 * default = alicloud.cloudfirewall.FirewallVpcFirewallCen("default",
 *     cen_id="cen-xxx",
 *     local_vpc={
 *         "network_instance_id": "vpc-xxx",
 *     },
 *     status="open",
 *     member_uid="14151*****827022",
 *     vpc_region="cn-hangzhou",
 *     vpc_firewall_name="tf-vpc-firewall-name")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // These resource primary keys should be replaced with your actual values.
 *     var @default = new AliCloud.CloudFirewall.FirewallVpcFirewallCen("default", new()
 *     {
 *         CenId = "cen-xxx",
 *         LocalVpc = new AliCloud.CloudFirewall.Inputs.FirewallVpcFirewallCenLocalVpcArgs
 *         {
 *             NetworkInstanceId = "vpc-xxx",
 *         },
 *         Status = "open",
 *         MemberUid = "14151*****827022",
 *         VpcRegion = "cn-hangzhou",
 *         VpcFirewallName = "tf-vpc-firewall-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// These resource primary keys should be replaced with your actual values.
 * 		_, err := cloudfirewall.NewFirewallVpcFirewallCen(ctx, "default", &cloudfirewall.FirewallVpcFirewallCenArgs{
 * 			CenId: pulumi.String("cen-xxx"),
 * 			LocalVpc: &cloudfirewall.FirewallVpcFirewallCenLocalVpcArgs{
 * 				NetworkInstanceId: pulumi.String("vpc-xxx"),
 * 			},
 * 			Status:          pulumi.String("open"),
 * 			MemberUid:       pulumi.String("14151*****827022"),
 * 			VpcRegion:       pulumi.String("cn-hangzhou"),
 * 			VpcFirewallName: pulumi.String("tf-vpc-firewall-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallCen;
 * import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallCenArgs;
 * import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // These resource primary keys should be replaced with your actual values.
 *         var default_ = new FirewallVpcFirewallCen("default", FirewallVpcFirewallCenArgs.builder()
 *             .cenId("cen-xxx")
 *             .localVpc(FirewallVpcFirewallCenLocalVpcArgs.builder()
 *                 .networkInstanceId("vpc-xxx")
 *                 .build())
 *             .status("open")
 *             .memberUid("14151*****827022")
 *             .vpcRegion("cn-hangzhou")
 *             .vpcFirewallName("tf-vpc-firewall-name")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # These resource primary keys should be replaced with your actual values.
 *   default:
 *     type: alicloud:cloudfirewall:FirewallVpcFirewallCen
 *     properties:
 *       cenId: cen-xxx
 *       localVpc:
 *         networkInstanceId: vpc-xxx
 *       status: open
 *       memberUid: 14151*****827022
 *       vpcRegion: cn-hangzhou
 *       vpcFirewallName: tf-vpc-firewall-name
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Firewall Vpc Firewall Cen can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/firewallVpcFirewallCen:FirewallVpcFirewallCen example <id>
 * ```
 * @property cenId The ID of the CEN instance.
 * @property lang The language type of the requested and received messages. Valid values:
 * @property localVpc The details of the VPC. See `local_vpc` below.
 * @property memberUid The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
 * @property status Firewall switch status.
 * @property vpcFirewallName The name of the VPC firewall instance.
 * @property vpcRegion The ID of the region to which the VPC is created.
 */
public data class FirewallVpcFirewallCenArgs(
    public val cenId: Output<String>? = null,
    public val lang: Output<String>? = null,
    public val localVpc: Output<FirewallVpcFirewallCenLocalVpcArgs>? = null,
    public val memberUid: Output<String>? = null,
    public val status: Output<String>? = null,
    public val vpcFirewallName: Output<String>? = null,
    public val vpcRegion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallCenArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallCenArgs =
        com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallCenArgs.builder()
            .cenId(cenId?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 }))
            .localVpc(localVpc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .memberUid(memberUid?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .vpcFirewallName(vpcFirewallName?.applyValue({ args0 -> args0 }))
            .vpcRegion(vpcRegion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallVpcFirewallCenArgs].
 */
@PulumiTagMarker
public class FirewallVpcFirewallCenArgsBuilder internal constructor() {
    private var cenId: Output<String>? = null

    private var lang: Output<String>? = null

    private var localVpc: Output<FirewallVpcFirewallCenLocalVpcArgs>? = null

    private var memberUid: Output<String>? = null

    private var status: Output<String>? = null

    private var vpcFirewallName: Output<String>? = null

    private var vpcRegion: Output<String>? = null

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("vrlcuwmcuutombip")
    public suspend fun cenId(`value`: Output<String>) {
        this.cenId = value
    }

    /**
     * @param value The language type of the requested and received messages. Valid values:
     */
    @JvmName("enfbvvybaqjrxbkl")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The details of the VPC. See `local_vpc` below.
     */
    @JvmName("cdfedojmpnvnbhed")
    public suspend fun localVpc(`value`: Output<FirewallVpcFirewallCenLocalVpcArgs>) {
        this.localVpc = value
    }

    /**
     * @param value The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
     */
    @JvmName("qcgjfoxysiatelvg")
    public suspend fun memberUid(`value`: Output<String>) {
        this.memberUid = value
    }

    /**
     * @param value Firewall switch status.
     */
    @JvmName("lhfuqnlhpbllsftj")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of the VPC firewall instance.
     */
    @JvmName("kobeltghlsvrydnd")
    public suspend fun vpcFirewallName(`value`: Output<String>) {
        this.vpcFirewallName = value
    }

    /**
     * @param value The ID of the region to which the VPC is created.
     */
    @JvmName("vidfeyjyusuorirs")
    public suspend fun vpcRegion(`value`: Output<String>) {
        this.vpcRegion = value
    }

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("lhsqiwbmlxwyiqsb")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenId = mapped
    }

    /**
     * @param value The language type of the requested and received messages. Valid values:
     */
    @JvmName("agkngqfeuwwpkpid")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The details of the VPC. See `local_vpc` below.
     */
    @JvmName("gxkbstrshcbshaer")
    public suspend fun localVpc(`value`: FirewallVpcFirewallCenLocalVpcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localVpc = mapped
    }

    /**
     * @param argument The details of the VPC. See `local_vpc` below.
     */
    @JvmName("ibpvbvthprbcjwkp")
    public suspend fun localVpc(argument: suspend FirewallVpcFirewallCenLocalVpcArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallVpcFirewallCenLocalVpcArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.localVpc = mapped
    }

    /**
     * @param value The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
     */
    @JvmName("cgpikfcvsxhignmc")
    public suspend fun memberUid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberUid = mapped
    }

    /**
     * @param value Firewall switch status.
     */
    @JvmName("qsipqiektxcwsrnf")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The name of the VPC firewall instance.
     */
    @JvmName("pugjvkjkvsgjvmfd")
    public suspend fun vpcFirewallName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcFirewallName = mapped
    }

    /**
     * @param value The ID of the region to which the VPC is created.
     */
    @JvmName("iioeeurourngnhea")
    public suspend fun vpcRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcRegion = mapped
    }

    internal fun build(): FirewallVpcFirewallCenArgs = FirewallVpcFirewallCenArgs(
        cenId = cenId,
        lang = lang,
        localVpc = localVpc,
        memberUid = memberUid,
        status = status,
        vpcFirewallName = vpcFirewallName,
        vpcRegion = vpcRegion,
    )
}
