@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [FirewallVpcFirewallControlPolicy].
 */
@PulumiTagMarker
public class FirewallVpcFirewallControlPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallVpcFirewallControlPolicyArgs = FirewallVpcFirewallControlPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallVpcFirewallControlPolicyArgsBuilder.() -> Unit) {
        val builder = FirewallVpcFirewallControlPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FirewallVpcFirewallControlPolicy {
        val builtJavaResource =
            com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallControlPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FirewallVpcFirewallControlPolicy(builtJavaResource)
    }
}

/**
 * Provides a Cloud Firewall Vpc Firewall Control Policy resource.
 * For information about Cloud Firewall Vpc Firewall Control Policy and how to use it, see [What is Vpc Firewall Control Policy](https://www.alibabacloud.com/help/en/cloud-firewall/latest/createvpcfirewallcontrolpolicy).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.getAccount({});
 * const defaultInstance = new alicloud.cen.Instance("default", {
 *     cenInstanceName: name,
 *     description: "example_value",
 *     tags: {
 *         Created: "TF",
 *         For: "acceptance test",
 *     },
 * });
 * const defaultFirewallVpcFirewallControlPolicy = new alicloud.cloudfirewall.FirewallVpcFirewallControlPolicy("default", {
 *     order: 1,
 *     destination: "127.0.0.2/32",
 *     applicationName: "ANY",
 *     description: "example_value",
 *     sourceType: "net",
 *     destPort: "80/88",
 *     aclAction: "accept",
 *     lang: "zh",
 *     destinationType: "net",
 *     source: "127.0.0.1/32",
 *     destPortType: "port",
 *     proto: "TCP",
 *     release: true,
 *     memberUid: _default.then(_default => _default.id),
 *     vpcFirewallId: defaultInstance.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.get_account()
 * default_instance = alicloud.cen.Instance("default",
 *     cen_instance_name=name,
 *     description="example_value",
 *     tags={
 *         "Created": "TF",
 *         "For": "acceptance test",
 *     })
 * default_firewall_vpc_firewall_control_policy = alicloud.cloudfirewall.FirewallVpcFirewallControlPolicy("default",
 *     order=1,
 *     destination="127.0.0.2/32",
 *     application_name="ANY",
 *     description="example_value",
 *     source_type="net",
 *     dest_port="80/88",
 *     acl_action="accept",
 *     lang="zh",
 *     destination_type="net",
 *     source="127.0.0.1/32",
 *     dest_port_type="port",
 *     proto="TCP",
 *     release=True,
 *     member_uid=default.id,
 *     vpc_firewall_id=default_instance.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.GetAccount.Invoke();
 *     var defaultInstance = new AliCloud.Cen.Instance("default", new()
 *     {
 *         CenInstanceName = name,
 *         Description = "example_value",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "acceptance test" },
 *         },
 *     });
 *     var defaultFirewallVpcFirewallControlPolicy = new AliCloud.CloudFirewall.FirewallVpcFirewallControlPolicy("default", new()
 *     {
 *         Order = 1,
 *         Destination = "127.0.0.2/32",
 *         ApplicationName = "ANY",
 *         Description = "example_value",
 *         SourceType = "net",
 *         DestPort = "80/88",
 *         AclAction = "accept",
 *         Lang = "zh",
 *         DestinationType = "net",
 *         Source = "127.0.0.1/32",
 *         DestPortType = "port",
 *         Proto = "TCP",
 *         Release = true,
 *         MemberUid = @default.Apply(@default => @default.Apply(getAccountResult => getAccountResult.Id)),
 *         VpcFirewallId = defaultInstance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := cen.NewInstance(ctx, "default", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String(name),
 * 			Description:     pulumi.String("example_value"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("acceptance test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudfirewall.NewFirewallVpcFirewallControlPolicy(ctx, "default", &cloudfirewall.FirewallVpcFirewallControlPolicyArgs{
 * 			Order:           pulumi.Int(1),
 * 			Destination:     pulumi.String("127.0.0.2/32"),
 * 			ApplicationName: pulumi.String("ANY"),
 * 			Description:     pulumi.String("example_value"),
 * 			SourceType:      pulumi.String("net"),
 * 			DestPort:        pulumi.String("80/88"),
 * 			AclAction:       pulumi.String("accept"),
 * 			Lang:            pulumi.String("zh"),
 * 			DestinationType: pulumi.String("net"),
 * 			Source:          pulumi.String("127.0.0.1/32"),
 * 			DestPortType:    pulumi.String("port"),
 * 			Proto:           pulumi.String("TCP"),
 * 			Release:         pulumi.Bool(true),
 * 			MemberUid:       pulumi.String(_default.Id),
 * 			VpcFirewallId:   defaultInstance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallControlPolicy;
 * import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallControlPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AlicloudFunctions.getAccount();
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .cenInstanceName(name)
 *             .description("example_value")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "acceptance test")
 *             ))
 *             .build());
 *         var defaultFirewallVpcFirewallControlPolicy = new FirewallVpcFirewallControlPolicy("defaultFirewallVpcFirewallControlPolicy", FirewallVpcFirewallControlPolicyArgs.builder()
 *             .order("1")
 *             .destination("127.0.0.2/32")
 *             .applicationName("ANY")
 *             .description("example_value")
 *             .sourceType("net")
 *             .destPort("80/88")
 *             .aclAction("accept")
 *             .lang("zh")
 *             .destinationType("net")
 *             .source("127.0.0.1/32")
 *             .destPortType("port")
 *             .proto("TCP")
 *             .release(true)
 *             .memberUid(default_.id())
 *             .vpcFirewallId(defaultInstance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInstance:
 *     type: alicloud:cen:Instance
 *     name: default
 *     properties:
 *       cenInstanceName: ${name}
 *       description: example_value
 *       tags:
 *         Created: TF
 *         For: acceptance test
 *   defaultFirewallVpcFirewallControlPolicy:
 *     type: alicloud:cloudfirewall:FirewallVpcFirewallControlPolicy
 *     name: default
 *     properties:
 *       order: '1'
 *       destination: 127.0.0.2/32
 *       applicationName: ANY
 *       description: example_value
 *       sourceType: net
 *       destPort: 80/88
 *       aclAction: accept
 *       lang: zh
 *       destinationType: net
 *       source: 127.0.0.1/32
 *       destPortType: port
 *       proto: TCP
 *       release: true
 *       memberUid: ${default.id}
 *       vpcFirewallId: ${defaultInstance.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Firewall Vpc Firewall Control Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/firewallVpcFirewallControlPolicy:FirewallVpcFirewallControlPolicy example <vpc_firewall_id>:<acl_uuid>
 * ```
 */
public class FirewallVpcFirewallControlPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallControlPolicy,
) : KotlinCustomResource(javaResource, FirewallVpcFirewallControlPolicyMapper) {
    /**
     * The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
     */
    public val aclAction: Output<String>
        get() = javaResource.aclAction().applyValue({ args0 -> args0 })

    /**
     * Access control over VPC firewalls strategy unique identifier.
     */
    public val aclUuid: Output<String>
        get() = javaResource.aclUuid().applyValue({ args0 -> args0 })

    /**
     * Policy specifies the application ID.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * The type of the applications that the access control policy supports. Valid values: `FTP`, `HTTP`, `HTTPS`, `MySQL`, `SMTP`, `SMTPS`, `RDP`, `VNC`, `SSH`, `Redis`, `MQTT`, `MongoDB`, `Memcache`, `SSL`, `ANY`.
     */
    public val applicationName: Output<String>
        get() = javaResource.applicationName().applyValue({ args0 -> args0 })

    /**
     * Access control over VPC firewalls description of the strategy information.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify this parameter.
     */
    public val destPort: Output<String>
        get() = javaResource.destPort().applyValue({ args0 -> args0 })

    /**
     * Access control policy in the access traffic of the destination port address book name. **Note:** If `dest_port_type` is set to `group`, you must specify this parameter.
     */
    public val destPortGroup: Output<String>?
        get() = javaResource.destPortGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Port Address Book port list.
     */
    public val destPortGroupPorts: Output<List<String>>
        get() = javaResource.destPortGroupPorts().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The type of the destination port in the access control policy. Valid values: `port`, `group`.
     */
    public val destPortType: Output<String>
        get() = javaResource.destPortType().applyValue({ args0 -> args0 })

    /**
     * The destination address in the access control policy. Valid values:
     * - If `destination_type` is set to `net`, the value of `destination` must be a CIDR block.
     * - If `destination_type` is set to `group`, the value of `destination` must be an address book.
     * - If `destination_type` is set to `domain`, the value of `destination` must be a domain name.
     */
    public val destination: Output<String>
        get() = javaResource.destination().applyValue({ args0 -> args0 })

    /**
     * Destination address book defined in the address list.
     */
    public val destinationGroupCidrs: Output<List<String>>
        get() = javaResource.destinationGroupCidrs().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The destination address book type in the access control policy.
     */
    public val destinationGroupType: Output<String>
        get() = javaResource.destinationGroupType().applyValue({ args0 -> args0 })

    /**
     * The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`.
     */
    public val destinationType: Output<String>
        get() = javaResource.destinationType().applyValue({ args0 -> args0 })

    /**
     * Control strategy of hits per second.
     */
    public val hitTimes: Output<Int>
        get() = javaResource.hitTimes().applyValue({ args0 -> args0 })

    /**
     * The language of the content within the request and response. Valid values: `zh`, `en`.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The UID of the member account of the current Alibaba cloud account.
     */
    public val memberUid: Output<String>
        get() = javaResource.memberUid().applyValue({ args0 -> args0 })

    /**
     * The priority of the access control policy. The priority value starts from 1. A smaller priority value indicates a higher priority.
     */
    public val order: Output<Int>
        get() = javaResource.order().applyValue({ args0 -> args0 })

    /**
     * The type of the protocol in the access control policy. Valid values: `ANY`, `TCP`, `UDP`, `ICMP`.
     */
    public val proto: Output<String>
        get() = javaResource.proto().applyValue({ args0 -> args0 })

    /**
     * The enabled status of the access control policy. The policy is enabled by default after it is created.. Valid values:
     */
    public val release: Output<Boolean>
        get() = javaResource.release().applyValue({ args0 -> args0 })

    /**
     * Access control over VPC firewalls strategy in the source address.
     */
    public val source: Output<String>
        get() = javaResource.source().applyValue({ args0 -> args0 })

    /**
     * SOURCE address of the address list.
     */
    public val sourceGroupCidrs: Output<List<String>>
        get() = javaResource.sourceGroupCidrs().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The source address type in the access control policy.
     */
    public val sourceGroupType: Output<String>
        get() = javaResource.sourceGroupType().applyValue({ args0 -> args0 })

    /**
     * The type of the source address in the access control policy. Valid values: `net`, `group`.
     */
    public val sourceType: Output<String>
        get() = javaResource.sourceType().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC firewall instance. Valid values:
     * - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
     * - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
     */
    public val vpcFirewallId: Output<String>
        get() = javaResource.vpcFirewallId().applyValue({ args0 -> args0 })
}

public object FirewallVpcFirewallControlPolicyMapper :
    ResourceMapper<FirewallVpcFirewallControlPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallControlPolicy::class == javaResource::class

    override fun map(javaResource: Resource): FirewallVpcFirewallControlPolicy =
        FirewallVpcFirewallControlPolicy(
            javaResource as
                com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallControlPolicy,
        )
}

/**
 * @see [FirewallVpcFirewallControlPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirewallVpcFirewallControlPolicy].
 */
public suspend fun firewallVpcFirewallControlPolicy(
    name: String,
    block: suspend FirewallVpcFirewallControlPolicyResourceBuilder.() -> Unit,
): FirewallVpcFirewallControlPolicy {
    val builder = FirewallVpcFirewallControlPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirewallVpcFirewallControlPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewallVpcFirewallControlPolicy(name: String): FirewallVpcFirewallControlPolicy {
    val builder = FirewallVpcFirewallControlPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
