@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallControlPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Firewall Vpc Firewall Control Policy resource.
 * For information about Cloud Firewall Vpc Firewall Control Policy and how to use it, see [What is Vpc Firewall Control Policy](https://www.alibabacloud.com/help/en/cloud-firewall/latest/createvpcfirewallcontrolpolicy).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.getAccount({});
 * const defaultInstance = new alicloud.cen.Instance("default", {
 *     cenInstanceName: name,
 *     description: "example_value",
 *     tags: {
 *         Created: "TF",
 *         For: "acceptance test",
 *     },
 * });
 * const defaultFirewallVpcFirewallControlPolicy = new alicloud.cloudfirewall.FirewallVpcFirewallControlPolicy("default", {
 *     order: 1,
 *     destination: "127.0.0.2/32",
 *     applicationName: "ANY",
 *     description: "example_value",
 *     sourceType: "net",
 *     destPort: "80/88",
 *     aclAction: "accept",
 *     lang: "zh",
 *     destinationType: "net",
 *     source: "127.0.0.1/32",
 *     destPortType: "port",
 *     proto: "TCP",
 *     release: true,
 *     memberUid: _default.then(_default => _default.id),
 *     vpcFirewallId: defaultInstance.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.get_account()
 * default_instance = alicloud.cen.Instance("default",
 *     cen_instance_name=name,
 *     description="example_value",
 *     tags={
 *         "Created": "TF",
 *         "For": "acceptance test",
 *     })
 * default_firewall_vpc_firewall_control_policy = alicloud.cloudfirewall.FirewallVpcFirewallControlPolicy("default",
 *     order=1,
 *     destination="127.0.0.2/32",
 *     application_name="ANY",
 *     description="example_value",
 *     source_type="net",
 *     dest_port="80/88",
 *     acl_action="accept",
 *     lang="zh",
 *     destination_type="net",
 *     source="127.0.0.1/32",
 *     dest_port_type="port",
 *     proto="TCP",
 *     release=True,
 *     member_uid=default.id,
 *     vpc_firewall_id=default_instance.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.GetAccount.Invoke();
 *     var defaultInstance = new AliCloud.Cen.Instance("default", new()
 *     {
 *         CenInstanceName = name,
 *         Description = "example_value",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "acceptance test" },
 *         },
 *     });
 *     var defaultFirewallVpcFirewallControlPolicy = new AliCloud.CloudFirewall.FirewallVpcFirewallControlPolicy("default", new()
 *     {
 *         Order = 1,
 *         Destination = "127.0.0.2/32",
 *         ApplicationName = "ANY",
 *         Description = "example_value",
 *         SourceType = "net",
 *         DestPort = "80/88",
 *         AclAction = "accept",
 *         Lang = "zh",
 *         DestinationType = "net",
 *         Source = "127.0.0.1/32",
 *         DestPortType = "port",
 *         Proto = "TCP",
 *         Release = true,
 *         MemberUid = @default.Apply(@default => @default.Apply(getAccountResult => getAccountResult.Id)),
 *         VpcFirewallId = defaultInstance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := cen.NewInstance(ctx, "default", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String(name),
 * 			Description:     pulumi.String("example_value"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("acceptance test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudfirewall.NewFirewallVpcFirewallControlPolicy(ctx, "default", &cloudfirewall.FirewallVpcFirewallControlPolicyArgs{
 * 			Order:           pulumi.Int(1),
 * 			Destination:     pulumi.String("127.0.0.2/32"),
 * 			ApplicationName: pulumi.String("ANY"),
 * 			Description:     pulumi.String("example_value"),
 * 			SourceType:      pulumi.String("net"),
 * 			DestPort:        pulumi.String("80/88"),
 * 			AclAction:       pulumi.String("accept"),
 * 			Lang:            pulumi.String("zh"),
 * 			DestinationType: pulumi.String("net"),
 * 			Source:          pulumi.String("127.0.0.1/32"),
 * 			DestPortType:    pulumi.String("port"),
 * 			Proto:           pulumi.String("TCP"),
 * 			Release:         pulumi.Bool(true),
 * 			MemberUid:       pulumi.String(_default.Id),
 * 			VpcFirewallId:   defaultInstance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallControlPolicy;
 * import com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallControlPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AlicloudFunctions.getAccount();
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .cenInstanceName(name)
 *             .description("example_value")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "acceptance test")
 *             ))
 *             .build());
 *         var defaultFirewallVpcFirewallControlPolicy = new FirewallVpcFirewallControlPolicy("defaultFirewallVpcFirewallControlPolicy", FirewallVpcFirewallControlPolicyArgs.builder()
 *             .order("1")
 *             .destination("127.0.0.2/32")
 *             .applicationName("ANY")
 *             .description("example_value")
 *             .sourceType("net")
 *             .destPort("80/88")
 *             .aclAction("accept")
 *             .lang("zh")
 *             .destinationType("net")
 *             .source("127.0.0.1/32")
 *             .destPortType("port")
 *             .proto("TCP")
 *             .release(true)
 *             .memberUid(default_.id())
 *             .vpcFirewallId(defaultInstance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInstance:
 *     type: alicloud:cen:Instance
 *     name: default
 *     properties:
 *       cenInstanceName: ${name}
 *       description: example_value
 *       tags:
 *         Created: TF
 *         For: acceptance test
 *   defaultFirewallVpcFirewallControlPolicy:
 *     type: alicloud:cloudfirewall:FirewallVpcFirewallControlPolicy
 *     name: default
 *     properties:
 *       order: '1'
 *       destination: 127.0.0.2/32
 *       applicationName: ANY
 *       description: example_value
 *       sourceType: net
 *       destPort: 80/88
 *       aclAction: accept
 *       lang: zh
 *       destinationType: net
 *       source: 127.0.0.1/32
 *       destPortType: port
 *       proto: TCP
 *       release: true
 *       memberUid: ${default.id}
 *       vpcFirewallId: ${defaultInstance.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Firewall Vpc Firewall Control Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/firewallVpcFirewallControlPolicy:FirewallVpcFirewallControlPolicy example <vpc_firewall_id>:<acl_uuid>
 * ```
 * @property aclAction The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
 * @property applicationName The type of the applications that the access control policy supports. Valid values: `FTP`, `HTTP`, `HTTPS`, `MySQL`, `SMTP`, `SMTPS`, `RDP`, `VNC`, `SSH`, `Redis`, `MQTT`, `MongoDB`, `Memcache`, `SSL`, `ANY`.
 * @property description Access control over VPC firewalls description of the strategy information.
 * @property destPort The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify this parameter.
 * @property destPortGroup Access control policy in the access traffic of the destination port address book name. **Note:** If `dest_port_type` is set to `group`, you must specify this parameter.
 * @property destPortType The type of the destination port in the access control policy. Valid values: `port`, `group`.
 * @property destination The destination address in the access control policy. Valid values:
 * - If `destination_type` is set to `net`, the value of `destination` must be a CIDR block.
 * - If `destination_type` is set to `group`, the value of `destination` must be an address book.
 * - If `destination_type` is set to `domain`, the value of `destination` must be a domain name.
 * @property destinationType The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`.
 * @property lang The language of the content within the request and response. Valid values: `zh`, `en`.
 * @property memberUid The UID of the member account of the current Alibaba cloud account.
 * @property order The priority of the access control policy. The priority value starts from 1. A smaller priority value indicates a higher priority.
 * @property proto The type of the protocol in the access control policy. Valid values: `ANY`, `TCP`, `UDP`, `ICMP`.
 * @property release The enabled status of the access control policy. The policy is enabled by default after it is created.. Valid values:
 * @property source Access control over VPC firewalls strategy in the source address.
 * @property sourceType The type of the source address in the access control policy. Valid values: `net`, `group`.
 * @property vpcFirewallId The ID of the VPC firewall instance. Valid values:
 * - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
 * - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
 */
public data class FirewallVpcFirewallControlPolicyArgs(
    public val aclAction: Output<String>? = null,
    public val applicationName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val destPort: Output<String>? = null,
    public val destPortGroup: Output<String>? = null,
    public val destPortType: Output<String>? = null,
    public val destination: Output<String>? = null,
    public val destinationType: Output<String>? = null,
    public val lang: Output<String>? = null,
    public val memberUid: Output<String>? = null,
    public val order: Output<Int>? = null,
    public val proto: Output<String>? = null,
    public val release: Output<Boolean>? = null,
    public val source: Output<String>? = null,
    public val sourceType: Output<String>? = null,
    public val vpcFirewallId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallControlPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallControlPolicyArgs =
        com.pulumi.alicloud.cloudfirewall.FirewallVpcFirewallControlPolicyArgs.builder()
            .aclAction(aclAction?.applyValue({ args0 -> args0 }))
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .destPort(destPort?.applyValue({ args0 -> args0 }))
            .destPortGroup(destPortGroup?.applyValue({ args0 -> args0 }))
            .destPortType(destPortType?.applyValue({ args0 -> args0 }))
            .destination(destination?.applyValue({ args0 -> args0 }))
            .destinationType(destinationType?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 }))
            .memberUid(memberUid?.applyValue({ args0 -> args0 }))
            .order(order?.applyValue({ args0 -> args0 }))
            .proto(proto?.applyValue({ args0 -> args0 }))
            .release(release?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .sourceType(sourceType?.applyValue({ args0 -> args0 }))
            .vpcFirewallId(vpcFirewallId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallVpcFirewallControlPolicyArgs].
 */
@PulumiTagMarker
public class FirewallVpcFirewallControlPolicyArgsBuilder internal constructor() {
    private var aclAction: Output<String>? = null

    private var applicationName: Output<String>? = null

    private var description: Output<String>? = null

    private var destPort: Output<String>? = null

    private var destPortGroup: Output<String>? = null

    private var destPortType: Output<String>? = null

    private var destination: Output<String>? = null

    private var destinationType: Output<String>? = null

    private var lang: Output<String>? = null

    private var memberUid: Output<String>? = null

    private var order: Output<Int>? = null

    private var proto: Output<String>? = null

    private var release: Output<Boolean>? = null

    private var source: Output<String>? = null

    private var sourceType: Output<String>? = null

    private var vpcFirewallId: Output<String>? = null

    /**
     * @param value The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
     */
    @JvmName("meixptnfmnljhhgj")
    public suspend fun aclAction(`value`: Output<String>) {
        this.aclAction = value
    }

    /**
     * @param value The type of the applications that the access control policy supports. Valid values: `FTP`, `HTTP`, `HTTPS`, `MySQL`, `SMTP`, `SMTPS`, `RDP`, `VNC`, `SSH`, `Redis`, `MQTT`, `MongoDB`, `Memcache`, `SSL`, `ANY`.
     */
    @JvmName("inkibjfwldvjovuc")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value Access control over VPC firewalls description of the strategy information.
     */
    @JvmName("obfxfbbdehpyurbl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify this parameter.
     */
    @JvmName("lvwlmuvrqlmfbxyf")
    public suspend fun destPort(`value`: Output<String>) {
        this.destPort = value
    }

    /**
     * @param value Access control policy in the access traffic of the destination port address book name. **Note:** If `dest_port_type` is set to `group`, you must specify this parameter.
     */
    @JvmName("nmsyuigjqahdqrdg")
    public suspend fun destPortGroup(`value`: Output<String>) {
        this.destPortGroup = value
    }

    /**
     * @param value The type of the destination port in the access control policy. Valid values: `port`, `group`.
     */
    @JvmName("lfpbsqqdhscnwdpp")
    public suspend fun destPortType(`value`: Output<String>) {
        this.destPortType = value
    }

    /**
     * @param value The destination address in the access control policy. Valid values:
     * - If `destination_type` is set to `net`, the value of `destination` must be a CIDR block.
     * - If `destination_type` is set to `group`, the value of `destination` must be an address book.
     * - If `destination_type` is set to `domain`, the value of `destination` must be a domain name.
     */
    @JvmName("qknhdgypohpsteal")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`.
     */
    @JvmName("bplkmdtmfcqwvrhl")
    public suspend fun destinationType(`value`: Output<String>) {
        this.destinationType = value
    }

    /**
     * @param value The language of the content within the request and response. Valid values: `zh`, `en`.
     */
    @JvmName("cemttjuesqehwodi")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The UID of the member account of the current Alibaba cloud account.
     */
    @JvmName("bsvcwftwcdqaokve")
    public suspend fun memberUid(`value`: Output<String>) {
        this.memberUid = value
    }

    /**
     * @param value The priority of the access control policy. The priority value starts from 1. A smaller priority value indicates a higher priority.
     */
    @JvmName("tbpcoosqeankcetk")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value The type of the protocol in the access control policy. Valid values: `ANY`, `TCP`, `UDP`, `ICMP`.
     */
    @JvmName("qfbtfjlxnyrtnync")
    public suspend fun proto(`value`: Output<String>) {
        this.proto = value
    }

    /**
     * @param value The enabled status of the access control policy. The policy is enabled by default after it is created.. Valid values:
     */
    @JvmName("thxnurdtnpnrhevb")
    public suspend fun release(`value`: Output<Boolean>) {
        this.release = value
    }

    /**
     * @param value Access control over VPC firewalls strategy in the source address.
     */
    @JvmName("aqfmhvmicwhdvhwu")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The type of the source address in the access control policy. Valid values: `net`, `group`.
     */
    @JvmName("mblegffhmmeancdc")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value The ID of the VPC firewall instance. Valid values:
     * - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
     * - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
     */
    @JvmName("tuegqetnjechkxcx")
    public suspend fun vpcFirewallId(`value`: Output<String>) {
        this.vpcFirewallId = value
    }

    /**
     * @param value The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
     */
    @JvmName("pdogrlwaihbujmoq")
    public suspend fun aclAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclAction = mapped
    }

    /**
     * @param value The type of the applications that the access control policy supports. Valid values: `FTP`, `HTTP`, `HTTPS`, `MySQL`, `SMTP`, `SMTPS`, `RDP`, `VNC`, `SSH`, `Redis`, `MQTT`, `MongoDB`, `Memcache`, `SSL`, `ANY`.
     */
    @JvmName("oftugpabjkupbrdd")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value Access control over VPC firewalls description of the strategy information.
     */
    @JvmName("esrhonhcdoiowvsd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify this parameter.
     */
    @JvmName("yuylpdoymhfyqqfn")
    public suspend fun destPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destPort = mapped
    }

    /**
     * @param value Access control policy in the access traffic of the destination port address book name. **Note:** If `dest_port_type` is set to `group`, you must specify this parameter.
     */
    @JvmName("olcgybuhmayxsrwp")
    public suspend fun destPortGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destPortGroup = mapped
    }

    /**
     * @param value The type of the destination port in the access control policy. Valid values: `port`, `group`.
     */
    @JvmName("qbranhpwpfkfmesf")
    public suspend fun destPortType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destPortType = mapped
    }

    /**
     * @param value The destination address in the access control policy. Valid values:
     * - If `destination_type` is set to `net`, the value of `destination` must be a CIDR block.
     * - If `destination_type` is set to `group`, the value of `destination` must be an address book.
     * - If `destination_type` is set to `domain`, the value of `destination` must be a domain name.
     */
    @JvmName("tnbyspnquwajadkx")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`.
     */
    @JvmName("nlmtudwrajyxbjub")
    public suspend fun destinationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    /**
     * @param value The language of the content within the request and response. Valid values: `zh`, `en`.
     */
    @JvmName("xukrtmamierhsqec")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The UID of the member account of the current Alibaba cloud account.
     */
    @JvmName("aiejhwcxindriyut")
    public suspend fun memberUid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberUid = mapped
    }

    /**
     * @param value The priority of the access control policy. The priority value starts from 1. A smaller priority value indicates a higher priority.
     */
    @JvmName("bkwacyosqqydvypw")
    public suspend fun order(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value The type of the protocol in the access control policy. Valid values: `ANY`, `TCP`, `UDP`, `ICMP`.
     */
    @JvmName("qloilohbulqopxwg")
    public suspend fun proto(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proto = mapped
    }

    /**
     * @param value The enabled status of the access control policy. The policy is enabled by default after it is created.. Valid values:
     */
    @JvmName("pqhrlgolcyxmswby")
    public suspend fun release(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.release = mapped
    }

    /**
     * @param value Access control over VPC firewalls strategy in the source address.
     */
    @JvmName("odsswenlxvutqbmg")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The type of the source address in the access control policy. Valid values: `net`, `group`.
     */
    @JvmName("gtptiskxpqwqchhw")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value The ID of the VPC firewall instance. Valid values:
     * - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
     * - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
     */
    @JvmName("qxngyhsgxhkimgor")
    public suspend fun vpcFirewallId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcFirewallId = mapped
    }

    internal fun build(): FirewallVpcFirewallControlPolicyArgs = FirewallVpcFirewallControlPolicyArgs(
        aclAction = aclAction,
        applicationName = applicationName,
        description = description,
        destPort = destPort,
        destPortGroup = destPortGroup,
        destPortType = destPortType,
        destination = destination,
        destinationType = destinationType,
        lang = lang,
        memberUid = memberUid,
        order = order,
        proto = proto,
        release = release,
        source = source,
        sourceType = sourceType,
        vpcFirewallId = vpcFirewallId,
    )
}
