@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.cloudfirewall.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides a Cloud Firewall Instance resource.
 * For information about Cloud Firewall Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/product/90174.htm).
 * > **NOTE:** Available since v1.139.0.
 * ## Example Usage
 * Basic Usage
 * create a pay-as-you-go instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const payAsYouGo = new alicloud.cloudfirewall.Instance("PayAsYouGo", {paymentType: "PayAsYouGo"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * pay_as_you_go = alicloud.cloudfirewall.Instance("PayAsYouGo", payment_type="PayAsYouGo")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var payAsYouGo = new AliCloud.CloudFirewall.Instance("PayAsYouGo", new()
 *     {
 *         PaymentType = "PayAsYouGo",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfirewall.NewInstance(ctx, "PayAsYouGo", &cloudfirewall.InstanceArgs{
 * 			PaymentType: pulumi.String("PayAsYouGo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudfirewall.Instance;
 * import com.pulumi.alicloud.cloudfirewall.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var payAsYouGo = new Instance("payAsYouGo", InstanceArgs.builder()
 *             .paymentType("PayAsYouGo")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   payAsYouGo:
 *     type: alicloud:cloudfirewall:Instance
 *     name: PayAsYouGo
 *     properties:
 *       paymentType: PayAsYouGo
 * ```
 * <!--End PulumiCodeChooser -->
 * create a subscription instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const subscription = new alicloud.cloudfirewall.Instance("Subscription", {
 *     paymentType: "Subscription",
 *     spec: "premium_version",
 *     ipNumber: 20,
 *     bandWidth: 10,
 *     cfwLog: false,
 *     period: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * subscription = alicloud.cloudfirewall.Instance("Subscription",
 *     payment_type="Subscription",
 *     spec="premium_version",
 *     ip_number=20,
 *     band_width=10,
 *     cfw_log=False,
 *     period=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subscription = new AliCloud.CloudFirewall.Instance("Subscription", new()
 *     {
 *         PaymentType = "Subscription",
 *         Spec = "premium_version",
 *         IpNumber = 20,
 *         BandWidth = 10,
 *         CfwLog = false,
 *         Period = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfirewall.NewInstance(ctx, "Subscription", &cloudfirewall.InstanceArgs{
 * 			PaymentType: pulumi.String("Subscription"),
 * 			Spec:        pulumi.String("premium_version"),
 * 			IpNumber:    pulumi.Int(20),
 * 			BandWidth:   pulumi.Int(10),
 * 			CfwLog:      pulumi.Bool(false),
 * 			Period:      pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudfirewall.Instance;
 * import com.pulumi.alicloud.cloudfirewall.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subscription = new Instance("subscription", InstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .spec("premium_version")
 *             .ipNumber(20)
 *             .bandWidth(10)
 *             .cfwLog(false)
 *             .period(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   subscription:
 *     type: alicloud:cloudfirewall:Instance
 *     name: Subscription
 *     properties:
 *       paymentType: Subscription
 *       spec: premium_version
 *       ipNumber: 20
 *       bandWidth: 10
 *       cfwLog: false
 *       period: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Firewall Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/instance:Instance example <id>
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudfirewall.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * The number of multi account. It will be ignored when `cfw_account = false`.
     */
    public val accountNumber: Output<Int>?
        get() = javaResource.accountNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
     */
    public val bandWidth: Output<Int>?
        get() = javaResource.bandWidth().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to use multi-account. Valid values: `true`, `false`.
     */
    public val cfwAccount: Output<Boolean>?
        get() = javaResource.cfwAccount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to use log audit. Valid values: `true`, `false`.
     */
    public val cfwLog: Output<Boolean>?
        get() = javaResource.cfwLog().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The log storage capacity. It will be ignored when `cfw_log = false`.
     */
    public val cfwLogStorage: Output<Int>?
        get() = javaResource.cfwLogStorage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The end time.
     */
    public val endTime: Output<String>
        get() = javaResource.endTime().applyValue({ args0 -> args0 })

    /**
     * The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
     */
    public val fwVpcNumber: Output<Int>?
        get() = javaResource.fwVpcNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of assets.
     */
    public val instanceCount: Output<Int>?
        get() = javaResource.instanceCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of public IPs that can be protected. Valid values: 20 to 4000.
     */
    public val ipNumber: Output<Int>?
        get() = javaResource.ipNumber().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The logistics.
     */
    public val logistics: Output<String>?
        get() = javaResource.logistics().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of modification. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute an update operation.
     */
    public val modifyType: Output<String>?
        get() = javaResource.modifyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`. **NOTE:** From version 1.220.0, `payment_type` can be set to `PayAsYouGo`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available since 1.204.1. If `payment_type` is set to `Subscription`, `period` is required. Otherwise, it will be ignored.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The release time.
     */
    public val releaseTime: Output<String>
        get() = javaResource.releaseTime().applyValue({ args0 -> args0 })

    /**
     * Automatic renewal period. Attribute `renew_period` has been deprecated since 1.209.1. Using `renewal_duration` instead.
     */
    @Deprecated(
        message = """
  Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.
  """,
    )
    public val renewPeriod: Output<Int>
        get() = javaResource.renewPeriod().applyValue({ args0 -> args0 })

    /**
     * Auto-Renewal Duration. It is required under the condition that `renewal_status` is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
     * **NOTE:** `renewal_duration` takes effect only if `payment_type` is set to `Subscription`, and `renewal_status` is set to `AutoRenewal`.
     */
    public val renewalDuration: Output<Int>
        get() = javaResource.renewalDuration().applyValue({ args0 -> args0 })

    /**
     * Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
     */
    public val renewalDurationUnit: Output<String>?
        get() = javaResource.renewalDurationUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to renew an instance automatically or not. Default to "ManualRenewal".
     * - `AutoRenewal`: Auto renewal.
     * - `ManualRenewal`: Manual renewal.
     * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
     * **NOTE:** `renewal_status` takes effect only if `payment_type` is set to `Subscription`.
     */
    public val renewalStatus: Output<String>
        get() = javaResource.renewalStatus().applyValue({ args0 -> args0 })

    /**
     * Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
     */
    public val spec: Output<String>?
        get() = javaResource.spec().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of Instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudfirewall.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.cloudfirewall.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
