@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.alicloud.cloudfirewall.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Firewall Instance resource.
 * For information about Cloud Firewall Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/product/90174.htm).
 * > **NOTE:** Available since v1.139.0.
 * ## Example Usage
 * Basic Usage
 * create a pay-as-you-go instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const payAsYouGo = new alicloud.cloudfirewall.Instance("PayAsYouGo", {paymentType: "PayAsYouGo"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * pay_as_you_go = alicloud.cloudfirewall.Instance("PayAsYouGo", payment_type="PayAsYouGo")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var payAsYouGo = new AliCloud.CloudFirewall.Instance("PayAsYouGo", new()
 *     {
 *         PaymentType = "PayAsYouGo",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfirewall.NewInstance(ctx, "PayAsYouGo", &cloudfirewall.InstanceArgs{
 * 			PaymentType: pulumi.String("PayAsYouGo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudfirewall.Instance;
 * import com.pulumi.alicloud.cloudfirewall.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var payAsYouGo = new Instance("payAsYouGo", InstanceArgs.builder()
 *             .paymentType("PayAsYouGo")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   payAsYouGo:
 *     type: alicloud:cloudfirewall:Instance
 *     name: PayAsYouGo
 *     properties:
 *       paymentType: PayAsYouGo
 * ```
 * <!--End PulumiCodeChooser -->
 * create a subscription instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const subscription = new alicloud.cloudfirewall.Instance("Subscription", {
 *     paymentType: "Subscription",
 *     spec: "premium_version",
 *     ipNumber: 20,
 *     bandWidth: 10,
 *     cfwLog: false,
 *     period: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * subscription = alicloud.cloudfirewall.Instance("Subscription",
 *     payment_type="Subscription",
 *     spec="premium_version",
 *     ip_number=20,
 *     band_width=10,
 *     cfw_log=False,
 *     period=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subscription = new AliCloud.CloudFirewall.Instance("Subscription", new()
 *     {
 *         PaymentType = "Subscription",
 *         Spec = "premium_version",
 *         IpNumber = 20,
 *         BandWidth = 10,
 *         CfwLog = false,
 *         Period = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfirewall.NewInstance(ctx, "Subscription", &cloudfirewall.InstanceArgs{
 * 			PaymentType: pulumi.String("Subscription"),
 * 			Spec:        pulumi.String("premium_version"),
 * 			IpNumber:    pulumi.Int(20),
 * 			BandWidth:   pulumi.Int(10),
 * 			CfwLog:      pulumi.Bool(false),
 * 			Period:      pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudfirewall.Instance;
 * import com.pulumi.alicloud.cloudfirewall.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subscription = new Instance("subscription", InstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .spec("premium_version")
 *             .ipNumber(20)
 *             .bandWidth(10)
 *             .cfwLog(false)
 *             .period(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   subscription:
 *     type: alicloud:cloudfirewall:Instance
 *     name: Subscription
 *     properties:
 *       paymentType: Subscription
 *       spec: premium_version
 *       ipNumber: 20
 *       bandWidth: 10
 *       cfwLog: false
 *       period: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Firewall Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/instance:Instance example <id>
 * ```
 * @property accountNumber The number of multi account. It will be ignored when `cfw_account = false`.
 * @property bandWidth Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
 * @property cfwAccount Whether to use multi-account. Valid values: `true`, `false`.
 * @property cfwLog Whether to use log audit. Valid values: `true`, `false`.
 * @property cfwLogStorage The log storage capacity. It will be ignored when `cfw_log = false`.
 * @property fwVpcNumber The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
 * @property instanceCount The number of assets.
 * @property ipNumber The number of public IPs that can be protected. Valid values: 20 to 4000.
 * @property logistics The logistics.
 * @property modifyType The type of modification. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute an update operation.
 * @property paymentType The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`. **NOTE:** From version 1.220.0, `payment_type` can be set to `PayAsYouGo`.
 * @property period The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available since 1.204.1. If `payment_type` is set to `Subscription`, `period` is required. Otherwise, it will be ignored.
 * @property renewPeriod Automatic renewal period. Attribute `renew_period` has been deprecated since 1.209.1. Using `renewal_duration` instead.
 * @property renewalDuration Auto-Renewal Duration. It is required under the condition that `renewal_status` is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
 * **NOTE:** `renewal_duration` takes effect only if `payment_type` is set to `Subscription`, and `renewal_status` is set to `AutoRenewal`.
 * @property renewalDurationUnit Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
 * @property renewalStatus Whether to renew an instance automatically or not. Default to "ManualRenewal".
 * - `AutoRenewal`: Auto renewal.
 * - `ManualRenewal`: Manual renewal.
 * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
 * **NOTE:** `renewal_status` takes effect only if `payment_type` is set to `Subscription`.
 * @property spec Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
 */
public data class InstanceArgs(
    public val accountNumber: Output<Int>? = null,
    public val bandWidth: Output<Int>? = null,
    public val cfwAccount: Output<Boolean>? = null,
    public val cfwLog: Output<Boolean>? = null,
    public val cfwLogStorage: Output<Int>? = null,
    public val fwVpcNumber: Output<Int>? = null,
    public val instanceCount: Output<Int>? = null,
    public val ipNumber: Output<Int>? = null,
    public val logistics: Output<String>? = null,
    public val modifyType: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    @Deprecated(
        message = """
  Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.
  """,
    )
    public val renewPeriod: Output<Int>? = null,
    public val renewalDuration: Output<Int>? = null,
    public val renewalDurationUnit: Output<String>? = null,
    public val renewalStatus: Output<String>? = null,
    public val spec: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.InstanceArgs =
        com.pulumi.alicloud.cloudfirewall.InstanceArgs.builder()
            .accountNumber(accountNumber?.applyValue({ args0 -> args0 }))
            .bandWidth(bandWidth?.applyValue({ args0 -> args0 }))
            .cfwAccount(cfwAccount?.applyValue({ args0 -> args0 }))
            .cfwLog(cfwLog?.applyValue({ args0 -> args0 }))
            .cfwLogStorage(cfwLogStorage?.applyValue({ args0 -> args0 }))
            .fwVpcNumber(fwVpcNumber?.applyValue({ args0 -> args0 }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .ipNumber(ipNumber?.applyValue({ args0 -> args0 }))
            .logistics(logistics?.applyValue({ args0 -> args0 }))
            .modifyType(modifyType?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .renewPeriod(renewPeriod?.applyValue({ args0 -> args0 }))
            .renewalDuration(renewalDuration?.applyValue({ args0 -> args0 }))
            .renewalDurationUnit(renewalDurationUnit?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .spec(spec?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var accountNumber: Output<Int>? = null

    private var bandWidth: Output<Int>? = null

    private var cfwAccount: Output<Boolean>? = null

    private var cfwLog: Output<Boolean>? = null

    private var cfwLogStorage: Output<Int>? = null

    private var fwVpcNumber: Output<Int>? = null

    private var instanceCount: Output<Int>? = null

    private var ipNumber: Output<Int>? = null

    private var logistics: Output<String>? = null

    private var modifyType: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var renewPeriod: Output<Int>? = null

    private var renewalDuration: Output<Int>? = null

    private var renewalDurationUnit: Output<String>? = null

    private var renewalStatus: Output<String>? = null

    private var spec: Output<String>? = null

    /**
     * @param value The number of multi account. It will be ignored when `cfw_account = false`.
     */
    @JvmName("almylmefqiltjnng")
    public suspend fun accountNumber(`value`: Output<Int>) {
        this.accountNumber = value
    }

    /**
     * @param value Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
     */
    @JvmName("okemmfxjscgcocvv")
    public suspend fun bandWidth(`value`: Output<Int>) {
        this.bandWidth = value
    }

    /**
     * @param value Whether to use multi-account. Valid values: `true`, `false`.
     */
    @JvmName("kbpahefaeevuxlgj")
    public suspend fun cfwAccount(`value`: Output<Boolean>) {
        this.cfwAccount = value
    }

    /**
     * @param value Whether to use log audit. Valid values: `true`, `false`.
     */
    @JvmName("rbnhjxuvuqwamaex")
    public suspend fun cfwLog(`value`: Output<Boolean>) {
        this.cfwLog = value
    }

    /**
     * @param value The log storage capacity. It will be ignored when `cfw_log = false`.
     */
    @JvmName("tllneddtceksrpxm")
    public suspend fun cfwLogStorage(`value`: Output<Int>) {
        this.cfwLogStorage = value
    }

    /**
     * @param value The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
     */
    @JvmName("hehnyfkvtxotbrll")
    public suspend fun fwVpcNumber(`value`: Output<Int>) {
        this.fwVpcNumber = value
    }

    /**
     * @param value The number of assets.
     */
    @JvmName("cmlfkjkbtxurjubn")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value The number of public IPs that can be protected. Valid values: 20 to 4000.
     */
    @JvmName("dfybvuadaneupxso")
    public suspend fun ipNumber(`value`: Output<Int>) {
        this.ipNumber = value
    }

    /**
     * @param value The logistics.
     */
    @JvmName("lkgkgbnyrtuyeacb")
    public suspend fun logistics(`value`: Output<String>) {
        this.logistics = value
    }

    /**
     * @param value The type of modification. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute an update operation.
     */
    @JvmName("juwsybdlmijvlgkv")
    public suspend fun modifyType(`value`: Output<String>) {
        this.modifyType = value
    }

    /**
     * @param value The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`. **NOTE:** From version 1.220.0, `payment_type` can be set to `PayAsYouGo`.
     */
    @JvmName("stycoruvifakrccp")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available since 1.204.1. If `payment_type` is set to `Subscription`, `period` is required. Otherwise, it will be ignored.
     */
    @JvmName("yqbknijtwlrqirbe")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Automatic renewal period. Attribute `renew_period` has been deprecated since 1.209.1. Using `renewal_duration` instead.
     */
    @Deprecated(
        message = """
  Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.
  """,
    )
    @JvmName("utrbjbdwikymwfpt")
    public suspend fun renewPeriod(`value`: Output<Int>) {
        this.renewPeriod = value
    }

    /**
     * @param value Auto-Renewal Duration. It is required under the condition that `renewal_status` is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
     * **NOTE:** `renewal_duration` takes effect only if `payment_type` is set to `Subscription`, and `renewal_status` is set to `AutoRenewal`.
     */
    @JvmName("psowyhplxdfsuaji")
    public suspend fun renewalDuration(`value`: Output<Int>) {
        this.renewalDuration = value
    }

    /**
     * @param value Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
     */
    @JvmName("fkigtqcpfycpnqhq")
    public suspend fun renewalDurationUnit(`value`: Output<String>) {
        this.renewalDurationUnit = value
    }

    /**
     * @param value Whether to renew an instance automatically or not. Default to "ManualRenewal".
     * - `AutoRenewal`: Auto renewal.
     * - `ManualRenewal`: Manual renewal.
     * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
     * **NOTE:** `renewal_status` takes effect only if `payment_type` is set to `Subscription`.
     */
    @JvmName("fxxphmcqvqoaijbm")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
     */
    @JvmName("dkartmmywisrnkea")
    public suspend fun spec(`value`: Output<String>) {
        this.spec = value
    }

    /**
     * @param value The number of multi account. It will be ignored when `cfw_account = false`.
     */
    @JvmName("cblunjtfgtslfopq")
    public suspend fun accountNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountNumber = mapped
    }

    /**
     * @param value Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
     */
    @JvmName("bxpdyleffplunved")
    public suspend fun bandWidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandWidth = mapped
    }

    /**
     * @param value Whether to use multi-account. Valid values: `true`, `false`.
     */
    @JvmName("ficlhlcovpjbuqax")
    public suspend fun cfwAccount(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cfwAccount = mapped
    }

    /**
     * @param value Whether to use log audit. Valid values: `true`, `false`.
     */
    @JvmName("imxitmvhmtwdteqy")
    public suspend fun cfwLog(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cfwLog = mapped
    }

    /**
     * @param value The log storage capacity. It will be ignored when `cfw_log = false`.
     */
    @JvmName("vdneeupqcjydyumt")
    public suspend fun cfwLogStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cfwLogStorage = mapped
    }

    /**
     * @param value The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
     */
    @JvmName("nhhgnonbfaqkvssu")
    public suspend fun fwVpcNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fwVpcNumber = mapped
    }

    /**
     * @param value The number of assets.
     */
    @JvmName("dwppbdhjbrvuorhu")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value The number of public IPs that can be protected. Valid values: 20 to 4000.
     */
    @JvmName("gtrselbdsmibrqep")
    public suspend fun ipNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipNumber = mapped
    }

    /**
     * @param value The logistics.
     */
    @JvmName("kdouhpxapuhtecac")
    public suspend fun logistics(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logistics = mapped
    }

    /**
     * @param value The type of modification. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute an update operation.
     */
    @JvmName("hansisjiuvbjlwws")
    public suspend fun modifyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifyType = mapped
    }

    /**
     * @param value The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`. **NOTE:** From version 1.220.0, `payment_type` can be set to `PayAsYouGo`.
     */
    @JvmName("smvvydhdgeyovngi")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available since 1.204.1. If `payment_type` is set to `Subscription`, `period` is required. Otherwise, it will be ignored.
     */
    @JvmName("nmexadticoofjhtp")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Automatic renewal period. Attribute `renew_period` has been deprecated since 1.209.1. Using `renewal_duration` instead.
     */
    @Deprecated(
        message = """
  Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.
  """,
    )
    @JvmName("wemlmxfgdnxilsqf")
    public suspend fun renewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewPeriod = mapped
    }

    /**
     * @param value Auto-Renewal Duration. It is required under the condition that `renewal_status` is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
     * **NOTE:** `renewal_duration` takes effect only if `payment_type` is set to `Subscription`, and `renewal_status` is set to `AutoRenewal`.
     */
    @JvmName("pmscivpkwuvojyos")
    public suspend fun renewalDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalDuration = mapped
    }

    /**
     * @param value Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
     */
    @JvmName("epvhfrmpaggqulnq")
    public suspend fun renewalDurationUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalDurationUnit = mapped
    }

    /**
     * @param value Whether to renew an instance automatically or not. Default to "ManualRenewal".
     * - `AutoRenewal`: Auto renewal.
     * - `ManualRenewal`: Manual renewal.
     * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
     * **NOTE:** `renewal_status` takes effect only if `payment_type` is set to `Subscription`.
     */
    @JvmName("jomfscvfmsxrjevy")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
     */
    @JvmName("hsllpbnlfbypenub")
    public suspend fun spec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        accountNumber = accountNumber,
        bandWidth = bandWidth,
        cfwAccount = cfwAccount,
        cfwLog = cfwLog,
        cfwLogStorage = cfwLogStorage,
        fwVpcNumber = fwVpcNumber,
        instanceCount = instanceCount,
        ipNumber = ipNumber,
        logistics = logistics,
        modifyType = modifyType,
        paymentType = paymentType,
        period = period,
        renewPeriod = renewPeriod,
        renewalDuration = renewalDuration,
        renewalDurationUnit = renewalDurationUnit,
        renewalStatus = renewalStatus,
        spec = spec,
    )
}
