@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InstanceMember].
 */
@PulumiTagMarker
public class InstanceMemberResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceMemberArgs = InstanceMemberArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceMemberArgsBuilder.() -> Unit) {
        val builder = InstanceMemberArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InstanceMember {
        val builtJavaResource =
            com.pulumi.alicloud.cloudfirewall.InstanceMember(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InstanceMember(builtJavaResource)
    }
}

/**
 * Provides a Cloud Firewall Instance Member resource.
 * For information about Cloud Firewall Instance Member and how to use it, see [What is Instance Member](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createloadbalancer).
 * > **NOTE:** Available in v1.194.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "AliyunTerraform";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultAccount = new alicloud.resourcemanager.Account("default", {displayName: `${name}-${_default.result}`});
 * const defaultInstanceMember = new alicloud.cloudfirewall.InstanceMember("default", {
 *     memberDesc: `${name}-${_default.result}`,
 *     memberUid: defaultAccount.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "AliyunTerraform"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_account = alicloud.resourcemanager.Account("default", display_name=f"{name}-{default['result']}")
 * default_instance_member = alicloud.cloudfirewall.InstanceMember("default",
 *     member_desc=f"{name}-{default['result']}",
 *     member_uid=default_account.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "AliyunTerraform";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultAccount = new AliCloud.ResourceManager.Account("default", new()
 *     {
 *         DisplayName = $"{name}-{@default.Result}",
 *     });
 *     var defaultInstanceMember = new AliCloud.CloudFirewall.InstanceMember("default", new()
 *     {
 *         MemberDesc = $"{name}-{@default.Result}",
 *         MemberUid = defaultAccount.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudfirewall"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "AliyunTerraform"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAccount, err := resourcemanager.NewAccount(ctx, "default", &resourcemanager.AccountArgs{
 * 			DisplayName: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudfirewall.NewInstanceMember(ctx, "default", &cloudfirewall.InstanceMemberArgs{
 * 			MemberDesc: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			MemberUid:  defaultAccount.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.resourcemanager.Account;
 * import com.pulumi.alicloud.resourcemanager.AccountArgs;
 * import com.pulumi.alicloud.cloudfirewall.InstanceMember;
 * import com.pulumi.alicloud.cloudfirewall.InstanceMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("AliyunTerraform");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultAccount = new Account("defaultAccount", AccountArgs.builder()
 *             .displayName(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var defaultInstanceMember = new InstanceMember("defaultInstanceMember", InstanceMemberArgs.builder()
 *             .memberDesc(String.format("%s-%s", name,default_.result()))
 *             .memberUid(defaultAccount.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: AliyunTerraform
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultAccount:
 *     type: alicloud:resourcemanager:Account
 *     name: default
 *     properties:
 *       displayName: ${name}-${default.result}
 *   defaultInstanceMember:
 *     type: alicloud:cloudfirewall:InstanceMember
 *     name: default
 *     properties:
 *       memberDesc: ${name}-${default.result}
 *       memberUid: ${defaultAccount.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Firewall Instance Member can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/instanceMember:InstanceMember example <id>
 * ```
 */
public class InstanceMember internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudfirewall.InstanceMember,
) : KotlinCustomResource(javaResource, InstanceMemberMapper) {
    /**
     * When the cloud firewall member account was added.> use second-level timestamp format.
     */
    public val createTime: Output<Int>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Remarks of cloud firewall member accounts.
     */
    public val memberDesc: Output<String>?
        get() = javaResource.memberDesc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the cloud firewall member account.
     */
    public val memberDisplayName: Output<String>
        get() = javaResource.memberDisplayName().applyValue({ args0 -> args0 })

    /**
     * The UID of the cloud firewall member account.
     */
    public val memberUid: Output<String>
        get() = javaResource.memberUid().applyValue({ args0 -> args0 })

    /**
     * The last modification time of the cloud firewall member account.> use second-level timestamp format.
     */
    public val modifyTime: Output<Int>
        get() = javaResource.modifyTime().applyValue({ args0 -> args0 })

    /**
     * The resource attribute field that represents the resource status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object InstanceMemberMapper : ResourceMapper<InstanceMember> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudfirewall.InstanceMember::class == javaResource::class

    override fun map(javaResource: Resource): InstanceMember = InstanceMember(
        javaResource as
            com.pulumi.alicloud.cloudfirewall.InstanceMember,
    )
}

/**
 * @see [InstanceMember].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceMember].
 */
public suspend fun instanceMember(
    name: String,
    block: suspend InstanceMemberResourceBuilder.() -> Unit,
): InstanceMember {
    val builder = InstanceMemberResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceMember].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceMember(name: String): InstanceMember {
    val builder = InstanceMemberResourceBuilder()
    builder.name(name)
    return builder.build()
}
