@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [NatFirewallControlPolicy].
 */
@PulumiTagMarker
public class NatFirewallControlPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NatFirewallControlPolicyArgs = NatFirewallControlPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NatFirewallControlPolicyArgsBuilder.() -> Unit) {
        val builder = NatFirewallControlPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NatFirewallControlPolicy {
        val builtJavaResource =
            com.pulumi.alicloud.cloudfirewall.NatFirewallControlPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NatFirewallControlPolicy(builtJavaResource)
    }
}

/**
 * Provides a Cloud Firewall Nat Firewall Control Policy resource. Nat firewall access control policy.
 * For information about Cloud Firewall Nat Firewall Control Policy and how to use it, see [What is Nat Firewall Control Policy](https://www.alibabacloud.com/help/en/cloud-firewall/developer-reference/api-cloudfw-2017-12-07-createnatfirewallcontrolpolicy).
 * > **NOTE:** Available since v1.224.0.
 * ## Import
 * Cloud Firewall Nat Firewall Control Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/natFirewallControlPolicy:NatFirewallControlPolicy example <acl_uuid>:<nat_gateway_id>:<direction>
 * ```
 */
public class NatFirewallControlPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudfirewall.NatFirewallControlPolicy,
) : KotlinCustomResource(javaResource, NatFirewallControlPolicyMapper) {
    /**
     * The method (action) of access traffic passing through Cloud Firewall in the security access control policy. Valid values:
     * - **accept**: Release
     * - **drop**: Refused
     * - **log**: Observation.
     */
    public val aclAction: Output<String>
        get() = javaResource.aclAction().applyValue({ args0 -> args0 })

    /**
     * The unique ID of the security access control policy.
     * > **NOTE:**  To modify a security access control policy, you need to provide the unique ID of the policy. You can call the DescribeNatFirewallControlPolicy interface to obtain the ID.
     */
    public val aclUuid: Output<String>
        get() = javaResource.aclUuid().applyValue({ args0 -> args0 })

    /**
     * The list of application types supported by the access control policy.
     */
    public val applicationNameLists: Output<List<String>>
        get() = javaResource.applicationNameLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The time when the policy was created.
     */
    public val createTime: Output<Int>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the access control policy.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The destination port of traffic access in the access control policy. Value:
     * - When the protocol type is set to ICMP, the value of DestPort is null.
     * > **NOTE:**  When the protocol type is ICMP, access control on the destination port is not supported.
     * - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) IS group, the value of DestPort is null.
     * > **NOTE:**  When you select group (destination port address book) for the destination port type of the access control policy, you do not need to set a specific destination port number. All ports that need to be controlled by this access control policy are included in the destination port address book.
     * - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) is port, the value of DestPort is the destination port number.
     */
    public val destPort: Output<String>
        get() = javaResource.destPort().applyValue({ args0 -> args0 })

    /**
     * The address book name of the destination port of the access traffic in the access control policy.
     * > **NOTE:**  When DestPortType is set to group, you need to set the destination port address book name.
     */
    public val destPortGroup: Output<String>?
        get() = javaResource.destPortGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The destination port type of the access traffic in the security access control policy.
     * - **port**: port
     * - **group**: Port Address Book.
     */
    public val destPortType: Output<String>
        get() = javaResource.destPortType().applyValue({ args0 -> args0 })

    /**
     * The destination address segment in the access control policy. Valid values:
     * - When DestinationType is net, Destination is the Destination CIDR. For example: 1.2.XX.XX/24
     * - When DestinationType IS group, Destination is the name of the Destination address book. For example: db_group
     * - When DestinationType is domain, Destination is the Destination domain name. For example: * .aliyuncs.com
     * - When DestinationType is location, Destination is the Destination region. For example: \["BJ11", "ZB"\].
     */
    public val destination: Output<String>
        get() = javaResource.destination().applyValue({ args0 -> args0 })

    /**
     * The destination address type in the access control policy. Valid values:
     * - **net**: Destination Network segment (CIDR address)
     * - **group**: Destination Address Book
     * - **domain**: the destination domain name.
     */
    public val destinationType: Output<String>
        get() = javaResource.destinationType().applyValue({ args0 -> args0 })

    /**
     * The traffic direction of the access control policy. Valid values:
     * - **out**: Internal and external traffic access control.
     */
    public val direction: Output<String>
        get() = javaResource.direction().applyValue({ args0 -> args0 })

    /**
     * The domain name resolution method of the access control policy. The policy is enabled by default after it is created. Valid values:
     * - **0**: Based on FQDN
     * - **1**: DNS-based dynamic resolution
     * - **2**: dynamic resolution based on FQDN and DNS.
     */
    public val domainResolveType: Output<Int>?
        get() = javaResource.domainResolveType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The end time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. Must be full or half time and at least half an hour greater than the start time.
     * > **NOTE:**  When RepeatType is set to permit, EndTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, EndTime must have a value and you need to set the end time.
     */
    public val endTime: Output<Int>?
        get() = javaResource.endTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Supported IP address version. Value:
     * - **4** (default): indicates the IPv4 address.
     */
    public val ipVersion: Output<String>?
        get() = javaResource.ipVersion().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the NAT gateway instance.
     */
    public val natGatewayId: Output<String>
        get() = javaResource.natGatewayId().applyValue({ args0 -> args0 })

    /**
     * The priority for the access control policy to take effect. The priority number increases sequentially from 1, and the smaller the priority number, the higher the priority.
     */
    public val newOrder: Output<String>
        get() = javaResource.newOrder().applyValue({ args0 -> args0 })

    /**
     * The security protocol type for traffic access in the access control policy. Valid values:
     * - ANY (indicates that all protocol types are queried)
     * - TCP
     * - UDP
     * - ICMP.
     */
    public val proto: Output<String>
        get() = javaResource.proto().applyValue({ args0 -> args0 })

    /**
     * The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
     * - **true**: Enable access control policy
     * - **false**: Do not enable access control policies.
     */
    public val release: Output<String>
        get() = javaResource.release().applyValue({ args0 -> args0 })

    /**
     * Collection of recurring dates for the policy validity period of the access control policy.
     * - When RepeatType is 'Permanent', 'None', 'Daily', RepeatDays is an empty collection. For example:[]
     * - When RepeatType is Weekly, RepeatDays cannot be empty. For example:["0", "6"]. When the RepeatType is set to Weekly, RepeatDays cannot be repeated.
     * - RepeatDays cannot be empty when RepeatType is 'Monthly. For example:[1, 31]. When RepeatType is set to Monthly, RepeatDays cannot be repeated.
     */
    public val repeatDays: Output<List<Int>>?
        get() = javaResource.repeatDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The recurring end time of the policy validity period of the access control policy. For example: 23:30, it must be the whole point or half point time, and at least half an hour greater than the repeat start time.
     * > **NOTE:**  When RepeatType is set to normal or None, RepeatEndTime is null. When the RepeatType is Daily, Weekly, or Monthly, the RepeatEndTime must have a value, and you need to set the repeat end time.
     */
    public val repeatEndTime: Output<String>?
        get() = javaResource.repeatEndTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The recurring start time of the policy validity period of the access control policy. For example: 08:00, it must be the whole point or half point time, and at least half an hour less than the repeat end time.
     * > **NOTE:**  When RepeatType is set to permit or None, RepeatStartTime is empty. When the RepeatType is Daily, Weekly, or Monthly, the RepeatStartTime must have a value and you need to set the repeat start time.
     */
    public val repeatStartTime: Output<String>?
        get() = javaResource.repeatStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of repetition for the policy validity period of the access control policy. Value:
     * - **Permit** (default): Always
     * - **None**: Specify a single time
     * - **Daily**: Daily
     * - **Weekly**: Weekly
     * - **Monthly**: Monthly.
     */
    public val repeatType: Output<String>
        get() = javaResource.repeatType().applyValue({ args0 -> args0 })

    /**
     * The source address in the access control policy. Valid values:
     * - When **SourceType** is set to 'net', Source is the Source CIDR address. For example: 10.2.4.0/24
     * - When **SourceType** is set to 'group', Source is the name of the Source address book. For example: db_group.
     */
    public val source: Output<String>
        get() = javaResource.source().applyValue({ args0 -> args0 })

    /**
     * The source address type in the access control policy. Valid values:
     * - **net**: the source network segment (CIDR address)
     * - **group**: source address book
     */
    public val sourceType: Output<String>
        get() = javaResource.sourceType().applyValue({ args0 -> args0 })

    /**
     * The start time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. It must be a full or half hour and at least half an hour less than the end time.
     * > **NOTE:**  When RepeatType is set to normal, StartTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, StartTime must have a value and you need to set the start time.
     */
    public val startTime: Output<Int>?
        get() = javaResource.startTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object NatFirewallControlPolicyMapper : ResourceMapper<NatFirewallControlPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudfirewall.NatFirewallControlPolicy::class == javaResource::class

    override fun map(javaResource: Resource): NatFirewallControlPolicy =
        NatFirewallControlPolicy(
            javaResource as
                com.pulumi.alicloud.cloudfirewall.NatFirewallControlPolicy,
        )
}

/**
 * @see [NatFirewallControlPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NatFirewallControlPolicy].
 */
public suspend fun natFirewallControlPolicy(
    name: String,
    block: suspend NatFirewallControlPolicyResourceBuilder.() -> Unit,
): NatFirewallControlPolicy {
    val builder = NatFirewallControlPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NatFirewallControlPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun natFirewallControlPolicy(name: String): NatFirewallControlPolicy {
    val builder = NatFirewallControlPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
