@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin

import com.pulumi.alicloud.cloudfirewall.NatFirewallControlPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Firewall Nat Firewall Control Policy resource. Nat firewall access control policy.
 * For information about Cloud Firewall Nat Firewall Control Policy and how to use it, see [What is Nat Firewall Control Policy](https://www.alibabacloud.com/help/en/cloud-firewall/developer-reference/api-cloudfw-2017-12-07-createnatfirewallcontrolpolicy).
 * > **NOTE:** Available since v1.224.0.
 * ## Import
 * Cloud Firewall Nat Firewall Control Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudfirewall/natFirewallControlPolicy:NatFirewallControlPolicy example <acl_uuid>:<nat_gateway_id>:<direction>
 * ```
 * @property aclAction The method (action) of access traffic passing through Cloud Firewall in the security access control policy. Valid values:
 * - **accept**: Release
 * - **drop**: Refused
 * - **log**: Observation.
 * @property applicationNameLists The list of application types supported by the access control policy.
 * @property description The description of the access control policy.
 * @property destPort The destination port of traffic access in the access control policy. Value:
 * - When the protocol type is set to ICMP, the value of DestPort is null.
 * > **NOTE:**  When the protocol type is ICMP, access control on the destination port is not supported.
 * - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) IS group, the value of DestPort is null.
 * > **NOTE:**  When you select group (destination port address book) for the destination port type of the access control policy, you do not need to set a specific destination port number. All ports that need to be controlled by this access control policy are included in the destination port address book.
 * - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) is port, the value of DestPort is the destination port number.
 * @property destPortGroup The address book name of the destination port of the access traffic in the access control policy.
 * > **NOTE:**  When DestPortType is set to group, you need to set the destination port address book name.
 * @property destPortType The destination port type of the access traffic in the security access control policy.
 * - **port**: port
 * - **group**: Port Address Book.
 * @property destination The destination address segment in the access control policy. Valid values:
 * - When DestinationType is net, Destination is the Destination CIDR. For example: 1.2.XX.XX/24
 * - When DestinationType IS group, Destination is the name of the Destination address book. For example: db_group
 * - When DestinationType is domain, Destination is the Destination domain name. For example: * .aliyuncs.com
 * - When DestinationType is location, Destination is the Destination region. For example: \["BJ11", "ZB"\].
 * @property destinationType The destination address type in the access control policy. Valid values:
 * - **net**: Destination Network segment (CIDR address)
 * - **group**: Destination Address Book
 * - **domain**: the destination domain name.
 * @property direction The traffic direction of the access control policy. Valid values:
 * - **out**: Internal and external traffic access control.
 * @property domainResolveType The domain name resolution method of the access control policy. The policy is enabled by default after it is created. Valid values:
 * - **0**: Based on FQDN
 * - **1**: DNS-based dynamic resolution
 * - **2**: dynamic resolution based on FQDN and DNS.
 * @property endTime The end time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. Must be full or half time and at least half an hour greater than the start time.
 * > **NOTE:**  When RepeatType is set to permit, EndTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, EndTime must have a value and you need to set the end time.
 * @property ipVersion Supported IP address version. Value:
 * - **4** (default): indicates the IPv4 address.
 * @property natGatewayId The ID of the NAT gateway instance.
 * @property newOrder The priority for the access control policy to take effect. The priority number increases sequentially from 1, and the smaller the priority number, the higher the priority.
 * @property proto The security protocol type for traffic access in the access control policy. Valid values:
 * - ANY (indicates that all protocol types are queried)
 * - TCP
 * - UDP
 * - ICMP.
 * @property release The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
 * - **true**: Enable access control policy
 * - **false**: Do not enable access control policies.
 * @property repeatDays Collection of recurring dates for the policy validity period of the access control policy.
 * - When RepeatType is 'Permanent', 'None', 'Daily', RepeatDays is an empty collection. For example:[]
 * - When RepeatType is Weekly, RepeatDays cannot be empty. For example:["0", "6"]. When the RepeatType is set to Weekly, RepeatDays cannot be repeated.
 * - RepeatDays cannot be empty when RepeatType is 'Monthly. For example:[1, 31]. When RepeatType is set to Monthly, RepeatDays cannot be repeated.
 * @property repeatEndTime The recurring end time of the policy validity period of the access control policy. For example: 23:30, it must be the whole point or half point time, and at least half an hour greater than the repeat start time.
 * > **NOTE:**  When RepeatType is set to normal or None, RepeatEndTime is null. When the RepeatType is Daily, Weekly, or Monthly, the RepeatEndTime must have a value, and you need to set the repeat end time.
 * @property repeatStartTime The recurring start time of the policy validity period of the access control policy. For example: 08:00, it must be the whole point or half point time, and at least half an hour less than the repeat end time.
 * > **NOTE:**  When RepeatType is set to permit or None, RepeatStartTime is empty. When the RepeatType is Daily, Weekly, or Monthly, the RepeatStartTime must have a value and you need to set the repeat start time.
 * @property repeatType The type of repetition for the policy validity period of the access control policy. Value:
 * - **Permit** (default): Always
 * - **None**: Specify a single time
 * - **Daily**: Daily
 * - **Weekly**: Weekly
 * - **Monthly**: Monthly.
 * @property source The source address in the access control policy. Valid values:
 * - When **SourceType** is set to 'net', Source is the Source CIDR address. For example: 10.2.4.0/24
 * - When **SourceType** is set to 'group', Source is the name of the Source address book. For example: db_group.
 * @property sourceType The source address type in the access control policy. Valid values:
 * - **net**: the source network segment (CIDR address)
 * - **group**: source address book
 * @property startTime The start time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. It must be a full or half hour and at least half an hour less than the end time.
 * > **NOTE:**  When RepeatType is set to normal, StartTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, StartTime must have a value and you need to set the start time.
 */
public data class NatFirewallControlPolicyArgs(
    public val aclAction: Output<String>? = null,
    public val applicationNameLists: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val destPort: Output<String>? = null,
    public val destPortGroup: Output<String>? = null,
    public val destPortType: Output<String>? = null,
    public val destination: Output<String>? = null,
    public val destinationType: Output<String>? = null,
    public val direction: Output<String>? = null,
    public val domainResolveType: Output<Int>? = null,
    public val endTime: Output<Int>? = null,
    public val ipVersion: Output<String>? = null,
    public val natGatewayId: Output<String>? = null,
    public val newOrder: Output<String>? = null,
    public val proto: Output<String>? = null,
    public val release: Output<String>? = null,
    public val repeatDays: Output<List<Int>>? = null,
    public val repeatEndTime: Output<String>? = null,
    public val repeatStartTime: Output<String>? = null,
    public val repeatType: Output<String>? = null,
    public val source: Output<String>? = null,
    public val sourceType: Output<String>? = null,
    public val startTime: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.NatFirewallControlPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.NatFirewallControlPolicyArgs =
        com.pulumi.alicloud.cloudfirewall.NatFirewallControlPolicyArgs.builder()
            .aclAction(aclAction?.applyValue({ args0 -> args0 }))
            .applicationNameLists(applicationNameLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .destPort(destPort?.applyValue({ args0 -> args0 }))
            .destPortGroup(destPortGroup?.applyValue({ args0 -> args0 }))
            .destPortType(destPortType?.applyValue({ args0 -> args0 }))
            .destination(destination?.applyValue({ args0 -> args0 }))
            .destinationType(destinationType?.applyValue({ args0 -> args0 }))
            .direction(direction?.applyValue({ args0 -> args0 }))
            .domainResolveType(domainResolveType?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .ipVersion(ipVersion?.applyValue({ args0 -> args0 }))
            .natGatewayId(natGatewayId?.applyValue({ args0 -> args0 }))
            .newOrder(newOrder?.applyValue({ args0 -> args0 }))
            .proto(proto?.applyValue({ args0 -> args0 }))
            .release(release?.applyValue({ args0 -> args0 }))
            .repeatDays(repeatDays?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .repeatEndTime(repeatEndTime?.applyValue({ args0 -> args0 }))
            .repeatStartTime(repeatStartTime?.applyValue({ args0 -> args0 }))
            .repeatType(repeatType?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .sourceType(sourceType?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NatFirewallControlPolicyArgs].
 */
@PulumiTagMarker
public class NatFirewallControlPolicyArgsBuilder internal constructor() {
    private var aclAction: Output<String>? = null

    private var applicationNameLists: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var destPort: Output<String>? = null

    private var destPortGroup: Output<String>? = null

    private var destPortType: Output<String>? = null

    private var destination: Output<String>? = null

    private var destinationType: Output<String>? = null

    private var direction: Output<String>? = null

    private var domainResolveType: Output<Int>? = null

    private var endTime: Output<Int>? = null

    private var ipVersion: Output<String>? = null

    private var natGatewayId: Output<String>? = null

    private var newOrder: Output<String>? = null

    private var proto: Output<String>? = null

    private var release: Output<String>? = null

    private var repeatDays: Output<List<Int>>? = null

    private var repeatEndTime: Output<String>? = null

    private var repeatStartTime: Output<String>? = null

    private var repeatType: Output<String>? = null

    private var source: Output<String>? = null

    private var sourceType: Output<String>? = null

    private var startTime: Output<Int>? = null

    /**
     * @param value The method (action) of access traffic passing through Cloud Firewall in the security access control policy. Valid values:
     * - **accept**: Release
     * - **drop**: Refused
     * - **log**: Observation.
     */
    @JvmName("ftwyoxfkichfmjcx")
    public suspend fun aclAction(`value`: Output<String>) {
        this.aclAction = value
    }

    /**
     * @param value The list of application types supported by the access control policy.
     */
    @JvmName("bfebirgbqtejijmx")
    public suspend fun applicationNameLists(`value`: Output<List<String>>) {
        this.applicationNameLists = value
    }

    @JvmName("sfuigjajchwgocdt")
    public suspend fun applicationNameLists(vararg values: Output<String>) {
        this.applicationNameLists = Output.all(values.asList())
    }

    /**
     * @param values The list of application types supported by the access control policy.
     */
    @JvmName("henanxbtsnarfeao")
    public suspend fun applicationNameLists(values: List<Output<String>>) {
        this.applicationNameLists = Output.all(values)
    }

    /**
     * @param value The description of the access control policy.
     */
    @JvmName("jqfmqlvpciuwoocm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The destination port of traffic access in the access control policy. Value:
     * - When the protocol type is set to ICMP, the value of DestPort is null.
     * > **NOTE:**  When the protocol type is ICMP, access control on the destination port is not supported.
     * - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) IS group, the value of DestPort is null.
     * > **NOTE:**  When you select group (destination port address book) for the destination port type of the access control policy, you do not need to set a specific destination port number. All ports that need to be controlled by this access control policy are included in the destination port address book.
     * - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) is port, the value of DestPort is the destination port number.
     */
    @JvmName("sfbeslveklbqnxir")
    public suspend fun destPort(`value`: Output<String>) {
        this.destPort = value
    }

    /**
     * @param value The address book name of the destination port of the access traffic in the access control policy.
     * > **NOTE:**  When DestPortType is set to group, you need to set the destination port address book name.
     */
    @JvmName("vjfcmeuajgqrdqfg")
    public suspend fun destPortGroup(`value`: Output<String>) {
        this.destPortGroup = value
    }

    /**
     * @param value The destination port type of the access traffic in the security access control policy.
     * - **port**: port
     * - **group**: Port Address Book.
     */
    @JvmName("wrsavvqxnhuevypr")
    public suspend fun destPortType(`value`: Output<String>) {
        this.destPortType = value
    }

    /**
     * @param value The destination address segment in the access control policy. Valid values:
     * - When DestinationType is net, Destination is the Destination CIDR. For example: 1.2.XX.XX/24
     * - When DestinationType IS group, Destination is the name of the Destination address book. For example: db_group
     * - When DestinationType is domain, Destination is the Destination domain name. For example: * .aliyuncs.com
     * - When DestinationType is location, Destination is the Destination region. For example: \["BJ11", "ZB"\].
     */
    @JvmName("maxuvadwqtnsvsve")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value The destination address type in the access control policy. Valid values:
     * - **net**: Destination Network segment (CIDR address)
     * - **group**: Destination Address Book
     * - **domain**: the destination domain name.
     */
    @JvmName("puoibjhpanhhnmmh")
    public suspend fun destinationType(`value`: Output<String>) {
        this.destinationType = value
    }

    /**
     * @param value The traffic direction of the access control policy. Valid values:
     * - **out**: Internal and external traffic access control.
     */
    @JvmName("asyuhcobptqsvrwv")
    public suspend fun direction(`value`: Output<String>) {
        this.direction = value
    }

    /**
     * @param value The domain name resolution method of the access control policy. The policy is enabled by default after it is created. Valid values:
     * - **0**: Based on FQDN
     * - **1**: DNS-based dynamic resolution
     * - **2**: dynamic resolution based on FQDN and DNS.
     */
    @JvmName("rsftsqiumkoubjiw")
    public suspend fun domainResolveType(`value`: Output<Int>) {
        this.domainResolveType = value
    }

    /**
     * @param value The end time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. Must be full or half time and at least half an hour greater than the start time.
     * > **NOTE:**  When RepeatType is set to permit, EndTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, EndTime must have a value and you need to set the end time.
     */
    @JvmName("lhowvvtmuxqusdgg")
    public suspend fun endTime(`value`: Output<Int>) {
        this.endTime = value
    }

    /**
     * @param value Supported IP address version. Value:
     * - **4** (default): indicates the IPv4 address.
     */
    @JvmName("fisfbbgkpjwijmvr")
    public suspend fun ipVersion(`value`: Output<String>) {
        this.ipVersion = value
    }

    /**
     * @param value The ID of the NAT gateway instance.
     */
    @JvmName("kvobbtmyyftktvrd")
    public suspend fun natGatewayId(`value`: Output<String>) {
        this.natGatewayId = value
    }

    /**
     * @param value The priority for the access control policy to take effect. The priority number increases sequentially from 1, and the smaller the priority number, the higher the priority.
     */
    @JvmName("sagaxjcksmmukurg")
    public suspend fun newOrder(`value`: Output<String>) {
        this.newOrder = value
    }

    /**
     * @param value The security protocol type for traffic access in the access control policy. Valid values:
     * - ANY (indicates that all protocol types are queried)
     * - TCP
     * - UDP
     * - ICMP.
     */
    @JvmName("bfpdacujjwjoikvx")
    public suspend fun proto(`value`: Output<String>) {
        this.proto = value
    }

    /**
     * @param value The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
     * - **true**: Enable access control policy
     * - **false**: Do not enable access control policies.
     */
    @JvmName("uhlxiknporhdmobf")
    public suspend fun release(`value`: Output<String>) {
        this.release = value
    }

    /**
     * @param value Collection of recurring dates for the policy validity period of the access control policy.
     * - When RepeatType is 'Permanent', 'None', 'Daily', RepeatDays is an empty collection. For example:[]
     * - When RepeatType is Weekly, RepeatDays cannot be empty. For example:["0", "6"]. When the RepeatType is set to Weekly, RepeatDays cannot be repeated.
     * - RepeatDays cannot be empty when RepeatType is 'Monthly. For example:[1, 31]. When RepeatType is set to Monthly, RepeatDays cannot be repeated.
     */
    @JvmName("olkrtovaavcbpfur")
    public suspend fun repeatDays(`value`: Output<List<Int>>) {
        this.repeatDays = value
    }

    @JvmName("inuyfdqdaqillqvx")
    public suspend fun repeatDays(vararg values: Output<Int>) {
        this.repeatDays = Output.all(values.asList())
    }

    /**
     * @param values Collection of recurring dates for the policy validity period of the access control policy.
     * - When RepeatType is 'Permanent', 'None', 'Daily', RepeatDays is an empty collection. For example:[]
     * - When RepeatType is Weekly, RepeatDays cannot be empty. For example:["0", "6"]. When the RepeatType is set to Weekly, RepeatDays cannot be repeated.
     * - RepeatDays cannot be empty when RepeatType is 'Monthly. For example:[1, 31]. When RepeatType is set to Monthly, RepeatDays cannot be repeated.
     */
    @JvmName("ibphlpmkujgbfcyc")
    public suspend fun repeatDays(values: List<Output<Int>>) {
        this.repeatDays = Output.all(values)
    }

    /**
     * @param value The recurring end time of the policy validity period of the access control policy. For example: 23:30, it must be the whole point or half point time, and at least half an hour greater than the repeat start time.
     * > **NOTE:**  When RepeatType is set to normal or None, RepeatEndTime is null. When the RepeatType is Daily, Weekly, or Monthly, the RepeatEndTime must have a value, and you need to set the repeat end time.
     */
    @JvmName("yqaysoclfcoimjfs")
    public suspend fun repeatEndTime(`value`: Output<String>) {
        this.repeatEndTime = value
    }

    /**
     * @param value The recurring start time of the policy validity period of the access control policy. For example: 08:00, it must be the whole point or half point time, and at least half an hour less than the repeat end time.
     * > **NOTE:**  When RepeatType is set to permit or None, RepeatStartTime is empty. When the RepeatType is Daily, Weekly, or Monthly, the RepeatStartTime must have a value and you need to set the repeat start time.
     */
    @JvmName("essvljivmfivxjkd")
    public suspend fun repeatStartTime(`value`: Output<String>) {
        this.repeatStartTime = value
    }

    /**
     * @param value The type of repetition for the policy validity period of the access control policy. Value:
     * - **Permit** (default): Always
     * - **None**: Specify a single time
     * - **Daily**: Daily
     * - **Weekly**: Weekly
     * - **Monthly**: Monthly.
     */
    @JvmName("rfiijptuglmelavw")
    public suspend fun repeatType(`value`: Output<String>) {
        this.repeatType = value
    }

    /**
     * @param value The source address in the access control policy. Valid values:
     * - When **SourceType** is set to 'net', Source is the Source CIDR address. For example: 10.2.4.0/24
     * - When **SourceType** is set to 'group', Source is the name of the Source address book. For example: db_group.
     */
    @JvmName("adeokfjwgovvnqdu")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The source address type in the access control policy. Valid values:
     * - **net**: the source network segment (CIDR address)
     * - **group**: source address book
     */
    @JvmName("ugerrcqfgrdvlyqw")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value The start time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. It must be a full or half hour and at least half an hour less than the end time.
     * > **NOTE:**  When RepeatType is set to normal, StartTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, StartTime must have a value and you need to set the start time.
     */
    @JvmName("bjaadavnijrjyuyn")
    public suspend fun startTime(`value`: Output<Int>) {
        this.startTime = value
    }

    /**
     * @param value The method (action) of access traffic passing through Cloud Firewall in the security access control policy. Valid values:
     * - **accept**: Release
     * - **drop**: Refused
     * - **log**: Observation.
     */
    @JvmName("ijgycdwepiitbmvs")
    public suspend fun aclAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclAction = mapped
    }

    /**
     * @param value The list of application types supported by the access control policy.
     */
    @JvmName("fpuabqmbflelwbuu")
    public suspend fun applicationNameLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationNameLists = mapped
    }

    /**
     * @param values The list of application types supported by the access control policy.
     */
    @JvmName("ffjyhfivnohlaseu")
    public suspend fun applicationNameLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationNameLists = mapped
    }

    /**
     * @param value The description of the access control policy.
     */
    @JvmName("juejsebijywswwwx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The destination port of traffic access in the access control policy. Value:
     * - When the protocol type is set to ICMP, the value of DestPort is null.
     * > **NOTE:**  When the protocol type is ICMP, access control on the destination port is not supported.
     * - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) IS group, the value of DestPort is null.
     * > **NOTE:**  When you select group (destination port address book) for the destination port type of the access control policy, you do not need to set a specific destination port number. All ports that need to be controlled by this access control policy are included in the destination port address book.
     * - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) is port, the value of DestPort is the destination port number.
     */
    @JvmName("xnahegiielrljgpx")
    public suspend fun destPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destPort = mapped
    }

    /**
     * @param value The address book name of the destination port of the access traffic in the access control policy.
     * > **NOTE:**  When DestPortType is set to group, you need to set the destination port address book name.
     */
    @JvmName("efnvocyasaofaukp")
    public suspend fun destPortGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destPortGroup = mapped
    }

    /**
     * @param value The destination port type of the access traffic in the security access control policy.
     * - **port**: port
     * - **group**: Port Address Book.
     */
    @JvmName("tqurtxbfkvxllxts")
    public suspend fun destPortType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destPortType = mapped
    }

    /**
     * @param value The destination address segment in the access control policy. Valid values:
     * - When DestinationType is net, Destination is the Destination CIDR. For example: 1.2.XX.XX/24
     * - When DestinationType IS group, Destination is the name of the Destination address book. For example: db_group
     * - When DestinationType is domain, Destination is the Destination domain name. For example: * .aliyuncs.com
     * - When DestinationType is location, Destination is the Destination region. For example: \["BJ11", "ZB"\].
     */
    @JvmName("pyyiupknjdujihts")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value The destination address type in the access control policy. Valid values:
     * - **net**: Destination Network segment (CIDR address)
     * - **group**: Destination Address Book
     * - **domain**: the destination domain name.
     */
    @JvmName("uyleecvtldhwxvwv")
    public suspend fun destinationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    /**
     * @param value The traffic direction of the access control policy. Valid values:
     * - **out**: Internal and external traffic access control.
     */
    @JvmName("mwedrugwdqmcpvoq")
    public suspend fun direction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The domain name resolution method of the access control policy. The policy is enabled by default after it is created. Valid values:
     * - **0**: Based on FQDN
     * - **1**: DNS-based dynamic resolution
     * - **2**: dynamic resolution based on FQDN and DNS.
     */
    @JvmName("eqptbmojahrrcaut")
    public suspend fun domainResolveType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainResolveType = mapped
    }

    /**
     * @param value The end time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. Must be full or half time and at least half an hour greater than the start time.
     * > **NOTE:**  When RepeatType is set to permit, EndTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, EndTime must have a value and you need to set the end time.
     */
    @JvmName("vensjigcrxhddcqy")
    public suspend fun endTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value Supported IP address version. Value:
     * - **4** (default): indicates the IPv4 address.
     */
    @JvmName("qnbcisiodkanlylx")
    public suspend fun ipVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipVersion = mapped
    }

    /**
     * @param value The ID of the NAT gateway instance.
     */
    @JvmName("ryehrsmctiuiersn")
    public suspend fun natGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGatewayId = mapped
    }

    /**
     * @param value The priority for the access control policy to take effect. The priority number increases sequentially from 1, and the smaller the priority number, the higher the priority.
     */
    @JvmName("nlsfasvoqkmhogmp")
    public suspend fun newOrder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newOrder = mapped
    }

    /**
     * @param value The security protocol type for traffic access in the access control policy. Valid values:
     * - ANY (indicates that all protocol types are queried)
     * - TCP
     * - UDP
     * - ICMP.
     */
    @JvmName("wpqcewexvdvbwxbd")
    public suspend fun proto(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proto = mapped
    }

    /**
     * @param value The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
     * - **true**: Enable access control policy
     * - **false**: Do not enable access control policies.
     */
    @JvmName("qctrhvluuipjupil")
    public suspend fun release(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.release = mapped
    }

    /**
     * @param value Collection of recurring dates for the policy validity period of the access control policy.
     * - When RepeatType is 'Permanent', 'None', 'Daily', RepeatDays is an empty collection. For example:[]
     * - When RepeatType is Weekly, RepeatDays cannot be empty. For example:["0", "6"]. When the RepeatType is set to Weekly, RepeatDays cannot be repeated.
     * - RepeatDays cannot be empty when RepeatType is 'Monthly. For example:[1, 31]. When RepeatType is set to Monthly, RepeatDays cannot be repeated.
     */
    @JvmName("viycbceakxjrwdxb")
    public suspend fun repeatDays(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repeatDays = mapped
    }

    /**
     * @param values Collection of recurring dates for the policy validity period of the access control policy.
     * - When RepeatType is 'Permanent', 'None', 'Daily', RepeatDays is an empty collection. For example:[]
     * - When RepeatType is Weekly, RepeatDays cannot be empty. For example:["0", "6"]. When the RepeatType is set to Weekly, RepeatDays cannot be repeated.
     * - RepeatDays cannot be empty when RepeatType is 'Monthly. For example:[1, 31]. When RepeatType is set to Monthly, RepeatDays cannot be repeated.
     */
    @JvmName("rmcbosfwrstphrbi")
    public suspend fun repeatDays(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repeatDays = mapped
    }

    /**
     * @param value The recurring end time of the policy validity period of the access control policy. For example: 23:30, it must be the whole point or half point time, and at least half an hour greater than the repeat start time.
     * > **NOTE:**  When RepeatType is set to normal or None, RepeatEndTime is null. When the RepeatType is Daily, Weekly, or Monthly, the RepeatEndTime must have a value, and you need to set the repeat end time.
     */
    @JvmName("ldadwbpskjqgqedd")
    public suspend fun repeatEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repeatEndTime = mapped
    }

    /**
     * @param value The recurring start time of the policy validity period of the access control policy. For example: 08:00, it must be the whole point or half point time, and at least half an hour less than the repeat end time.
     * > **NOTE:**  When RepeatType is set to permit or None, RepeatStartTime is empty. When the RepeatType is Daily, Weekly, or Monthly, the RepeatStartTime must have a value and you need to set the repeat start time.
     */
    @JvmName("ampgyqlqhykoatmp")
    public suspend fun repeatStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repeatStartTime = mapped
    }

    /**
     * @param value The type of repetition for the policy validity period of the access control policy. Value:
     * - **Permit** (default): Always
     * - **None**: Specify a single time
     * - **Daily**: Daily
     * - **Weekly**: Weekly
     * - **Monthly**: Monthly.
     */
    @JvmName("iduvnppwthnhybsu")
    public suspend fun repeatType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repeatType = mapped
    }

    /**
     * @param value The source address in the access control policy. Valid values:
     * - When **SourceType** is set to 'net', Source is the Source CIDR address. For example: 10.2.4.0/24
     * - When **SourceType** is set to 'group', Source is the name of the Source address book. For example: db_group.
     */
    @JvmName("epgjxgwbrnyfkpes")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The source address type in the access control policy. Valid values:
     * - **net**: the source network segment (CIDR address)
     * - **group**: source address book
     */
    @JvmName("hlyoqvbqpbvikbwk")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value The start time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. It must be a full or half hour and at least half an hour less than the end time.
     * > **NOTE:**  When RepeatType is set to normal, StartTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, StartTime must have a value and you need to set the start time.
     */
    @JvmName("xxnnckymxyqslnwj")
    public suspend fun startTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): NatFirewallControlPolicyArgs = NatFirewallControlPolicyArgs(
        aclAction = aclAction,
        applicationNameLists = applicationNameLists,
        description = description,
        destPort = destPort,
        destPortGroup = destPortGroup,
        destPortType = destPortType,
        destination = destination,
        destinationType = destinationType,
        direction = direction,
        domainResolveType = domainResolveType,
        endTime = endTime,
        ipVersion = ipVersion,
        natGatewayId = natGatewayId,
        newOrder = newOrder,
        proto = proto,
        release = release,
        repeatDays = repeatDays,
        repeatEndTime = repeatEndTime,
        repeatStartTime = repeatStartTime,
        repeatType = repeatType,
        source = source,
        sourceType = sourceType,
        startTime = startTime,
    )
}
