@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.AddressBookEcsTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property tagKey The key of ECS tag that to be matched.
 * @property tagValue The value of ECS tag that to be matched.
 */
public data class AddressBookEcsTagArgs(
    public val tagKey: Output<String>? = null,
    public val tagValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.AddressBookEcsTagArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.AddressBookEcsTagArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.AddressBookEcsTagArgs.builder()
            .tagKey(tagKey?.applyValue({ args0 -> args0 }))
            .tagValue(tagValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddressBookEcsTagArgs].
 */
@PulumiTagMarker
public class AddressBookEcsTagArgsBuilder internal constructor() {
    private var tagKey: Output<String>? = null

    private var tagValue: Output<String>? = null

    /**
     * @param value The key of ECS tag that to be matched.
     */
    @JvmName("yeobjqryqpxludgk")
    public suspend fun tagKey(`value`: Output<String>) {
        this.tagKey = value
    }

    /**
     * @param value The value of ECS tag that to be matched.
     */
    @JvmName("fenvvkkcvxivibpu")
    public suspend fun tagValue(`value`: Output<String>) {
        this.tagValue = value
    }

    /**
     * @param value The key of ECS tag that to be matched.
     */
    @JvmName("bjdofgijqlffurrv")
    public suspend fun tagKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagKey = mapped
    }

    /**
     * @param value The value of ECS tag that to be matched.
     */
    @JvmName("tktriydjvwjckdgf")
    public suspend fun tagValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagValue = mapped
    }

    internal fun build(): AddressBookEcsTagArgs = AddressBookEcsTagArgs(
        tagKey = tagKey,
        tagValue = tagValue,
    )
}
