@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property attachmentId The connection ID of the network instance.
 * @property attachmentName The connection name of the network instance.
 * @property defendCidrLists The list of network segments protected by the VPC firewall.
 * @property eniLists List of elastic network cards.
 * @property manualVswitchId The ID of the vSwitch specified when the routing mode is manual mode.
 * @property networkInstanceId The ID of the VPC instance that created the VPC firewall.
 * @property networkInstanceName The name of the network instance.
 * @property networkInstanceType The type of the network instance. Value: **VPC * *.
 * @property ownerId The UID of the Alibaba Cloud account to which the VPC belongs.
 * @property regionNo The region ID of the VPC.
 * @property routeMode Routing mode,. Value:-auto: indicates automatic mode.-manual: indicates manual mode.
 * @property supportManualMode Whether routing mode supports manual mode. Value:-**1**: Supported.-**0**: Not supported.
 * @property transitRouterId The ID of the CEN-TR instance.
 * @property transitRouterType The version of the cloud enterprise network forwarding router (CEN-TR). Value:-**Basic**: Basic Edition.-**Enterprise**: Enterprise Edition.
 * @property vpcCidrTableLists The VPC network segment list.
 * @property vpcId The ID of the VPC instance.
 * @property vpcName The instance name of the VPC.
 */
public data class FirewallVpcFirewallCenLocalVpcArgs(
    public val attachmentId: Output<String>? = null,
    public val attachmentName: Output<String>? = null,
    public val defendCidrLists: Output<List<String>>? = null,
    public val eniLists: Output<List<FirewallVpcFirewallCenLocalVpcEniListArgs>>? = null,
    public val manualVswitchId: Output<String>? = null,
    public val networkInstanceId: Output<String>,
    public val networkInstanceName: Output<String>? = null,
    public val networkInstanceType: Output<String>? = null,
    public val ownerId: Output<String>? = null,
    public val regionNo: Output<String>? = null,
    public val routeMode: Output<String>? = null,
    public val supportManualMode: Output<String>? = null,
    public val transitRouterId: Output<String>? = null,
    public val transitRouterType: Output<String>? = null,
    public val vpcCidrTableLists: Output<List<FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs>>? =
        null,
    public val vpcId: Output<String>? = null,
    public val vpcName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcArgs = com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcArgs.builder()
        .attachmentId(attachmentId?.applyValue({ args0 -> args0 }))
        .attachmentName(attachmentName?.applyValue({ args0 -> args0 }))
        .defendCidrLists(defendCidrLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .eniLists(
            eniLists?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .manualVswitchId(manualVswitchId?.applyValue({ args0 -> args0 }))
        .networkInstanceId(networkInstanceId.applyValue({ args0 -> args0 }))
        .networkInstanceName(networkInstanceName?.applyValue({ args0 -> args0 }))
        .networkInstanceType(networkInstanceType?.applyValue({ args0 -> args0 }))
        .ownerId(ownerId?.applyValue({ args0 -> args0 }))
        .regionNo(regionNo?.applyValue({ args0 -> args0 }))
        .routeMode(routeMode?.applyValue({ args0 -> args0 }))
        .supportManualMode(supportManualMode?.applyValue({ args0 -> args0 }))
        .transitRouterId(transitRouterId?.applyValue({ args0 -> args0 }))
        .transitRouterType(transitRouterType?.applyValue({ args0 -> args0 }))
        .vpcCidrTableLists(
            vpcCidrTableLists?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .vpcId(vpcId?.applyValue({ args0 -> args0 }))
        .vpcName(vpcName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallVpcFirewallCenLocalVpcArgs].
 */
@PulumiTagMarker
public class FirewallVpcFirewallCenLocalVpcArgsBuilder internal constructor() {
    private var attachmentId: Output<String>? = null

    private var attachmentName: Output<String>? = null

    private var defendCidrLists: Output<List<String>>? = null

    private var eniLists: Output<List<FirewallVpcFirewallCenLocalVpcEniListArgs>>? = null

    private var manualVswitchId: Output<String>? = null

    private var networkInstanceId: Output<String>? = null

    private var networkInstanceName: Output<String>? = null

    private var networkInstanceType: Output<String>? = null

    private var ownerId: Output<String>? = null

    private var regionNo: Output<String>? = null

    private var routeMode: Output<String>? = null

    private var supportManualMode: Output<String>? = null

    private var transitRouterId: Output<String>? = null

    private var transitRouterType: Output<String>? = null

    private var vpcCidrTableLists: Output<List<FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs>>? =
        null

    private var vpcId: Output<String>? = null

    private var vpcName: Output<String>? = null

    /**
     * @param value The connection ID of the network instance.
     */
    @JvmName("ngfvfgvtmfenlcdu")
    public suspend fun attachmentId(`value`: Output<String>) {
        this.attachmentId = value
    }

    /**
     * @param value The connection name of the network instance.
     */
    @JvmName("oibckcftkcjdvfwn")
    public suspend fun attachmentName(`value`: Output<String>) {
        this.attachmentName = value
    }

    /**
     * @param value The list of network segments protected by the VPC firewall.
     */
    @JvmName("whlnbjyacmfkesql")
    public suspend fun defendCidrLists(`value`: Output<List<String>>) {
        this.defendCidrLists = value
    }

    @JvmName("qqdbdcsrmfmtyukl")
    public suspend fun defendCidrLists(vararg values: Output<String>) {
        this.defendCidrLists = Output.all(values.asList())
    }

    /**
     * @param values The list of network segments protected by the VPC firewall.
     */
    @JvmName("xbesawpqnrhnddug")
    public suspend fun defendCidrLists(values: List<Output<String>>) {
        this.defendCidrLists = Output.all(values)
    }

    /**
     * @param value List of elastic network cards.
     */
    @JvmName("gfrxurnlchtvjogc")
    public suspend fun eniLists(`value`: Output<List<FirewallVpcFirewallCenLocalVpcEniListArgs>>) {
        this.eniLists = value
    }

    @JvmName("otfoeiyjxgaupvvg")
    public suspend fun eniLists(vararg values: Output<FirewallVpcFirewallCenLocalVpcEniListArgs>) {
        this.eniLists = Output.all(values.asList())
    }

    /**
     * @param values List of elastic network cards.
     */
    @JvmName("wpoiejdnwykhtkac")
    public suspend fun eniLists(values: List<Output<FirewallVpcFirewallCenLocalVpcEniListArgs>>) {
        this.eniLists = Output.all(values)
    }

    /**
     * @param value The ID of the vSwitch specified when the routing mode is manual mode.
     */
    @JvmName("txhwxpnwubmqdqus")
    public suspend fun manualVswitchId(`value`: Output<String>) {
        this.manualVswitchId = value
    }

    /**
     * @param value The ID of the VPC instance that created the VPC firewall.
     */
    @JvmName("oejqylwyiyniivxk")
    public suspend fun networkInstanceId(`value`: Output<String>) {
        this.networkInstanceId = value
    }

    /**
     * @param value The name of the network instance.
     */
    @JvmName("ljxkuugklftpdilc")
    public suspend fun networkInstanceName(`value`: Output<String>) {
        this.networkInstanceName = value
    }

    /**
     * @param value The type of the network instance. Value: **VPC * *.
     */
    @JvmName("pvetnqiibbciturs")
    public suspend fun networkInstanceType(`value`: Output<String>) {
        this.networkInstanceType = value
    }

    /**
     * @param value The UID of the Alibaba Cloud account to which the VPC belongs.
     */
    @JvmName("hfdcwixxmergsxsj")
    public suspend fun ownerId(`value`: Output<String>) {
        this.ownerId = value
    }

    /**
     * @param value The region ID of the VPC.
     */
    @JvmName("otwuvwrrqjfoyukv")
    public suspend fun regionNo(`value`: Output<String>) {
        this.regionNo = value
    }

    /**
     * @param value Routing mode,. Value:-auto: indicates automatic mode.-manual: indicates manual mode.
     */
    @JvmName("omrnhcutisowmuxf")
    public suspend fun routeMode(`value`: Output<String>) {
        this.routeMode = value
    }

    /**
     * @param value Whether routing mode supports manual mode. Value:-**1**: Supported.-**0**: Not supported.
     */
    @JvmName("goyqxnuuwoyficjq")
    public suspend fun supportManualMode(`value`: Output<String>) {
        this.supportManualMode = value
    }

    /**
     * @param value The ID of the CEN-TR instance.
     */
    @JvmName("lpjsalnocfuldjip")
    public suspend fun transitRouterId(`value`: Output<String>) {
        this.transitRouterId = value
    }

    /**
     * @param value The version of the cloud enterprise network forwarding router (CEN-TR). Value:-**Basic**: Basic Edition.-**Enterprise**: Enterprise Edition.
     */
    @JvmName("mejhmjgncuqnnjus")
    public suspend fun transitRouterType(`value`: Output<String>) {
        this.transitRouterType = value
    }

    /**
     * @param value The VPC network segment list.
     */
    @JvmName("wrsftjqwcwmqufix")
    public suspend fun vpcCidrTableLists(`value`: Output<List<FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs>>) {
        this.vpcCidrTableLists = value
    }

    @JvmName("enlfmjpdsowlbrho")
    public suspend fun vpcCidrTableLists(vararg values: Output<FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs>) {
        this.vpcCidrTableLists = Output.all(values.asList())
    }

    /**
     * @param values The VPC network segment list.
     */
    @JvmName("vbahsfktbpyfktwo")
    public suspend fun vpcCidrTableLists(values: List<Output<FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs>>) {
        this.vpcCidrTableLists = Output.all(values)
    }

    /**
     * @param value The ID of the VPC instance.
     */
    @JvmName("kilmcpnfycpiovqi")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The instance name of the VPC.
     */
    @JvmName("fayxrxvfwfyxixay")
    public suspend fun vpcName(`value`: Output<String>) {
        this.vpcName = value
    }

    /**
     * @param value The connection ID of the network instance.
     */
    @JvmName("yowbjwbrhieaolsm")
    public suspend fun attachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachmentId = mapped
    }

    /**
     * @param value The connection name of the network instance.
     */
    @JvmName("jonvisadupomnrqr")
    public suspend fun attachmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachmentName = mapped
    }

    /**
     * @param value The list of network segments protected by the VPC firewall.
     */
    @JvmName("fsaalxntebhrfsar")
    public suspend fun defendCidrLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defendCidrLists = mapped
    }

    /**
     * @param values The list of network segments protected by the VPC firewall.
     */
    @JvmName("hithldvnxumtxgjb")
    public suspend fun defendCidrLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defendCidrLists = mapped
    }

    /**
     * @param value List of elastic network cards.
     */
    @JvmName("sfrftbfmtipqbceb")
    public suspend fun eniLists(`value`: List<FirewallVpcFirewallCenLocalVpcEniListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eniLists = mapped
    }

    /**
     * @param argument List of elastic network cards.
     */
    @JvmName("cslysoliwamsarhu")
    public suspend fun eniLists(argument: List<suspend FirewallVpcFirewallCenLocalVpcEniListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallVpcFirewallCenLocalVpcEniListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.eniLists = mapped
    }

    /**
     * @param argument List of elastic network cards.
     */
    @JvmName("qpaiojdymmvbvnuj")
    public suspend fun eniLists(vararg argument: suspend FirewallVpcFirewallCenLocalVpcEniListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirewallVpcFirewallCenLocalVpcEniListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.eniLists = mapped
    }

    /**
     * @param argument List of elastic network cards.
     */
    @JvmName("iebljuaefiwstxja")
    public suspend fun eniLists(argument: suspend FirewallVpcFirewallCenLocalVpcEniListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FirewallVpcFirewallCenLocalVpcEniListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.eniLists = mapped
    }

    /**
     * @param values List of elastic network cards.
     */
    @JvmName("bvouqmkxeocvydej")
    public suspend fun eniLists(vararg values: FirewallVpcFirewallCenLocalVpcEniListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eniLists = mapped
    }

    /**
     * @param value The ID of the vSwitch specified when the routing mode is manual mode.
     */
    @JvmName("jtyjkcyyxrnkcqod")
    public suspend fun manualVswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manualVswitchId = mapped
    }

    /**
     * @param value The ID of the VPC instance that created the VPC firewall.
     */
    @JvmName("svuteefgkxwlpdlk")
    public suspend fun networkInstanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInstanceId = mapped
    }

    /**
     * @param value The name of the network instance.
     */
    @JvmName("chespubnewtpqkjn")
    public suspend fun networkInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInstanceName = mapped
    }

    /**
     * @param value The type of the network instance. Value: **VPC * *.
     */
    @JvmName("yacchudonprplwni")
    public suspend fun networkInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInstanceType = mapped
    }

    /**
     * @param value The UID of the Alibaba Cloud account to which the VPC belongs.
     */
    @JvmName("ivomydnaxspqukmu")
    public suspend fun ownerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerId = mapped
    }

    /**
     * @param value The region ID of the VPC.
     */
    @JvmName("jwrelcxkcpitbmny")
    public suspend fun regionNo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionNo = mapped
    }

    /**
     * @param value Routing mode,. Value:-auto: indicates automatic mode.-manual: indicates manual mode.
     */
    @JvmName("apuatkhwxqdaxndj")
    public suspend fun routeMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeMode = mapped
    }

    /**
     * @param value Whether routing mode supports manual mode. Value:-**1**: Supported.-**0**: Not supported.
     */
    @JvmName("puipsevggberdemd")
    public suspend fun supportManualMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportManualMode = mapped
    }

    /**
     * @param value The ID of the CEN-TR instance.
     */
    @JvmName("ayvcywlbbqkicggy")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterId = mapped
    }

    /**
     * @param value The version of the cloud enterprise network forwarding router (CEN-TR). Value:-**Basic**: Basic Edition.-**Enterprise**: Enterprise Edition.
     */
    @JvmName("hmuuwakcoegqbwnr")
    public suspend fun transitRouterType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterType = mapped
    }

    /**
     * @param value The VPC network segment list.
     */
    @JvmName("uwxjblegqjwdsjwq")
    public suspend fun vpcCidrTableLists(`value`: List<FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcCidrTableLists = mapped
    }

    /**
     * @param argument The VPC network segment list.
     */
    @JvmName("rwwacfobbevdfdlq")
    public suspend fun vpcCidrTableLists(argument: List<suspend FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vpcCidrTableLists = mapped
    }

    /**
     * @param argument The VPC network segment list.
     */
    @JvmName("pbrbdgkxtoycaehp")
    public suspend fun vpcCidrTableLists(vararg argument: suspend FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vpcCidrTableLists = mapped
    }

    /**
     * @param argument The VPC network segment list.
     */
    @JvmName("lydwtgiratqjqhtl")
    public suspend fun vpcCidrTableLists(argument: suspend FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.vpcCidrTableLists = mapped
    }

    /**
     * @param values The VPC network segment list.
     */
    @JvmName("eltkheogmymeyfqs")
    public suspend fun vpcCidrTableLists(vararg values: FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcCidrTableLists = mapped
    }

    /**
     * @param value The ID of the VPC instance.
     */
    @JvmName("shqnfhcvsaovogqk")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The instance name of the VPC.
     */
    @JvmName("hecntrmnqggkacmo")
    public suspend fun vpcName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcName = mapped
    }

    internal fun build(): FirewallVpcFirewallCenLocalVpcArgs = FirewallVpcFirewallCenLocalVpcArgs(
        attachmentId = attachmentId,
        attachmentName = attachmentName,
        defendCidrLists = defendCidrLists,
        eniLists = eniLists,
        manualVswitchId = manualVswitchId,
        networkInstanceId = networkInstanceId ?: throw PulumiNullFieldException("networkInstanceId"),
        networkInstanceName = networkInstanceName,
        networkInstanceType = networkInstanceType,
        ownerId = ownerId,
        regionNo = regionNo,
        routeMode = routeMode,
        supportManualMode = supportManualMode,
        transitRouterId = transitRouterId,
        transitRouterType = transitRouterType,
        vpcCidrTableLists = vpcCidrTableLists,
        vpcId = vpcId,
        vpcName = vpcName,
    )
}
