@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcEniListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eniId The ID of the instance of the ENI in the VPC.
 * @property eniPrivateIpAddress The private IP address of the ENI in the VPC.
 */
public data class FirewallVpcFirewallCenLocalVpcEniListArgs(
    public val eniId: Output<String>? = null,
    public val eniPrivateIpAddress: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcEniListArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcEniListArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcEniListArgs.builder()
            .eniId(eniId?.applyValue({ args0 -> args0 }))
            .eniPrivateIpAddress(eniPrivateIpAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallVpcFirewallCenLocalVpcEniListArgs].
 */
@PulumiTagMarker
public class FirewallVpcFirewallCenLocalVpcEniListArgsBuilder internal constructor() {
    private var eniId: Output<String>? = null

    private var eniPrivateIpAddress: Output<String>? = null

    /**
     * @param value The ID of the instance of the ENI in the VPC.
     */
    @JvmName("adwfidxdecnbpiiw")
    public suspend fun eniId(`value`: Output<String>) {
        this.eniId = value
    }

    /**
     * @param value The private IP address of the ENI in the VPC.
     */
    @JvmName("njusrtxdflyolbmt")
    public suspend fun eniPrivateIpAddress(`value`: Output<String>) {
        this.eniPrivateIpAddress = value
    }

    /**
     * @param value The ID of the instance of the ENI in the VPC.
     */
    @JvmName("xndrcbavkcpdtiqo")
    public suspend fun eniId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eniId = mapped
    }

    /**
     * @param value The private IP address of the ENI in the VPC.
     */
    @JvmName("kxhxgguidodoedjh")
    public suspend fun eniPrivateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eniPrivateIpAddress = mapped
    }

    internal fun build(): FirewallVpcFirewallCenLocalVpcEniListArgs =
        FirewallVpcFirewallCenLocalVpcEniListArgs(
            eniId = eniId,
            eniPrivateIpAddress = eniPrivateIpAddress,
        )
}
