@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property routeEntryLists The list of route entries in the VPC.
 * @property routeTableId The ID of the route table of the VPC.
 */
public data class FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs(
    public val routeEntryLists: Output<List<FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs>>? = null,
    public val routeTableId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs.builder()
            .routeEntryLists(
                routeEntryLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .routeTableId(routeTableId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs].
 */
@PulumiTagMarker
public class FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgsBuilder internal constructor() {
    private var routeEntryLists:
        Output<List<FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs>>? = null

    private var routeTableId: Output<String>? = null

    /**
     * @param value The list of route entries in the VPC.
     */
    @JvmName("tddiylywuawcmhxr")
    public suspend fun routeEntryLists(`value`: Output<List<FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs>>) {
        this.routeEntryLists = value
    }

    @JvmName("tfcjxvjcdhctwagd")
    public suspend fun routeEntryLists(vararg values: Output<FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs>) {
        this.routeEntryLists = Output.all(values.asList())
    }

    /**
     * @param values The list of route entries in the VPC.
     */
    @JvmName("ewkbfmquibcqteim")
    public suspend fun routeEntryLists(values: List<Output<FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs>>) {
        this.routeEntryLists = Output.all(values)
    }

    /**
     * @param value The ID of the route table of the VPC.
     */
    @JvmName("ypsnqgqkjqntptfd")
    public suspend fun routeTableId(`value`: Output<String>) {
        this.routeTableId = value
    }

    /**
     * @param value The list of route entries in the VPC.
     */
    @JvmName("fopcwiochchlfoag")
    public suspend fun routeEntryLists(`value`: List<FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeEntryLists = mapped
    }

    /**
     * @param argument The list of route entries in the VPC.
     */
    @JvmName("sykaoplhooilgkyr")
    public suspend fun routeEntryLists(argument: List<suspend FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routeEntryLists = mapped
    }

    /**
     * @param argument The list of route entries in the VPC.
     */
    @JvmName("jtylpaaswhkiugds")
    public suspend fun routeEntryLists(vararg argument: suspend FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routeEntryLists = mapped
    }

    /**
     * @param argument The list of route entries in the VPC.
     */
    @JvmName("danesiietsxtojcg")
    public suspend fun routeEntryLists(argument: suspend FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.routeEntryLists = mapped
    }

    /**
     * @param values The list of route entries in the VPC.
     */
    @JvmName("gttgtcodctccomvf")
    public suspend fun routeEntryLists(vararg values: FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeEntryLists = mapped
    }

    /**
     * @param value The ID of the route table of the VPC.
     */
    @JvmName("ftdbhgwtttpojkwa")
    public suspend fun routeTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableId = mapped
    }

    internal fun build(): FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs =
        FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs(
            routeEntryLists = routeEntryLists,
            routeTableId = routeTableId,
        )
}
