@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destinationCidr The target network segment of the VPC.
 * @property nextHopInstanceId The ID of the next hop instance in the VPC.
 */
public data class FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs(
    public val destinationCidr: Output<String>? = null,
    public val nextHopInstanceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs.builder()
            .destinationCidr(destinationCidr?.applyValue({ args0 -> args0 }))
            .nextHopInstanceId(nextHopInstanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs].
 */
@PulumiTagMarker
public class FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgsBuilder internal constructor() {
    private var destinationCidr: Output<String>? = null

    private var nextHopInstanceId: Output<String>? = null

    /**
     * @param value The target network segment of the VPC.
     */
    @JvmName("pqovsdybmaqcwikx")
    public suspend fun destinationCidr(`value`: Output<String>) {
        this.destinationCidr = value
    }

    /**
     * @param value The ID of the next hop instance in the VPC.
     */
    @JvmName("gydjqantxgttmlys")
    public suspend fun nextHopInstanceId(`value`: Output<String>) {
        this.nextHopInstanceId = value
    }

    /**
     * @param value The target network segment of the VPC.
     */
    @JvmName("avvatcrejiblaotl")
    public suspend fun destinationCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationCidr = mapped
    }

    /**
     * @param value The ID of the next hop instance in the VPC.
     */
    @JvmName("ratgfaijhdxsibjd")
    public suspend fun nextHopInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextHopInstanceId = mapped
    }

    internal fun build(): FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs =
        FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs(
            destinationCidr = destinationCidr,
            nextHopInstanceId = nextHopInstanceId,
        )
}
