@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallLocalVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property eniId The ID of the instance of the ENI in the peer VPC.
 * @property eniPrivateIpAddress The private IP address of the elastic network card in the peer VPC.
 * @property localVpcCidrTableLists The network segment list of the local VPC. See `local_vpc_cidr_table_list` below.
 * @property regionNo The region ID of the local VPC.
 * @property routerInterfaceId The ID of the router interface in the peer VPC.
 * @property vpcId The ID of the local VPC instance.
 * @property vpcName The instance name of the peer VPC.
 */
public data class FirewallVpcFirewallLocalVpcArgs(
    public val eniId: Output<String>? = null,
    public val eniPrivateIpAddress: Output<String>? = null,
    public val localVpcCidrTableLists: Output<List<FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs>>,
    public val regionNo: Output<String>,
    public val routerInterfaceId: Output<String>? = null,
    public val vpcId: Output<String>,
    public val vpcName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallLocalVpcArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallLocalVpcArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallLocalVpcArgs.builder()
            .eniId(eniId?.applyValue({ args0 -> args0 }))
            .eniPrivateIpAddress(eniPrivateIpAddress?.applyValue({ args0 -> args0 }))
            .localVpcCidrTableLists(
                localVpcCidrTableLists.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .regionNo(regionNo.applyValue({ args0 -> args0 }))
            .routerInterfaceId(routerInterfaceId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId.applyValue({ args0 -> args0 }))
            .vpcName(vpcName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallVpcFirewallLocalVpcArgs].
 */
@PulumiTagMarker
public class FirewallVpcFirewallLocalVpcArgsBuilder internal constructor() {
    private var eniId: Output<String>? = null

    private var eniPrivateIpAddress: Output<String>? = null

    private var localVpcCidrTableLists:
        Output<List<FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs>>? = null

    private var regionNo: Output<String>? = null

    private var routerInterfaceId: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vpcName: Output<String>? = null

    /**
     * @param value The ID of the instance of the ENI in the peer VPC.
     */
    @JvmName("apqdnttuponxupdj")
    public suspend fun eniId(`value`: Output<String>) {
        this.eniId = value
    }

    /**
     * @param value The private IP address of the elastic network card in the peer VPC.
     */
    @JvmName("pftbntkrjavflsdo")
    public suspend fun eniPrivateIpAddress(`value`: Output<String>) {
        this.eniPrivateIpAddress = value
    }

    /**
     * @param value The network segment list of the local VPC. See `local_vpc_cidr_table_list` below.
     */
    @JvmName("sqkxainxinipvrxk")
    public suspend fun localVpcCidrTableLists(`value`: Output<List<FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs>>) {
        this.localVpcCidrTableLists = value
    }

    @JvmName("pjwbutedjjugdgcu")
    public suspend fun localVpcCidrTableLists(vararg values: Output<FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs>) {
        this.localVpcCidrTableLists = Output.all(values.asList())
    }

    /**
     * @param values The network segment list of the local VPC. See `local_vpc_cidr_table_list` below.
     */
    @JvmName("syegtbbnilqexiix")
    public suspend fun localVpcCidrTableLists(values: List<Output<FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs>>) {
        this.localVpcCidrTableLists = Output.all(values)
    }

    /**
     * @param value The region ID of the local VPC.
     */
    @JvmName("gkseriviwcpdfxuf")
    public suspend fun regionNo(`value`: Output<String>) {
        this.regionNo = value
    }

    /**
     * @param value The ID of the router interface in the peer VPC.
     */
    @JvmName("pkluthmmeqworctg")
    public suspend fun routerInterfaceId(`value`: Output<String>) {
        this.routerInterfaceId = value
    }

    /**
     * @param value The ID of the local VPC instance.
     */
    @JvmName("ycycnknekwqepylv")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The instance name of the peer VPC.
     */
    @JvmName("rdyocrcrpmexybak")
    public suspend fun vpcName(`value`: Output<String>) {
        this.vpcName = value
    }

    /**
     * @param value The ID of the instance of the ENI in the peer VPC.
     */
    @JvmName("fpvkvhgmxcgfqatv")
    public suspend fun eniId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eniId = mapped
    }

    /**
     * @param value The private IP address of the elastic network card in the peer VPC.
     */
    @JvmName("jpsuwqbvhfqdlhhy")
    public suspend fun eniPrivateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eniPrivateIpAddress = mapped
    }

    /**
     * @param value The network segment list of the local VPC. See `local_vpc_cidr_table_list` below.
     */
    @JvmName("aphlxmgvtiwpvwem")
    public suspend fun localVpcCidrTableLists(`value`: List<FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localVpcCidrTableLists = mapped
    }

    /**
     * @param argument The network segment list of the local VPC. See `local_vpc_cidr_table_list` below.
     */
    @JvmName("lfpkdgvmdotrjfet")
    public suspend fun localVpcCidrTableLists(argument: List<suspend FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.localVpcCidrTableLists = mapped
    }

    /**
     * @param argument The network segment list of the local VPC. See `local_vpc_cidr_table_list` below.
     */
    @JvmName("aoqolycyugtrgqma")
    public suspend fun localVpcCidrTableLists(vararg argument: suspend FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.localVpcCidrTableLists = mapped
    }

    /**
     * @param argument The network segment list of the local VPC. See `local_vpc_cidr_table_list` below.
     */
    @JvmName("avobilqrgcpeknww")
    public suspend fun localVpcCidrTableLists(argument: suspend FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.localVpcCidrTableLists = mapped
    }

    /**
     * @param values The network segment list of the local VPC. See `local_vpc_cidr_table_list` below.
     */
    @JvmName("yryporsnhemrymrj")
    public suspend fun localVpcCidrTableLists(vararg values: FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localVpcCidrTableLists = mapped
    }

    /**
     * @param value The region ID of the local VPC.
     */
    @JvmName("otovddklxfaddbno")
    public suspend fun regionNo(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionNo = mapped
    }

    /**
     * @param value The ID of the router interface in the peer VPC.
     */
    @JvmName("vjwvmyafpyitlixq")
    public suspend fun routerInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routerInterfaceId = mapped
    }

    /**
     * @param value The ID of the local VPC instance.
     */
    @JvmName("qnjnlcwrigrwhata")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The instance name of the peer VPC.
     */
    @JvmName("qpsxvybvpbavavvj")
    public suspend fun vpcName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcName = mapped
    }

    internal fun build(): FirewallVpcFirewallLocalVpcArgs = FirewallVpcFirewallLocalVpcArgs(
        eniId = eniId,
        eniPrivateIpAddress = eniPrivateIpAddress,
        localVpcCidrTableLists = localVpcCidrTableLists ?: throw
            PulumiNullFieldException("localVpcCidrTableLists"),
        regionNo = regionNo ?: throw PulumiNullFieldException("regionNo"),
        routerInterfaceId = routerInterfaceId,
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
        vpcName = vpcName,
    )
}
