@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property localRouteEntryLists The list of route entries of the local VPC. See `local_route_entry_list` below.
 * @property localRouteTableId The ID of the route table of the local VPC.
 */
public data class FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs(
    public val localRouteEntryLists: Output<List<FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs>>,
    public val localRouteTableId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs.builder()
            .localRouteEntryLists(
                localRouteEntryLists.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .localRouteTableId(localRouteTableId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs].
 */
@PulumiTagMarker
public class FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgsBuilder internal constructor() {
    private var localRouteEntryLists:
        Output<List<FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs>>? = null

    private var localRouteTableId: Output<String>? = null

    /**
     * @param value The list of route entries of the local VPC. See `local_route_entry_list` below.
     */
    @JvmName("agpojixackxwqatf")
    public suspend fun localRouteEntryLists(`value`: Output<List<FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs>>) {
        this.localRouteEntryLists = value
    }

    @JvmName("cprypbqiwibpmfuq")
    public suspend fun localRouteEntryLists(vararg values: Output<FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs>) {
        this.localRouteEntryLists = Output.all(values.asList())
    }

    /**
     * @param values The list of route entries of the local VPC. See `local_route_entry_list` below.
     */
    @JvmName("gqxygpehllitaums")
    public suspend fun localRouteEntryLists(values: List<Output<FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs>>) {
        this.localRouteEntryLists = Output.all(values)
    }

    /**
     * @param value The ID of the route table of the local VPC.
     */
    @JvmName("hgmcrnprjculuvbt")
    public suspend fun localRouteTableId(`value`: Output<String>) {
        this.localRouteTableId = value
    }

    /**
     * @param value The list of route entries of the local VPC. See `local_route_entry_list` below.
     */
    @JvmName("dfjqkflfewewoahu")
    public suspend fun localRouteEntryLists(`value`: List<FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localRouteEntryLists = mapped
    }

    /**
     * @param argument The list of route entries of the local VPC. See `local_route_entry_list` below.
     */
    @JvmName("cyevtrmfwcxpxnpq")
    public suspend fun localRouteEntryLists(argument: List<suspend FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.localRouteEntryLists = mapped
    }

    /**
     * @param argument The list of route entries of the local VPC. See `local_route_entry_list` below.
     */
    @JvmName("ggquykbbfweefrle")
    public suspend fun localRouteEntryLists(vararg argument: suspend FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.localRouteEntryLists = mapped
    }

    /**
     * @param argument The list of route entries of the local VPC. See `local_route_entry_list` below.
     */
    @JvmName("gbwshqttobbefmrl")
    public suspend fun localRouteEntryLists(argument: suspend FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.localRouteEntryLists = mapped
    }

    /**
     * @param values The list of route entries of the local VPC. See `local_route_entry_list` below.
     */
    @JvmName("tpglfddekvvqvblg")
    public suspend fun localRouteEntryLists(vararg values: FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localRouteEntryLists = mapped
    }

    /**
     * @param value The ID of the route table of the local VPC.
     */
    @JvmName("iynuyrvdcymdntqs")
    public suspend fun localRouteTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localRouteTableId = mapped
    }

    internal fun build(): FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs =
        FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs(
            localRouteEntryLists = localRouteEntryLists ?: throw
                PulumiNullFieldException("localRouteEntryLists"),
            localRouteTableId = localRouteTableId ?: throw PulumiNullFieldException("localRouteTableId"),
        )
}
