@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property localDestinationCidr The target network segment of the local VPC.
 * @property localNextHopInstanceId The ID of the next-hop instance in the local VPC.
 */
public data class FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs(
    public val localDestinationCidr: Output<String>,
    public val localNextHopInstanceId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs.builder()
            .localDestinationCidr(localDestinationCidr.applyValue({ args0 -> args0 }))
            .localNextHopInstanceId(localNextHopInstanceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs].
 */
@PulumiTagMarker
public class FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgsBuilder internal constructor() {
    private var localDestinationCidr: Output<String>? = null

    private var localNextHopInstanceId: Output<String>? = null

    /**
     * @param value The target network segment of the local VPC.
     */
    @JvmName("hjhxrmwjpylylyay")
    public suspend fun localDestinationCidr(`value`: Output<String>) {
        this.localDestinationCidr = value
    }

    /**
     * @param value The ID of the next-hop instance in the local VPC.
     */
    @JvmName("dfkplvkloxsxiolc")
    public suspend fun localNextHopInstanceId(`value`: Output<String>) {
        this.localNextHopInstanceId = value
    }

    /**
     * @param value The target network segment of the local VPC.
     */
    @JvmName("wmhilbhtwyeqanbk")
    public suspend fun localDestinationCidr(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localDestinationCidr = mapped
    }

    /**
     * @param value The ID of the next-hop instance in the local VPC.
     */
    @JvmName("odpbjdhtadgfsnfp")
    public suspend fun localNextHopInstanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localNextHopInstanceId = mapped
    }

    internal fun build(): FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs =
        FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs(
            localDestinationCidr = localDestinationCidr ?: throw
                PulumiNullFieldException("localDestinationCidr"),
            localNextHopInstanceId = localNextHopInstanceId ?: throw
                PulumiNullFieldException("localNextHopInstanceId"),
        )
}
