@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallPeerVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property eniId The ID of the instance of the ENI in the peer VPC.
 * @property eniPrivateIpAddress The private IP address of the elastic network card in the peer VPC.
 * @property peerVpcCidrTableLists The network segment list of the peer VPC. See `peer_vpc_cidr_table_list` below.
 * @property regionNo The region ID of the peer VPC.
 * @property routerInterfaceId The ID of the router interface in the peer VPC.
 * @property vpcId The ID of the peer VPC instance.
 * @property vpcName The instance name of the peer VPC.
 */
public data class FirewallVpcFirewallPeerVpcArgs(
    public val eniId: Output<String>? = null,
    public val eniPrivateIpAddress: Output<String>? = null,
    public val peerVpcCidrTableLists: Output<List<FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs>>,
    public val regionNo: Output<String>,
    public val routerInterfaceId: Output<String>? = null,
    public val vpcId: Output<String>,
    public val vpcName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallPeerVpcArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallPeerVpcArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallPeerVpcArgs.builder()
            .eniId(eniId?.applyValue({ args0 -> args0 }))
            .eniPrivateIpAddress(eniPrivateIpAddress?.applyValue({ args0 -> args0 }))
            .peerVpcCidrTableLists(
                peerVpcCidrTableLists.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .regionNo(regionNo.applyValue({ args0 -> args0 }))
            .routerInterfaceId(routerInterfaceId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId.applyValue({ args0 -> args0 }))
            .vpcName(vpcName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallVpcFirewallPeerVpcArgs].
 */
@PulumiTagMarker
public class FirewallVpcFirewallPeerVpcArgsBuilder internal constructor() {
    private var eniId: Output<String>? = null

    private var eniPrivateIpAddress: Output<String>? = null

    private var peerVpcCidrTableLists:
        Output<List<FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs>>? = null

    private var regionNo: Output<String>? = null

    private var routerInterfaceId: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vpcName: Output<String>? = null

    /**
     * @param value The ID of the instance of the ENI in the peer VPC.
     */
    @JvmName("xlebwfuttvuupmbt")
    public suspend fun eniId(`value`: Output<String>) {
        this.eniId = value
    }

    /**
     * @param value The private IP address of the elastic network card in the peer VPC.
     */
    @JvmName("yiphddxyxyicsqsg")
    public suspend fun eniPrivateIpAddress(`value`: Output<String>) {
        this.eniPrivateIpAddress = value
    }

    /**
     * @param value The network segment list of the peer VPC. See `peer_vpc_cidr_table_list` below.
     */
    @JvmName("qhyusipcesrdhcab")
    public suspend fun peerVpcCidrTableLists(`value`: Output<List<FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs>>) {
        this.peerVpcCidrTableLists = value
    }

    @JvmName("qjdljwsijnquawua")
    public suspend fun peerVpcCidrTableLists(vararg values: Output<FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs>) {
        this.peerVpcCidrTableLists = Output.all(values.asList())
    }

    /**
     * @param values The network segment list of the peer VPC. See `peer_vpc_cidr_table_list` below.
     */
    @JvmName("vqhlpvhsppdugruw")
    public suspend fun peerVpcCidrTableLists(values: List<Output<FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs>>) {
        this.peerVpcCidrTableLists = Output.all(values)
    }

    /**
     * @param value The region ID of the peer VPC.
     */
    @JvmName("rilrowvcnjtjnlcq")
    public suspend fun regionNo(`value`: Output<String>) {
        this.regionNo = value
    }

    /**
     * @param value The ID of the router interface in the peer VPC.
     */
    @JvmName("enhrfxitwaedqmjn")
    public suspend fun routerInterfaceId(`value`: Output<String>) {
        this.routerInterfaceId = value
    }

    /**
     * @param value The ID of the peer VPC instance.
     */
    @JvmName("yhcprjjwfggdxlqj")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The instance name of the peer VPC.
     */
    @JvmName("tgjllfdwvfsqrdmx")
    public suspend fun vpcName(`value`: Output<String>) {
        this.vpcName = value
    }

    /**
     * @param value The ID of the instance of the ENI in the peer VPC.
     */
    @JvmName("pvpmetdbskyhlsuk")
    public suspend fun eniId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eniId = mapped
    }

    /**
     * @param value The private IP address of the elastic network card in the peer VPC.
     */
    @JvmName("vkvvnlgfvtoqanxy")
    public suspend fun eniPrivateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eniPrivateIpAddress = mapped
    }

    /**
     * @param value The network segment list of the peer VPC. See `peer_vpc_cidr_table_list` below.
     */
    @JvmName("lhigtwuopyrnxyha")
    public suspend fun peerVpcCidrTableLists(`value`: List<FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peerVpcCidrTableLists = mapped
    }

    /**
     * @param argument The network segment list of the peer VPC. See `peer_vpc_cidr_table_list` below.
     */
    @JvmName("hlfndlexvqcfppdc")
    public suspend fun peerVpcCidrTableLists(argument: List<suspend FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.peerVpcCidrTableLists = mapped
    }

    /**
     * @param argument The network segment list of the peer VPC. See `peer_vpc_cidr_table_list` below.
     */
    @JvmName("tumseykpsepnowed")
    public suspend fun peerVpcCidrTableLists(vararg argument: suspend FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.peerVpcCidrTableLists = mapped
    }

    /**
     * @param argument The network segment list of the peer VPC. See `peer_vpc_cidr_table_list` below.
     */
    @JvmName("ykufoawisvtgoeky")
    public suspend fun peerVpcCidrTableLists(argument: suspend FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.peerVpcCidrTableLists = mapped
    }

    /**
     * @param values The network segment list of the peer VPC. See `peer_vpc_cidr_table_list` below.
     */
    @JvmName("seqnkactochxwsyo")
    public suspend fun peerVpcCidrTableLists(vararg values: FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peerVpcCidrTableLists = mapped
    }

    /**
     * @param value The region ID of the peer VPC.
     */
    @JvmName("gdxsphbackgppqkb")
    public suspend fun regionNo(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionNo = mapped
    }

    /**
     * @param value The ID of the router interface in the peer VPC.
     */
    @JvmName("swfsfcmvlruragql")
    public suspend fun routerInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routerInterfaceId = mapped
    }

    /**
     * @param value The ID of the peer VPC instance.
     */
    @JvmName("klncieuctefetwbw")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The instance name of the peer VPC.
     */
    @JvmName("tvjesjjyqixbktem")
    public suspend fun vpcName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcName = mapped
    }

    internal fun build(): FirewallVpcFirewallPeerVpcArgs = FirewallVpcFirewallPeerVpcArgs(
        eniId = eniId,
        eniPrivateIpAddress = eniPrivateIpAddress,
        peerVpcCidrTableLists = peerVpcCidrTableLists ?: throw
            PulumiNullFieldException("peerVpcCidrTableLists"),
        regionNo = regionNo ?: throw PulumiNullFieldException("regionNo"),
        routerInterfaceId = routerInterfaceId,
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
        vpcName = vpcName,
    )
}
