@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property peerRouteEntryLists Peer VPC route entry list information. See `peer_route_entry_list` below.
 * @property peerRouteTableId The ID of the route table of the peer VPC.
 */
public data class FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs(
    public val peerRouteEntryLists: Output<List<FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs>>,
    public val peerRouteTableId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs.builder()
            .peerRouteEntryLists(
                peerRouteEntryLists.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .peerRouteTableId(peerRouteTableId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs].
 */
@PulumiTagMarker
public class FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgsBuilder internal constructor() {
    private var peerRouteEntryLists:
        Output<List<FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs>>? = null

    private var peerRouteTableId: Output<String>? = null

    /**
     * @param value Peer VPC route entry list information. See `peer_route_entry_list` below.
     */
    @JvmName("hamfvyupnxyykcte")
    public suspend fun peerRouteEntryLists(`value`: Output<List<FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs>>) {
        this.peerRouteEntryLists = value
    }

    @JvmName("wlypajfidhomiffn")
    public suspend fun peerRouteEntryLists(vararg values: Output<FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs>) {
        this.peerRouteEntryLists = Output.all(values.asList())
    }

    /**
     * @param values Peer VPC route entry list information. See `peer_route_entry_list` below.
     */
    @JvmName("gvoorsktnnkkddct")
    public suspend fun peerRouteEntryLists(values: List<Output<FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs>>) {
        this.peerRouteEntryLists = Output.all(values)
    }

    /**
     * @param value The ID of the route table of the peer VPC.
     */
    @JvmName("nvpaychfssyulysf")
    public suspend fun peerRouteTableId(`value`: Output<String>) {
        this.peerRouteTableId = value
    }

    /**
     * @param value Peer VPC route entry list information. See `peer_route_entry_list` below.
     */
    @JvmName("xrktwlpxtsuwwulg")
    public suspend fun peerRouteEntryLists(`value`: List<FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peerRouteEntryLists = mapped
    }

    /**
     * @param argument Peer VPC route entry list information. See `peer_route_entry_list` below.
     */
    @JvmName("qetfohrhwogbnoul")
    public suspend fun peerRouteEntryLists(argument: List<suspend FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.peerRouteEntryLists = mapped
    }

    /**
     * @param argument Peer VPC route entry list information. See `peer_route_entry_list` below.
     */
    @JvmName("vkgulroktxgomkhy")
    public suspend fun peerRouteEntryLists(vararg argument: suspend FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.peerRouteEntryLists = mapped
    }

    /**
     * @param argument Peer VPC route entry list information. See `peer_route_entry_list` below.
     */
    @JvmName("xiwcvamalbaarhut")
    public suspend fun peerRouteEntryLists(argument: suspend FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.peerRouteEntryLists = mapped
    }

    /**
     * @param values Peer VPC route entry list information. See `peer_route_entry_list` below.
     */
    @JvmName("dhhbidiuhlmvtduj")
    public suspend fun peerRouteEntryLists(vararg values: FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peerRouteEntryLists = mapped
    }

    /**
     * @param value The ID of the route table of the peer VPC.
     */
    @JvmName("spdoomcpqmofbajl")
    public suspend fun peerRouteTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peerRouteTableId = mapped
    }

    internal fun build(): FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs =
        FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs(
            peerRouteEntryLists = peerRouteEntryLists ?: throw PulumiNullFieldException("peerRouteEntryLists"),
            peerRouteTableId = peerRouteTableId ?: throw PulumiNullFieldException("peerRouteTableId"),
        )
}
