@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property peerDestinationCidr The target network segment of the peer VPC.
 * @property peerNextHopInstanceId The ID of the next-hop instance in the peer VPC.
 */
public data class FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs(
    public val peerDestinationCidr: Output<String>,
    public val peerNextHopInstanceId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs.builder()
            .peerDestinationCidr(peerDestinationCidr.applyValue({ args0 -> args0 }))
            .peerNextHopInstanceId(peerNextHopInstanceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs].
 */
@PulumiTagMarker
public class FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgsBuilder internal constructor() {
    private var peerDestinationCidr: Output<String>? = null

    private var peerNextHopInstanceId: Output<String>? = null

    /**
     * @param value The target network segment of the peer VPC.
     */
    @JvmName("vnnvyltwmepuxdju")
    public suspend fun peerDestinationCidr(`value`: Output<String>) {
        this.peerDestinationCidr = value
    }

    /**
     * @param value The ID of the next-hop instance in the peer VPC.
     */
    @JvmName("jdrpivpydnajtywl")
    public suspend fun peerNextHopInstanceId(`value`: Output<String>) {
        this.peerNextHopInstanceId = value
    }

    /**
     * @param value The target network segment of the peer VPC.
     */
    @JvmName("ixjvtuinhidyvwlf")
    public suspend fun peerDestinationCidr(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peerDestinationCidr = mapped
    }

    /**
     * @param value The ID of the next-hop instance in the peer VPC.
     */
    @JvmName("tutusbsykylowbho")
    public suspend fun peerNextHopInstanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peerNextHopInstanceId = mapped
    }

    internal fun build(): FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs =
        FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs(
            peerDestinationCidr = peerDestinationCidr ?: throw PulumiNullFieldException("peerDestinationCidr"),
            peerNextHopInstanceId = peerNextHopInstanceId ?: throw
                PulumiNullFieldException("peerNextHopInstanceId"),
        )
}
