@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.GetAddressBooksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAddressBooks.
 * @property groupType The type of the Address Book. Valid values: `ip`, `ipv6`, `domain`, `port`, `tag`.
 * **NOTE:** From version 1.213.1, `group_type` can be set to `ipv6`, `domain`, `port`.
 * @property ids A list of Address Book IDs.
 * @property nameRegex A regex string to filter results Address Book name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetAddressBooksPlainArgs(
    public val groupType: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.GetAddressBooksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.GetAddressBooksPlainArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.GetAddressBooksPlainArgs.builder()
            .groupType(groupType?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAddressBooksPlainArgs].
 */
@PulumiTagMarker
public class GetAddressBooksPlainArgsBuilder internal constructor() {
    private var groupType: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The type of the Address Book. Valid values: `ip`, `ipv6`, `domain`, `port`, `tag`.
     * **NOTE:** From version 1.213.1, `group_type` can be set to `ipv6`, `domain`, `port`.
     */
    @JvmName("ltiyprqiiivgkprl")
    public suspend fun groupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupType = mapped
    }

    /**
     * @param value A list of Address Book IDs.
     */
    @JvmName("embcaauadamjmwhh")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Address Book IDs.
     */
    @JvmName("qfjqrnjkgubeqpls")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results Address Book name.
     */
    @JvmName("yndyytldmnpidwao")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wwfgkuqntiybvuba")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetAddressBooksPlainArgs = GetAddressBooksPlainArgs(
        groupType = groupType,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
